/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import java.util.Collections;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.service.types.helper.ElementEditHelper;
import org.eclipse.papyrus.uml.service.types.utils.RequestParameterUtils;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.UMLPackage;

public class LifelineEditHelper
extends ElementEditHelper {
    protected void configureRequest(IEditCommandRequest request) {
        if (request instanceof CreateElementRequest) {
            Object containerParam;
            CreateElementRequest createRequest = (CreateElementRequest)request;
            EObject container = createRequest.getContainer();
            if (container instanceof Lifeline) {
                createRequest.getParameters().put("Element Covers this one", container);
                RequestParameterUtils.setCoveredLifelines((IEditCommandRequest)createRequest, Collections.singleton((Lifeline)container));
            }
            IElementType elementtype = createRequest.getElementType();
            if (UMLPackage.eINSTANCE.getExecutionSpecification().isSuperTypeOf(elementtype.getEClass()) && ((containerParam = request.getParameters().get("InteractionFragment Container")) instanceof Interaction || containerParam instanceof InteractionOperand)) {
                EObject newContainer = (EObject)containerParam;
                if (newContainer instanceof Interaction) {
                    createRequest.setContainer(newContainer);
                    createRequest.setContainmentFeature(UMLPackage.eINSTANCE.getInteraction_Fragment());
                } else if (newContainer instanceof InteractionOperand) {
                    createRequest.setContainer(newContainer);
                    createRequest.setContainmentFeature(UMLPackage.eINSTANCE.getInteractionOperand_Fragment());
                }
            }
        }
        super.configureRequest(request);
    }

    protected ICommand getDestroyElementCommand(DestroyElementRequest req) {
        EObject objectToDelete = req.getElementToDestroy();
        if (objectToDelete instanceof Lifeline) {
            ICommand deleteCommand;
            Lifeline lifeline = (Lifeline)objectToDelete;
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)objectToDelete);
            if (provider != null && (deleteCommand = super.getDestroyElementCommand(req)) != null) {
                CompositeCommand deleteElementsCommand = new CompositeCommand(req.getLabel());
                deleteElementsCommand.add((IUndoableOperation)deleteCommand);
                for (InteractionFragment interactionFragment : lifeline.getCoveredBys()) {
                    if (interactionFragment.getCovereds().size() != 1) continue;
                    DestroyElementRequest destroyRequest = new DestroyElementRequest(req.getEditingDomain(), (EObject)interactionFragment, false);
                    deleteElementsCommand.add((IUndoableOperation)new DestroyElementCommand(destroyRequest));
                }
                return deleteElementsCommand;
            }
        }
        return UnexecutableCommand.INSTANCE;
    }
}

