/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms;

import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.forms.WizardDef;
import org.eclipse.sapphire.ui.forms.WizardPageDef;
import org.eclipse.sapphire.ui.forms.WizardPagePart;
import org.eclipse.sapphire.util.ListFactory;

public final class WizardPart
extends SapphirePart {
    private FunctionResult imageFunctionResult;
    private FunctionResult labelFunctionResult;
    private List<WizardPagePart> pages;

    @Override
    protected void init() {
        super.init();
        Element element = this.getModelElement();
        WizardDef def = this.definition();
        this.imageFunctionResult = this.initExpression((Function)def.getImage().content(), ImageData.class, null, new Runnable(){

            @Override
            public void run() {
                WizardPart.this.broadcast(new SapphirePart.ImageChangedEvent(WizardPart.this));
            }
        });
        this.labelFunctionResult = this.initExpression((Function)def.getLabel().content(), String.class, null, new Runnable(){

            @Override
            public void run() {
                WizardPart.this.broadcast(new SapphirePart.LabelChangedEvent(WizardPart.this));
            }
        });
        ListFactory pagesListFactory = ListFactory.start();
        for (WizardPageDef pageDef : def.getPages()) {
            pagesListFactory.add((Object)((WizardPagePart)WizardPart.create(this, element, pageDef, this.params)));
        }
        this.pages = pagesListFactory.result();
    }

    @Override
    public WizardDef definition() {
        return (WizardDef)super.definition();
    }

    public String getLabel() {
        LocalizationService localizationService = (LocalizationService)this.definition().adapt(LocalizationService.class);
        return localizationService.text((String)this.labelFunctionResult.value(), CapitalizationType.TITLE_STYLE, false);
    }

    public ImageData getImage() {
        return (ImageData)this.imageFunctionResult.value();
    }

    public List<WizardPagePart> getPages() {
        return this.pages;
    }

    @Override
    public void dispose() {
        if (this.imageFunctionResult != null) {
            this.imageFunctionResult.dispose();
        }
        if (this.labelFunctionResult != null) {
            this.labelFunctionResult.dispose();
        }
        for (WizardPagePart page : this.pages) {
            page.dispose();
        }
        super.dispose();
    }
}

