/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.utils;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.sirius.common.tools.api.interpreter.ClasspathChangeCallback;
import org.eclipse.sirius.common.tools.api.interpreter.EPackageLoadingCallback;
import org.eclipse.sirius.common.tools.internal.interpreter.BundleClassLoading;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditorPlugin;
import org.osgi.framework.Bundle;

public class WorkspaceClassLoading
extends BundleClassLoading {
    private IResourceChangeListener workspaceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() != 1) {
                return;
            }
            final LinkedHashSet changed = new LinkedHashSet();
            IResourceDeltaVisitor projectClassesInvalidator = new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if (delta.getKind() != 4) {
                        return true;
                    }
                    if ((delta.getFlags() & 0x100) == 0) {
                        return true;
                    }
                    IResource resource = delta.getResource();
                    if (resource.getType() == 1 && ("class".equalsIgnoreCase(resource.getFileExtension()) || "ecore".equalsIgnoreCase(resource.getFileExtension()) || "MANIFEST.MF".equalsIgnoreCase(resource.getName())) && resource.getProject() != null && resource.getProject().getName() != null) {
                        changed.add(resource.getProject().getName());
                    }
                    return true;
                }
            };
            try {
                event.getDelta().accept(projectClassesInvalidator);
            }
            catch (CoreException e) {
                SiriusEditorPlugin.INSTANCE.log((Object)e);
            }
            if (changed.size() > 0) {
                for (String projectName : changed) {
                    URLClassLoader old = (URLClassLoader)WorkspaceClassLoading.this.projectsToClassLoader.get(projectName);
                    if (old != null) {
                        WorkspaceClassLoading.this.closeClassLoader(old);
                    }
                    WorkspaceClassLoading.this.projectsToClassLoader.remove(projectName);
                }
                if (WorkspaceClassLoading.this.callback != null) {
                    WorkspaceClassLoading.this.callback.classpathChanged(changed);
                }
            }
        }
    };
    private Set<String> doNotLoadFromWorkspace;
    private Map<String, URLClassLoader> projectsToClassLoader = new HashMap<String, URLClassLoader>();
    private ClasspathChangeCallback callback;

    public WorkspaceClassLoading() {
        this.doNotLoadFromWorkspace = new LinkedHashSet<String>();
        for (String siriusBundle : SiriusEditorPlugin.getSiriusRuntimeBundles()) {
            this.doNotLoadFromWorkspace.add(siriusBundle);
            this.doNotLoadFromWorkspace.addAll(super.getBundleDependencies(siriusBundle));
        }
    }

    protected Collection<Object> findCallees(IPluginModelBase model) {
        BundleDescription desc = model.getBundleDescription();
        if (desc == null) {
            return Collections.emptyList();
        }
        BundleDescription fFragmentDescription = null;
        HostSpecification spec = desc.getHost();
        if (spec != null) {
            fFragmentDescription = desc;
            ArrayList fragmentDependencies = Lists.newArrayList(this.getDependencies(desc, fFragmentDescription));
            BaseDescription host = spec.getSupplier();
            if (host instanceof BundleDescription) {
                BundleDescription hostDesc = (BundleDescription)host;
                for (Object object : fragmentDependencies) {
                    ExportPackageDescription epd;
                    BundleDescription dependency = null;
                    if (object instanceof BundleSpecification) {
                        dependency = ((BundleSpecification)object).getBundle();
                    } else if (object instanceof ImportPackageSpecification && (epd = (ExportPackageDescription)((ImportPackageSpecification)object).getSupplier()) != null) {
                        dependency = epd.getSupplier();
                    }
                    if (dependency == null || !dependency.equals((Object)hostDesc)) continue;
                    return fragmentDependencies;
                }
                fragmentDependencies.add(0, hostDesc);
                return fragmentDependencies;
            }
            return fragmentDependencies;
        }
        return this.getDependencies(desc, fFragmentDescription);
    }

    private Collection<Object> getDependencies(BundleDescription desc, BundleDescription fFragmentDescription) {
        BundleSpecification[] requiredBundles;
        HashMap<Object, Object> dependencies = new HashMap<Object, Object>();
        BundleSpecification[] bundleSpecificationArray = requiredBundles = desc.getRequiredBundles();
        int n = requiredBundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification requiredBundle = bundleSpecificationArray[n2];
            BaseDescription bd = requiredBundle.getSupplier();
            if (bd != null) {
                dependencies.put(bd, requiredBundle);
            } else {
                dependencies.put(requiredBundle, requiredBundle);
            }
            ++n2;
        }
        ImportPackageSpecification[] importedPkgs = desc.getImportPackages();
        int i = 0;
        while (i < importedPkgs.length) {
            BundleDescription exporter;
            BaseDescription bd = importedPkgs[i].getSupplier();
            if (bd instanceof ExportPackageDescription && (exporter = ((ExportPackageDescription)bd).getExporter()) != null) {
                Object obj = dependencies.get(exporter);
                if (obj == null) {
                    dependencies.put(exporter, importedPkgs[i]);
                } else if (!"optional".equals(importedPkgs[i].getDirective("resolution")) && obj instanceof ImportPackageSpecification && "optional".equals(((ImportPackageSpecification)obj).getDirective("resolution"))) {
                    dependencies.put(exporter, importedPkgs[i]);
                }
            }
            ++i;
        }
        BundleDescription[] frags = desc.getFragments();
        int i2 = 0;
        while (i2 < frags.length) {
            if (!frags[i2].equals((Object)fFragmentDescription)) {
                dependencies.put(frags[i2], frags[i2]);
            }
            ++i2;
        }
        return dependencies.values();
    }

    private void computeURLs(IProject project, List<URL> uRLs) {
        block9: {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                IFolder reference;
                IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(true);
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile reference2;
                    IPath output;
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3 && (output = entry.getOutputLocation()) != null && (reference2 = ResourcesPlugin.getWorkspace().getRoot().getFile(output)).exists()) {
                        try {
                            URL url = reference2.getLocation().toFile().toURI().toURL();
                            uRLs.add(url);
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                    ++n2;
                }
                IPath output = javaProject.getOutputLocation();
                if (output == null || !(reference = ResourcesPlugin.getWorkspace().getRoot().getFolder(output)).exists() || reference.getLocation() == null) break block9;
                File file = reference.getLocation().toFile();
                try {
                    if (file != null && file.exists()) {
                        URL url = file.toURI().toURL();
                        uRLs.add(url);
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    public Class findClass(Set<String> viewpointProjects, Set<String> plugins, String qualifiedName) {
        Iterator<String> it;
        Class<?> result = null;
        IWorkspaceRoot root = EcorePlugin.getWorkspaceRoot();
        if (root != null) {
            it = viewpointProjects.iterator();
            while (result == null && it.hasNext()) {
                String projectName = it.next();
                ClassLoader loader = this.getOrCreateClassLoader(projectName, root);
                if (loader == null) continue;
                try {
                    result = loader.loadClass(qualifiedName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {}
            }
        }
        it = plugins.iterator();
        while (result == null && it.hasNext()) {
            Bundle bnd = Platform.getBundle((String)it.next());
            if (bnd == null) continue;
            try {
                result = bnd.loadClass(qualifiedName);
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    private ClassLoader getOrCreateClassLoader(String projectName, IWorkspaceRoot root) {
        URLClassLoader existing = this.projectsToClassLoader.get(projectName);
        if (existing == null && (existing = this.createClassLoader(projectName, root)) != null) {
            this.projectsToClassLoader.put(projectName, existing);
        }
        return existing;
    }

    protected Collection<EPackageLoadingCallback.EPackageDeclarationSource> getEPackagesDeclaredInBundles(Collection<String> bundles) {
        ArrayList<EPackageLoadingCallback.EPackageDeclarationSource> result = new ArrayList();
        IWorkspaceRoot root = EcorePlugin.getWorkspaceRoot();
        LinkedHashSet<String> bundlesToSearchInPlatform = new LinkedHashSet<String>();
        if (root != null) {
            Map<String, IPluginModelBase> symbolicNamestoModels = this.getBundlesInWorkspace();
            for (String bundleID : bundles) {
                IPluginModelBase workspaceVersion = symbolicNamestoModels.get(bundleID);
                if (workspaceVersion != null) {
                    IPluginExtension[] iPluginExtensionArray = workspaceVersion.getExtensions().getExtensions();
                    int n = iPluginExtensionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPluginExtension extensions = iPluginExtensionArray[n2];
                        if ("org.eclipse.emf.ecore.generated_package".equals(extensions.getPoint())) {
                            String symbolicNameForProject = workspaceVersion.getBundleDescription().getSymbolicName();
                            ArrayList<EPackageLoadingCallback.EPackageDeclaration> declarations = new ArrayList<EPackageLoadingCallback.EPackageDeclaration>();
                            IPluginObject[] iPluginObjectArray = extensions.getChildren();
                            int n3 = iPluginObjectArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IPluginObject object = iPluginObjectArray[n4];
                                if (object instanceof IPluginElement) {
                                    IPluginElement element = (IPluginElement)object;
                                    String nsURI = this.getAttributeValue(element, "uri");
                                    String className = this.getAttributeValue(element, "class");
                                    String genModel = this.getAttributeValue(element, "genModel");
                                    if (nsURI != null && className != null) {
                                        declarations.add(new EPackageLoadingCallback.EPackageDeclaration(nsURI, className, genModel));
                                    } else {
                                        Status status = new Status(2, "org.eclipse.sirius.editor", "An EPackage declaration in project " + symbolicNameForProject + " has been ignored because of missing informations.");
                                        SiriusEditorPlugin.INSTANCE.log(status);
                                    }
                                }
                                ++n4;
                            }
                            if (declarations.size() > 0) {
                                result.add(new EPackageLoadingCallback.EPackageDeclarationSource(symbolicNameForProject, declarations, false));
                            }
                        }
                        ++n2;
                    }
                    continue;
                }
                bundlesToSearchInPlatform.add(bundleID);
            }
            result.addAll(super.getEPackagesDeclaredInBundles(bundlesToSearchInPlatform));
        } else {
            result = super.getEPackagesDeclaredInBundles(bundles);
        }
        return result;
    }

    protected Set<String> getBundleDependencies(String currentBundleID) {
        Set dependenciesRetrievedThroughPlatform = super.getBundleDependencies(currentBundleID);
        IPluginModelBase pdeModel = PluginRegistry.findModel((String)currentBundleID);
        if (pdeModel != null && pdeModel.getUnderlyingResource() instanceof IFile) {
            Set<String> dependenciesRetrievedThroughPDE = this.getDependenciesFromPDE(pdeModel);
            return dependenciesRetrievedThroughPDE;
        }
        return dependenciesRetrievedThroughPlatform;
    }

    protected Set<String> getDependenciesFromPDE(IPluginModelBase pdeModel) {
        LinkedHashSet<String> dependenciesRetrievedThroughPDE = new LinkedHashSet<String>();
        LinkedHashSet dependencies = Sets.newLinkedHashSet(this.findCallees(pdeModel));
        for (VersionConstraint requireBundleOrImportPackage : Iterables.filter((Iterable)dependencies, VersionConstraint.class)) {
            BaseDescription supplier = requireBundleOrImportPackage.getSupplier();
            if (requireBundleOrImportPackage instanceof ImportPackageSpecification && supplier instanceof ExportPackageDescription) {
                supplier = ((ExportPackageDescription)supplier).getSupplier();
            }
            if (!(supplier instanceof BundleDescription) || ((BundleDescription)supplier).getSymbolicName() == null) continue;
            dependenciesRetrievedThroughPDE.add(((BundleDescription)supplier).getSymbolicName());
        }
        return dependenciesRetrievedThroughPDE;
    }

    private String getAttributeValue(IPluginElement element, String key) {
        IPluginAttribute attr = element.getAttribute(key);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    private URLClassLoader createClassLoader(String projectName, IWorkspaceRoot root) {
        Map<String, IPluginModelBase> symbolicNamestoModels = this.getBundlesInWorkspace();
        ArrayList<IPluginModelBase> workspaceDependencies = new ArrayList<IPluginModelBase>();
        final ArrayList<Bundle> installedDependencies = new ArrayList<Bundle>();
        this.collectAllClassPath(projectName, root, symbolicNamestoModels, workspaceDependencies, installedDependencies);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (IPluginModelBase wksDep : workspaceDependencies) {
            IResource res = wksDep.getUnderlyingResource();
            if (res == null) continue;
            this.computeURLs(res.getProject(), urls);
        }
        URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()])){

            public Class findClass(String name) throws ClassNotFoundException {
                Class found = null;
                try {
                    found = super.findClass(name);
                }
                catch (Throwable throwable) {}
                Iterator it = installedDependencies.iterator();
                while (found == null && it.hasNext()) {
                    try {
                        found = ((Bundle)it.next()).loadClass(name);
                    }
                    catch (Throwable throwable) {}
                }
                return found;
            }
        };
        return loader;
    }

    protected void collectAllClassPath(String projectName, IWorkspaceRoot root, Map<String, IPluginModelBase> symbolicNamestoModels, Collection<IPluginModelBase> workspaceDependencies, Collection<Bundle> installedDependencies) {
        IPluginModelBase currentProject;
        IPluginModelBase pdeModel = PluginRegistry.findModel((String)projectName);
        if (pdeModel != null) {
            Set<String> symbolicNames = this.getDependenciesFromPDE(pdeModel);
            for (String requirementSymbolicName : symbolicNames) {
                IPluginModelBase requiredDep = symbolicNamestoModels.get(requirementSymbolicName);
                if (requiredDep != null && !this.doNotLoadFromWorkspace.contains(requirementSymbolicName)) {
                    workspaceDependencies.add(requiredDep);
                    continue;
                }
                Bundle bnd = Platform.getBundle((String)requirementSymbolicName);
                if (bnd == null) continue;
                installedDependencies.add(bnd);
            }
        }
        if ((currentProject = symbolicNamestoModels.get(projectName)) != null && !this.doNotLoadFromWorkspace.contains(projectName)) {
            workspaceDependencies.add(currentProject);
        } else {
            Bundle bnd = Platform.getBundle((String)projectName);
            if (bnd != null) {
                installedDependencies.add(bnd);
            }
        }
    }

    private Map<String, IPluginModelBase> getBundlesInWorkspace() {
        IPluginModelBase[] wrkspcesModels;
        HashMap<String, IPluginModelBase> symbolicNamestoModels = new HashMap<String, IPluginModelBase>();
        IPluginModelBase[] iPluginModelBaseArray = wrkspcesModels = PluginRegistry.getWorkspaceModels();
        int n = wrkspcesModels.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase iPluginModelBase = iPluginModelBaseArray[n2];
            if (iPluginModelBase.getBundleDescription() != null && iPluginModelBase.getBundleDescription().getSymbolicName() != null) {
                symbolicNamestoModels.put(iPluginModelBase.getBundleDescription().getSymbolicName(), iPluginModelBase);
            }
            ++n2;
        }
        return symbolicNamestoModels;
    }

    public void dispose() {
        this.projectsToClassLoader.clear();
        IWorkspaceRoot root = EcorePlugin.getWorkspaceRoot();
        if (this.callback != null && root != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.workspaceListener);
        }
        for (URLClassLoader loader : this.projectsToClassLoader.values()) {
            this.closeClassLoader(loader);
        }
        this.projectsToClassLoader.clear();
    }

    private void closeClassLoader(URLClassLoader old) {
        try {
            Method closeMethod = URLClassLoader.class.getMethod("close", new Class[0]);
            closeMethod.invoke((Object)old, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException e) {
            SiriusEditorPlugin.INSTANCE.log(e.getCause());
        }
    }

    public void setClasspathChangeCallback(ClasspathChangeCallback listener) {
        IWorkspaceRoot root = EcorePlugin.getWorkspaceRoot();
        if (this.callback != null && listener == null && root != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.workspaceListener);
        }
        this.callback = listener;
        if (root != null) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.workspaceListener);
        }
    }
}

