/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.core.persistence.projects;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.launch.core.interfaces.IReferencedProjectItem;
import org.eclipse.tcf.te.launch.core.nls.Messages;

public class ReferencedProjectItemValidator {
    public static final Map<String, String> validate(IReferencedProjectItem item) {
        Assert.isNotNull((Object)item);
        HashMap<String, String> invalid = new HashMap<String, String>();
        String projectName = item.getStringProperty("project_name");
        if (projectName == null || projectName.trim().length() == 0) {
            invalid.put("project_name", Messages.ReferencedProjectItemValidator_missingProject);
        } else {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null) {
                invalid.put("project_name", Messages.ReferencedProjectItemValidator_notExistingProject);
            } else if (!project.isOpen()) {
                invalid.put("project_name", Messages.ReferencedProjectItemValidator_closedProject);
            }
        }
        return invalid.isEmpty() ? null : invalid;
    }
}

