/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.execution.graph;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsInterruptContext;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsWorker;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;

public class OsSystemModel {
    private final Table<String, Integer, HostThread> fCurrentTids = HashBasedTable.create();
    private final Table<String, Integer, Stack<OsInterruptContext>> fIntCtxStacks = HashBasedTable.create();
    private final Map<HostThread, OsWorker> fWorkerMap = new HashMap<HostThread, OsWorker>();

    public void cacheTidOnCpu(Integer cpu, HostThread ht) {
        this.fCurrentTids.put((Object)ht.getHost(), (Object)cpu, (Object)ht);
    }

    public @Nullable OsWorker getWorkerOnCpu(String host, Integer cpu) {
        HostThread ht = (HostThread)this.fCurrentTids.get((Object)host, (Object)cpu);
        if (ht == null) {
            return null;
        }
        return this.findWorker(ht);
    }

    public @Nullable OsWorker findWorker(HostThread ht) {
        return this.fWorkerMap.get(ht);
    }

    public void addWorker(OsWorker worker) {
        this.fWorkerMap.put(worker.getHostThread(), worker);
    }

    public Collection<OsWorker> getWorkers() {
        return this.fWorkerMap.values();
    }

    public void pushContextStack(String hostId, Integer cpu, OsInterruptContext interruptCtx) {
        Stack<OsInterruptContext> stack = (Stack<OsInterruptContext>)this.fIntCtxStacks.get((Object)hostId, (Object)cpu);
        if (stack == null) {
            stack = new Stack<OsInterruptContext>();
            this.fIntCtxStacks.put((Object)hostId, (Object)cpu, stack);
        }
        stack.push(interruptCtx);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public OsInterruptContext peekContextStack(String hostId, Integer cpu) {
        @NonNull Stack stack = (Stack)this.fIntCtxStacks.get((Object)hostId, (Object)cpu);
        if (stack == null) {
            return OsInterruptContext.DEFAULT_CONTEXT;
        }
        if (stack.empty()) {
            return OsInterruptContext.DEFAULT_CONTEXT;
        }
        OsInterruptContext peek = Objects.requireNonNull((OsInterruptContext)stack.peek());
        return peek;
    }

    public @Nullable OsInterruptContext popContextStack(String hostId, Integer cpu) {
        Stack stack = (Stack)this.fIntCtxStacks.get((Object)hostId, (Object)cpu);
        if (stack == null) {
            return null;
        }
        if (stack.empty()) {
            return null;
        }
        return (OsInterruptContext)stack.pop();
    }
}

