/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.grid.data;

import java.util.Map;
import net.sourceforge.nattable.data.IDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultColumnHeaderDataProvider
implements IDataProvider {
    private final String[] propertyNames;
    private Map<String, String> propertyToLabelMap;

    public DefaultColumnHeaderDataProvider(String[] columnLabels) {
        this.propertyNames = columnLabels;
    }

    public DefaultColumnHeaderDataProvider(String[] propertyNames, Map<String, String> propertyToLabelMap) {
        this.propertyNames = propertyNames;
        this.propertyToLabelMap = propertyToLabelMap;
    }

    public String getColumnHeaderLabel(int columnIndex) {
        String label;
        String propertyName = this.propertyNames[columnIndex];
        if (this.propertyToLabelMap != null && (label = this.propertyToLabelMap.get(propertyName)) != null) {
            return label;
        }
        return propertyName;
    }

    @Override
    public int getColumnCount() {
        return this.propertyNames.length;
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public Object getDataValue(int columnIndex, int rowIndex) {
        return this.getColumnHeaderLabel(columnIndex);
    }

    @Override
    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        throw new UnsupportedOperationException();
    }
}

