/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views;

import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.ui.extensions.IProviderFactory;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.INodeProvider;
import org.eclipse.birt.report.model.api.DesignElementHandle;

public class ProviderFactory {
    private static DefaultNodeProvider defaultProvider = new DefaultNodeProvider();

    public static INodeProvider getDefaultProvider() {
        return defaultProvider;
    }

    public static INodeProvider createProvider(Object object) {
        Object adapter = ElementAdapterManager.getAdapter(object, INodeProvider.class);
        if (adapter instanceof INodeProvider) {
            return (INodeProvider)adapter;
        }
        if (object instanceof DesignElementHandle) {
            String elementName = ((DesignElementHandle)object).getDefn().getName();
            IProviderFactory factory = ExtensionPointManager.getInstance().getProviderFactory(elementName);
            if (factory != null) {
                return factory.createProvider(object);
            }
        }
        return ProviderFactory.getDefaultProvider();
    }
}

