/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import org.eclipse.bpel.common.ui.details.ChangeHelper;
import org.eclipse.bpel.common.ui.details.viewers.CComboViewer;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.EndpointReferenceRole;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.partnerlinktype.Role;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.adapters.IVirtualCopyRuleSide;
import org.eclipse.bpel.ui.details.providers.ModelLabelProvider;
import org.eclipse.bpel.ui.details.providers.PartnerLinkContentProvider;
import org.eclipse.bpel.ui.details.providers.RoleContentProvider;
import org.eclipse.bpel.ui.properties.AssignCategoryBase;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class PartnerRoleAssignCategory
extends AssignCategoryBase {
    protected static final int PARTNER_CONTEXT = 0;
    protected static final int ROLE_CONTEXT = 1;
    protected int lastChangeContext = -1;
    Table partnerTable;
    TableViewer partnerViewer;
    ChangeHelper partnerChangeHelper;
    ChangeHelper roleChangeHelper;
    CCombo roleCombo;
    CComboViewer roleViewer;
    protected boolean fIsFrom = false;

    protected PartnerRoleAssignCategory(BPELPropertySection ownerSection, boolean isFrom) {
        super(ownerSection);
        this.fIsFrom = isFrom;
    }

    @Override
    public String getName() {
        return Messages.PartnerRoleAssignCategory_Partner_Reference_1;
    }

    @Override
    protected void createClient2(Composite parent) {
        FlatFormData data;
        if (this.fIsFrom) {
            this.roleChangeHelper = new ChangeHelper(this.getCommandFramework()){

                public String getLabel() {
                    return Messages.PartnerRoleAssignCategory_Role_Change_2;
                }

                public Command createApplyCommand() {
                    PartnerRoleAssignCategory.this.lastChangeContext = 1;
                    return PartnerRoleAssignCategory.this.wrapInShowContextCommand(PartnerRoleAssignCategory.this.newStoreModelCommand());
                }

                public void restoreOldState() {
                    PartnerRoleAssignCategory.this.updateCategoryWidgets();
                }
            };
            Label roleLabel = this.fWidgetFactory.createLabel(parent, Messages.PartnerRoleAssignCategory_Role__3);
            this.roleCombo = this.fWidgetFactory.createCCombo(parent);
            data = new FlatFormData();
            data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)roleLabel, 105));
            data.right = new FlatFormAttachment(100, 0);
            data.bottom = new FlatFormAttachment(100, 0);
            this.roleCombo.setLayoutData((Object)data);
            data = new FlatFormData();
            data.left = new FlatFormAttachment(0, 0);
            data.right = new FlatFormAttachment((Control)this.roleCombo, -5);
            data.top = new FlatFormAttachment((Control)this.roleCombo, 0, 0x1000000);
            roleLabel.setLayoutData((Object)data);
            this.roleViewer = new CComboViewer(this.roleCombo);
            this.roleViewer.setContentProvider((IContentProvider)new RoleContentProvider());
            this.roleViewer.setLabelProvider((IBaseLabelProvider)new ModelLabelProvider());
            this.roleChangeHelper.startListeningTo(new Control[]{this.roleCombo});
        }
        this.partnerChangeHelper = new ChangeHelper(this.getCommandFramework()){

            public String getLabel() {
                return Messages.PartnerRoleAssignCategory_Partner_Change_4;
            }

            public Command createApplyCommand() {
                PartnerRoleAssignCategory.this.lastChangeContext = 0;
                return PartnerRoleAssignCategory.this.wrapInShowContextCommand(PartnerRoleAssignCategory.this.newStoreModelCommand());
            }

            public void restoreOldState() {
                PartnerRoleAssignCategory.this.updateCategoryWidgets();
            }
        };
        this.partnerTable = this.fWidgetFactory.createTable(parent, 0);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.top = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.bottom = this.fIsFrom ? new FlatFormAttachment((Control)this.roleCombo, -4) : new FlatFormAttachment(100, 0);
        this.partnerTable.setLayoutData((Object)data);
        this.partnerViewer = new TableViewer(this.partnerTable);
        this.partnerViewer.setContentProvider((IContentProvider)new PartnerLinkContentProvider());
        this.partnerViewer.setLabelProvider((IBaseLabelProvider)new ModelLabelProvider());
        this.partnerViewer.setInput((Object)this.getProcess());
        this.partnerChangeHelper.startListeningTo(new Control[]{this.partnerTable});
        this.partnerTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)PartnerRoleAssignCategory.this.partnerViewer.getSelection();
                PartnerLink partnerLink = (PartnerLink)sel.getFirstElement();
                if (PartnerRoleAssignCategory.this.roleViewer != null) {
                    PartnerRoleAssignCategory.this.roleViewer.setInput((Object)partnerLink);
                }
                if (!PartnerRoleAssignCategory.this.partnerChangeHelper.isNonUserChange() && PartnerRoleAssignCategory.this.roleCombo != null) {
                    PartnerRoleAssignCategory.this.roleChangeHelper.startNonUserChange();
                    try {
                        PartnerRoleAssignCategory.this.roleCombo.select(0);
                    }
                    finally {
                        PartnerRoleAssignCategory.this.roleChangeHelper.finishNonUserChange();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    @Override
    public boolean isCategoryForModel(EObject aModel) {
        IVirtualCopyRuleSide side = BPELUtil.adapt((Object)aModel, IVirtualCopyRuleSide.class);
        return side != null && side.getPartnerLink() != null;
    }

    @Override
    protected void load(IVirtualCopyRuleSide side) {
        block13: {
            int roleMarker;
            PartnerLink selPartnerLink = side.getPartnerLink();
            boolean isMyRole = false;
            EndpointReferenceRole reference = side.getEndpointReference();
            if (reference != null && (roleMarker = reference.getValue()) == 0) {
                isMyRole = true;
            }
            this.partnerChangeHelper.startNonUserChange();
            try {
                if (selPartnerLink == null) {
                    this.partnerViewer.setSelection((ISelection)StructuredSelection.EMPTY, false);
                    if (this.roleViewer == null) break block13;
                    this.roleChangeHelper.startNonUserChange();
                    try {
                        this.roleViewer.setInput(null);
                        break block13;
                    }
                    finally {
                        this.roleChangeHelper.finishNonUserChange();
                    }
                }
                this.partnerViewer.setSelection((ISelection)new StructuredSelection((Object)selPartnerLink), true);
                if (this.roleViewer == null) break block13;
                this.roleChangeHelper.startNonUserChange();
                try {
                    Role role;
                    this.roleViewer.setInput((Object)selPartnerLink);
                    Role role2 = role = isMyRole ? selPartnerLink.getMyRole() : selPartnerLink.getPartnerRole();
                    if (role != null) {
                        this.roleViewer.setSelection((ISelection)new StructuredSelection((Object)role), true);
                    } else {
                        this.roleViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                    }
                }
                finally {
                    this.roleChangeHelper.finishNonUserChange();
                }
            }
            finally {
                this.partnerChangeHelper.finishNonUserChange();
            }
        }
    }

    @Override
    protected void store(IVirtualCopyRuleSide side) {
        IStructuredSelection sel = (IStructuredSelection)this.partnerViewer.getSelection();
        PartnerLink partnerLink = (PartnerLink)sel.getFirstElement();
        side.setPartnerLink(partnerLink);
        if (this.roleViewer == null) {
            return;
        }
        Object role = ((IStructuredSelection)this.roleViewer.getSelection()).getFirstElement();
        if (role == null) {
            return;
        }
        if (role.equals(partnerLink.getMyRole())) {
            side.setEndpointReference(EndpointReferenceRole.MY_ROLE_LITERAL);
        } else if (role.equals(partnerLink.getPartnerRole())) {
            side.setEndpointReference(EndpointReferenceRole.PARTNER_ROLE_LITERAL);
        }
    }

    @Override
    public Object getUserContext() {
        return this.lastChangeContext;
    }

    @Override
    public void restoreUserContext(Object userContext) {
        int i = (Integer)userContext;
        switch (i) {
            case 0: {
                this.partnerTable.setFocus();
                return;
            }
            case 1: {
                this.roleCombo.setFocus();
                return;
            }
        }
        throw new IllegalStateException();
    }
}

