/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Optional;
import org.eclipse.buildship.core.GradleDistribution;

public final class BuildConfiguration {
    private final File rootProjectDirectory;
    private final boolean overrideWorkspaceConfiguration;
    private final GradleDistribution gradleDistribution;
    private final File gradleUserHome;
    private final boolean buildScansEnabled;
    private final boolean offlineMode;
    private final boolean autoSync;

    private BuildConfiguration(BuildConfigurationBuilder builder) {
        this.rootProjectDirectory = (File)Preconditions.checkNotNull((Object)builder.rootProjectDirectory);
        this.overrideWorkspaceConfiguration = builder.overrideWorkspaceConfiguration;
        this.gradleDistribution = (GradleDistribution)Preconditions.checkNotNull((Object)builder.gradleDistribution);
        this.gradleUserHome = builder.gradleUserHome;
        this.buildScansEnabled = builder.buildScansEnabled;
        this.offlineMode = builder.offlineMode;
        this.autoSync = builder.autoSync;
    }

    public static BuildConfigurationBuilder forRootProjectDirectory(File rootProjectDirectory) {
        return new BuildConfigurationBuilder(rootProjectDirectory);
    }

    public boolean isOverrideWorkspaceConfiguration() {
        return this.overrideWorkspaceConfiguration;
    }

    public File getRootProjectDirectory() {
        return this.rootProjectDirectory;
    }

    public Optional<File> getGradleUserHome() {
        return Optional.ofNullable(this.gradleUserHome);
    }

    public boolean isBuildScansEnabled() {
        return this.buildScansEnabled;
    }

    public boolean isOfflineMode() {
        return this.offlineMode;
    }

    public boolean isAutoSync() {
        return this.autoSync;
    }

    public GradleDistribution getGradleDistribution() {
        return this.gradleDistribution;
    }

    public static final class BuildConfigurationBuilder {
        private final File rootProjectDirectory;
        private boolean overrideWorkspaceConfiguration = false;
        private GradleDistribution gradleDistribution = GradleDistribution.fromBuild();
        private File gradleUserHome = null;
        private boolean buildScansEnabled = false;
        private boolean offlineMode = false;
        private boolean autoSync = false;

        private BuildConfigurationBuilder(File rootProjectDirectory) {
            this.rootProjectDirectory = rootProjectDirectory;
        }

        public BuildConfigurationBuilder overrideWorkspaceConfiguration(boolean overrideWorkspaceConfiguration) {
            this.overrideWorkspaceConfiguration = overrideWorkspaceConfiguration;
            return this;
        }

        public BuildConfigurationBuilder gradleDistribution(GradleDistribution gradleDistribution) {
            this.gradleDistribution = gradleDistribution;
            return this;
        }

        public BuildConfigurationBuilder gradleUserHome(File gradleUserHome) {
            this.gradleUserHome = gradleUserHome;
            return this;
        }

        public BuildConfigurationBuilder buildScansEnabled(boolean buildScansEnabled) {
            this.buildScansEnabled = buildScansEnabled;
            return this;
        }

        public BuildConfigurationBuilder offlineMode(boolean offlineMode) {
            this.offlineMode = offlineMode;
            return this;
        }

        public BuildConfigurationBuilder autoSync(boolean autoSync) {
            this.autoSync = autoSync;
            return this;
        }

        public BuildConfiguration build() {
            return new BuildConfiguration(this);
        }
    }
}

