/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.marker;

import com.google.common.base.Throwables;
import org.eclipse.buildship.core.internal.workspace.GradleBuild;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class GradleErrorMarker {
    public static String ID = "org.eclipse.buildship.core.errormarker";
    public static String ATTRIBUTE_STACKTRACE = "stacktrace";
    public static String ATTRIBUTE_ROOT_DIR = "rootdir";

    private GradleErrorMarker() {
    }

    public static boolean belongsToBuild(IMarker marker, GradleBuild build) {
        String rootDir = marker.getAttribute(ATTRIBUTE_ROOT_DIR, null);
        return build.getBuildConfig().getRootProjectDirectory().getAbsolutePath().equals(rootDir);
    }

    public static void create(IResource resource, GradleBuild gradleBuild, String message, Throwable exception, int lineNumber) throws CoreException {
        IMarker marker = resource.createMarker(ID);
        if (lineNumber >= 0) {
            marker.setAttribute("lineNumber", lineNumber);
        }
        marker.setAttribute("message", (Object)message);
        marker.setAttribute("priority", 2);
        marker.setAttribute("severity", 2);
        marker.setAttribute(ATTRIBUTE_ROOT_DIR, (Object)gradleBuild.getBuildConfig().getRootProjectDirectory().getAbsolutePath());
        if (exception != null) {
            String stackTrace = Throwables.getStackTraceAsString((Throwable)exception);
            marker.setAttribute(ATTRIBUTE_STACKTRACE, (Object)stackTrace);
        }
    }
}

