/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.BuildConfiguration;
import org.eclipse.buildship.core.internal.configuration.GradleProjectNature;
import org.eclipse.buildship.core.internal.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.internal.workspace.DefaultGradleBuild;
import org.eclipse.buildship.core.internal.workspace.GradleBuild;
import org.eclipse.buildship.core.internal.workspace.GradleWorkspaceManager;
import org.eclipse.core.resources.IProject;

public final class DefaultGradleWorkspaceManager
implements GradleWorkspaceManager {
    private final LoadingCache<BuildConfiguration, GradleBuild> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<BuildConfiguration, GradleBuild>(){

        public GradleBuild load(BuildConfiguration buildConfiguration) {
            return new DefaultGradleBuild(buildConfiguration);
        }
    });

    @Override
    public GradleBuild getGradleBuild(BuildConfiguration buildConfig) {
        return (GradleBuild)this.cache.getUnchecked((Object)buildConfig);
    }

    @Override
    public Optional<GradleBuild> getGradleBuild(IProject project) {
        if (GradleProjectNature.isPresentOn(project)) {
            ProjectConfiguration projectConfiguration = CorePlugin.configurationManager().tryLoadProjectConfiguration(project);
            if (projectConfiguration != null) {
                return Optional.of((Object)new DefaultGradleBuild(projectConfiguration.getBuildConfiguration()));
            }
            return Optional.absent();
        }
        return Optional.absent();
    }

    @Override
    public Set<GradleBuild> getGradleBuilds() {
        return CorePlugin.workspaceOperations().getAllProjects().stream().filter(GradleProjectNature.isPresentOn()).map(project -> DefaultGradleWorkspaceManager.toBuildConfigurationOrNull(project)).filter(Objects::nonNull).map(buildConfig -> new DefaultGradleBuild((BuildConfiguration)buildConfig)).collect(Collectors.toSet());
    }

    private static BuildConfiguration toBuildConfigurationOrNull(IProject project) {
        ProjectConfiguration projectConfiguration = CorePlugin.configurationManager().tryLoadProjectConfiguration(project);
        return projectConfiguration != null ? projectConfiguration.getBuildConfiguration() : null;
    }
}

