/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.launch;

import java.util.List;
import org.eclipse.buildship.core.internal.i18n.CoreMessages;
import org.eclipse.buildship.core.internal.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.core.internal.util.collections.CollectionsUtils;
import org.eclipse.buildship.ui.internal.PluginImage;
import org.eclipse.buildship.ui.internal.PluginImages;
import org.eclipse.buildship.ui.internal.launch.LaunchMessages;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class ArgumentsTab
extends AbstractLaunchConfigurationTab {
    private Text argumentsText;
    private Text jvmArgumentsText;

    public String getName() {
        return LaunchMessages.Tab_Name_Arguments;
    }

    public Image getImage() {
        return PluginImages.RUN_CONFIG_ARGUMENTS.withState(PluginImage.ImageState.ENABLED).getImage();
    }

    public void createControl(Composite root) {
        Composite parent = new Composite(root, 0);
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        this.setControl((Control)parent);
        Group argumentsGroup = this.createGroup(parent, CoreMessages.RunConfiguration_Label_Arguments + ":");
        this.createArgumentsSelectionControl((Composite)argumentsGroup);
        Group jvmArgumentsGroup = this.createGroup(parent, CoreMessages.RunConfiguration_Label_JvmArguments + ":");
        this.createJvmArgumentsSelectionControl((Composite)jvmArgumentsGroup);
    }

    private Group createGroup(Composite parent, String groupName) {
        Group group = new Group(parent, 0);
        group.setText(groupName);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        return group;
    }

    private void createArgumentsSelectionControl(Composite container) {
        this.argumentsText = this.createTextControl(container);
        this.createVariablesSelectorButton(container, this.argumentsText);
    }

    private void createJvmArgumentsSelectionControl(Composite container) {
        this.jvmArgumentsText = this.createTextControl(container);
        this.createVariablesSelectorButton(container, this.jvmArgumentsText);
    }

    private Text createTextControl(Composite container) {
        Text textControl = new Text(container, 2626);
        GridData textLayoutData = new GridData(4, 128, true, false, 1, 1);
        textLayoutData.heightHint = 65;
        textControl.setLayoutData((Object)textLayoutData);
        textControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArgumentsTab.this.updateLaunchConfigurationDialog();
            }
        });
        return textControl;
    }

    private void createVariablesSelectorButton(Composite container, final Text target) {
        Composite buttonContainer = new Composite(container, 0);
        GridLayout buttonContainerLayout = new GridLayout(1, false);
        buttonContainerLayout.marginHeight = 1;
        buttonContainerLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonContainerLayout);
        buttonContainer.setLayoutData((Object)new GridData(128));
        Button selectVariableButton = new Button(buttonContainer, 0);
        selectVariableButton.setText(LaunchMessages.Button_Label_SelectVariables);
        selectVariableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(ArgumentsTab.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    target.insert(variable);
                }
            }
        });
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        GradleRunConfigurationAttributes configurationAttributes = GradleRunConfigurationAttributes.from((ILaunchConfiguration)configuration);
        this.argumentsText.setText(CollectionsUtils.joinWithSpace((List)configurationAttributes.getArgumentExpressions()));
        this.jvmArgumentsText.setText(CollectionsUtils.joinWithSpace((List)configurationAttributes.getJvmArgumentExpressions()));
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        GradleRunConfigurationAttributes.applyArgumentExpressions((List)CollectionsUtils.splitBySpace((String)this.argumentsText.getText()), (ILaunchConfigurationWorkingCopy)configuration);
        GradleRunConfigurationAttributes.applyJvmArgumentExpressions((List)CollectionsUtils.splitBySpace((String)this.jvmArgumentsText.getText()), (ILaunchConfigurationWorkingCopy)configuration);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }
}

