/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.preferences;

import java.io.File;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.WorkspaceConfiguration;
import org.eclipse.buildship.core.internal.i18n.CoreMessages;
import org.eclipse.buildship.core.internal.util.binding.Validator;
import org.eclipse.buildship.core.internal.util.binding.Validators;
import org.eclipse.buildship.ui.internal.preferences.GradleDistributionValidatingListener;
import org.eclipse.buildship.ui.internal.preferences.GradleUserHomeValidatingListener;
import org.eclipse.buildship.ui.internal.util.font.FontUtils;
import org.eclipse.buildship.ui.internal.util.gradle.GradleDistributionViewModel;
import org.eclipse.buildship.ui.internal.util.widget.GradleProjectSettingsComposite;
import org.eclipse.buildship.ui.internal.util.widget.GradleUserHomeGroup;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class GradleWorkbenchPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.eclipse.buildship.ui.preferences";
    private final Font defaultFont = FontUtils.getDefaultDialogFont();
    private final Validator<File> gradleUserHomeValidator = Validators.optionalDirectoryValidator((String)CoreMessages.Preference_Label_GradleUserHome);
    private final Validator<GradleDistributionViewModel> distributionValidator = GradleDistributionViewModel.validator();
    private GradleProjectSettingsComposite gradleProjectSettingsComposite;

    protected Control createContents(Composite parent) {
        this.gradleProjectSettingsComposite = GradleProjectSettingsComposite.builder(parent).withAutoSyncCheckbox().build();
        this.initValues();
        this.addListeners();
        return this.gradleProjectSettingsComposite;
    }

    private void initValues() {
        WorkspaceConfiguration config = CorePlugin.configurationManager().loadWorkspaceConfiguration();
        GradleDistribution gradleDistribution = config.getGradleDistribution();
        File gradleUserHome = config.getGradleUserHome();
        String gradleUserHomePath = gradleUserHome == null ? "" : gradleUserHome.getPath();
        this.gradleProjectSettingsComposite.getGradleDistributionGroup().setDistribution(GradleDistributionViewModel.from(gradleDistribution));
        this.gradleProjectSettingsComposite.getGradleUserHomeGroup().getGradleUserHomeText().setText(gradleUserHomePath);
        this.gradleProjectSettingsComposite.getOfflineModeCheckbox().setSelection(config.isOffline());
        this.gradleProjectSettingsComposite.getBuildScansCheckbox().setSelection(config.isBuildScansEnabled());
        this.gradleProjectSettingsComposite.getAutoSyncCheckbox().setSelection(config.isAutoSync());
    }

    private void addListeners() {
        GradleUserHomeGroup gradleUserHomeGroup = this.gradleProjectSettingsComposite.getGradleUserHomeGroup();
        gradleUserHomeGroup.getGradleUserHomeText().addModifyListener((ModifyListener)new GradleUserHomeValidatingListener(this, gradleUserHomeGroup, this.gradleUserHomeValidator));
        this.gradleProjectSettingsComposite.getGradleDistributionGroup().addDistributionChangedListener(new GradleDistributionValidatingListener(this, this.distributionValidator));
    }

    public boolean performOk() {
        GradleDistribution distribution = this.gradleProjectSettingsComposite.getGradleDistributionGroup().getDistribution().toGradleDistribution();
        String gradleUserHomeString = this.gradleProjectSettingsComposite.getGradleUserHomeGroup().getGradleUserHomeText().getText();
        File gradleUserHome = gradleUserHomeString.isEmpty() ? null : new File(gradleUserHomeString);
        boolean offlineMode = this.gradleProjectSettingsComposite.getOfflineModeCheckbox().getSelection();
        boolean buildScansEnabled = this.gradleProjectSettingsComposite.getBuildScansCheckbox().getSelection();
        boolean autoSync = this.gradleProjectSettingsComposite.getAutoSyncCheckbox().getSelection();
        WorkspaceConfiguration workspaceConfig = new WorkspaceConfiguration(distribution, gradleUserHome, offlineMode, buildScansEnabled, autoSync);
        CorePlugin.configurationManager().saveWorkspaceConfiguration(workspaceConfig);
        return super.performOk();
    }

    protected void performDefaults() {
        this.gradleProjectSettingsComposite.getGradleUserHomeGroup().getGradleUserHomeText().setText("");
        this.gradleProjectSettingsComposite.getGradleDistributionGroup().setDistribution(GradleDistributionViewModel.from((GradleDistribution)GradleDistribution.fromBuild()));
        super.performDefaults();
    }

    public void dispose() {
        this.defaultFont.dispose();
        super.dispose();
    }

    public void init(IWorkbench workbench) {
    }
}

