/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.wizard.project;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.internal.util.binding.Property;
import org.eclipse.buildship.ui.internal.util.gradle.GradleDistributionViewModel;
import org.eclipse.buildship.ui.internal.util.widget.GradleDistributionGroup;
import org.eclipse.buildship.ui.internal.util.widget.GradleProjectSettingsComposite;
import org.eclipse.buildship.ui.internal.wizard.project.AbstractWizardPage;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectImportConfiguration;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectWizardMessages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public final class GradleOptionsWizardPage
extends AbstractWizardPage {
    private final String pageContextInformation;
    private GradleProjectSettingsComposite gradleProjectSettingsComposite;

    public GradleOptionsWizardPage(ProjectImportConfiguration configuration) {
        this(configuration, ProjectWizardMessages.Title_GradleOptionsWizardPage, ProjectWizardMessages.InfoMessage_GradleOptionsWizardPageDefault, ProjectWizardMessages.InfoMessage_GradleOptionsWizardPageContext);
    }

    public GradleOptionsWizardPage(ProjectImportConfiguration configuration, String title, String defaultMessage, String pageContextInformation) {
        super("GradleOptions", title, defaultMessage, configuration, (List<Property<?>>)ImmutableList.of(configuration.getDistribution(), configuration.getGradleUserHome()));
        this.pageContextInformation = pageContextInformation;
    }

    @Override
    protected void createWidgets(Composite root) {
        GridLayoutFactory.swtDefaults().applyTo(root);
        this.gradleProjectSettingsComposite = GradleProjectSettingsComposite.builder(root).withOverrideCheckbox("Override workspace settings", "Configure Workspace Settings").withAutoSyncCheckbox().build();
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.gradleProjectSettingsComposite);
        this.gradleProjectSettingsComposite.getParentPreferenceLink().addSelectionListener((SelectionListener)new WorkbenchPreferenceOpeningSelectionListener());
        this.initValues();
        this.addListeners();
    }

    private void initValues() {
        this.gradleProjectSettingsComposite.getOverrideBuildSettingsCheckbox().setSelection(((Boolean)this.getConfiguration().getOverrideWorkspaceConfiguration().getValue()).booleanValue());
        this.gradleProjectSettingsComposite.getGradleDistributionGroup().setDistribution((GradleDistributionViewModel)this.getConfiguration().getDistribution().getValue());
        this.gradleProjectSettingsComposite.getGradleUserHomeGroup().setGradleUserHome((File)this.getConfiguration().getGradleUserHome().getValue());
        this.gradleProjectSettingsComposite.getBuildScansCheckbox().setSelection(((Boolean)this.getConfiguration().getBuildScansEnabled().getValue()).booleanValue());
        this.gradleProjectSettingsComposite.getOfflineModeCheckbox().setSelection(((Boolean)this.getConfiguration().getOfflineMode().getValue()).booleanValue());
        this.gradleProjectSettingsComposite.getAutoSyncCheckbox().setSelection(((Boolean)this.getConfiguration().getAutoSync().getValue()).booleanValue());
        this.gradleProjectSettingsComposite.updateEnablement();
    }

    private void addListeners() {
        this.gradleProjectSettingsComposite.getOverrideBuildSettingsCheckbox().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GradleOptionsWizardPage.this.getConfiguration().getOverrideWorkspaceConfiguration().setValue((Object)GradleOptionsWizardPage.this.gradleProjectSettingsComposite.getOverrideBuildSettingsCheckbox().getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                GradleOptionsWizardPage.this.getConfiguration().getOverrideWorkspaceConfiguration().setValue((Object)GradleOptionsWizardPage.this.gradleProjectSettingsComposite.getOverrideBuildSettingsCheckbox().getSelection());
            }
        });
        this.gradleProjectSettingsComposite.getGradleDistributionGroup().addDistributionChangedListener(new GradleDistributionGroup.DistributionChangedListener(){

            @Override
            public void distributionUpdated(GradleDistributionViewModel distribution) {
                GradleOptionsWizardPage.this.getConfiguration().setDistribution(distribution);
            }
        });
        this.gradleProjectSettingsComposite.getGradleUserHomeGroup().getGradleUserHomeText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GradleOptionsWizardPage.this.getConfiguration().setGradleUserHome(GradleOptionsWizardPage.this.gradleProjectSettingsComposite.getGradleUserHomeGroup().getGradleUserHome());
            }
        });
        this.gradleProjectSettingsComposite.getBuildScansCheckbox().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GradleOptionsWizardPage.this.getConfiguration().getBuildScansEnabled().setValue((Object)GradleOptionsWizardPage.this.gradleProjectSettingsComposite.getBuildScansCheckbox().getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                GradleOptionsWizardPage.this.getConfiguration().getBuildScansEnabled().setValue((Object)GradleOptionsWizardPage.this.gradleProjectSettingsComposite.getBuildScansCheckbox().getSelection());
            }
        });
        this.gradleProjectSettingsComposite.getOfflineModeCheckbox().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GradleOptionsWizardPage.this.getConfiguration().getOfflineMode().setValue((Object)GradleOptionsWizardPage.this.gradleProjectSettingsComposite.getOfflineModeCheckbox().getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                GradleOptionsWizardPage.this.getConfiguration().getOfflineMode().setValue((Object)GradleOptionsWizardPage.this.gradleProjectSettingsComposite.getOfflineModeCheckbox().getSelection());
            }
        });
        this.gradleProjectSettingsComposite.getAutoSyncCheckbox().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GradleOptionsWizardPage.this.getConfiguration().getAutoSync().setValue((Object)GradleOptionsWizardPage.this.gradleProjectSettingsComposite.getAutoSyncCheckbox().getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                GradleOptionsWizardPage.this.getConfiguration().getAutoSync().setValue((Object)GradleOptionsWizardPage.this.gradleProjectSettingsComposite.getAutoSyncCheckbox().getSelection());
            }
        });
    }

    @Override
    protected String getPageContextInformation() {
        return this.pageContextInformation;
    }

    private class WorkbenchPreferenceOpeningSelectionListener
    implements SelectionListener {
        private WorkbenchPreferenceOpeningSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.openWorkspacePreferences();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.openWorkspacePreferences();
        }

        private void openWorkspacePreferences() {
            PreferencesUtil.createPreferenceDialogOn((Shell)GradleOptionsWizardPage.this.getShell(), (String)"org.eclipse.buildship.ui.preferences", null, null).open();
        }
    }
}

