/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.emf.core.internal.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.emf.core.IBrowserRegistry;
import org.eclipse.emf.facet.util.emf.core.IEObjectBrowserOpener;
import org.eclipse.emf.facet.util.emf.core.IEPackageBrowserOpener;
import org.eclipse.emf.facet.util.emf.core.IResourceBrowserOpener;
import org.eclipse.emf.facet.util.emf.core.internal.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserRegistry
implements IBrowserRegistry {
    private static final String EXTENSION_POINT_RESOURCE_VIEWER_ELT = "resourceViewer";
    private static final String EXTENSION_POINT_EOBJECT_VIEWER_ELT = "eObjectViewer";
    private static final String EXTENSION_POINT_EPACKAGE_VIEWER_ELT = "ePackageViewer";
    private final List<IEPackageBrowserOpener> epackageBrowserOpeners = new ArrayList<IEPackageBrowserOpener>();
    private final List<IEObjectBrowserOpener> eobjectBrowserOpeners = new ArrayList<IEObjectBrowserOpener>();
    private final List<IResourceBrowserOpener> resourceBrowserOpeners = new ArrayList<IResourceBrowserOpener>();
    public static final String EXTENSION_POINT_MODEL_VIEWER_ID = "org.eclipse.emf.facet.util.emf.core.modelViewer";
    public static final String CLASS = "class";

    public BrowserRegistry() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT_MODEL_VIEWER_ID);
        if (extensionPoint != null) {
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElt = iConfigurationElementArray[n4];
                    String kind = configElt.getName();
                    String classID = configElt.getAttribute(CLASS);
                    try {
                        if (classID != null) {
                            if (kind.equals(EXTENSION_POINT_EPACKAGE_VIEWER_ELT)) {
                                this.epackageBrowserOpeners.add((IEPackageBrowserOpener)configElt.createExecutableExtension(CLASS));
                            } else if (kind.equals(EXTENSION_POINT_EOBJECT_VIEWER_ELT)) {
                                this.eobjectBrowserOpeners.add((IEObjectBrowserOpener)configElt.createExecutableExtension(CLASS));
                            } else if (kind.equals(EXTENSION_POINT_RESOURCE_VIEWER_ELT)) {
                                this.resourceBrowserOpeners.add((IResourceBrowserOpener)configElt.createExecutableExtension(CLASS));
                            }
                        }
                    }
                    catch (CoreException e) {
                        Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                    ++n4;
                }
                ++n2;
            }
        } else {
            Logger.logError((String)"Extension point not found: org.eclipse.emf.facet.util.emf.core.modelViewer", (Plugin)Activator.getDefault());
        }
    }

    @Override
    public void browseEPackage(EPackage ePackage) {
        if (ePackage == null) {
            throw new IllegalArgumentException();
        }
        IEPackageBrowserOpener opener = this.getDefaultEPackageBrowserOpener();
        if (opener != null) {
            opener.openEPackage(ePackage);
        } else {
            Logger.logWarning((String)("No epackage browser opener is registered to open ePackage " + ePackage.getNsURI()), (Plugin)Activator.getDefault());
        }
    }

    @Override
    public void browseResource(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        IResourceBrowserOpener opener = this.getDefaultResourceBrowserOpener();
        if (opener != null) {
            opener.openResource(resource);
        } else {
            Logger.logWarning((String)("No resource browser opener is registered to open " + resource.getURI()), (Plugin)Activator.getDefault());
        }
    }

    @Override
    public void browseEObject(EObject eObject) {
        if (eObject == null) {
            throw new IllegalArgumentException();
        }
        IEObjectBrowserOpener opener = this.getDefaultEObjectBrowserOpener();
        if (opener != null) {
            opener.openEObject(eObject);
        } else {
            Logger.logWarning((String)("No eobject browser opener is registered to open " + eObject.toString()), (Plugin)Activator.getDefault());
        }
    }

    @Override
    public List<IEPackageBrowserOpener> getAllRegisteredEPackageBrowsers() {
        return Collections.unmodifiableList(this.epackageBrowserOpeners);
    }

    @Override
    public List<IEObjectBrowserOpener> getAllRegisteredEObjectBrowsers() {
        return Collections.unmodifiableList(this.eobjectBrowserOpeners);
    }

    @Override
    public List<IResourceBrowserOpener> getAllRegisteredResourceBrowsers() {
        return Collections.unmodifiableList(this.resourceBrowserOpeners);
    }

    @Override
    public IEPackageBrowserOpener getDefaultEPackageBrowserOpener() {
        IEclipsePreferences preferenceNode = new InstanceScope().getNode("org.eclipse.emf.facet.util.emf.core");
        String className = preferenceNode.get("emf_facet_default_epackage_viewer", null);
        if (className != null) {
            for (IEPackageBrowserOpener ePackageBrowserFactory : this.epackageBrowserOpeners) {
                if (!ePackageBrowserFactory.getClass().getName().equals(className)) continue;
                return ePackageBrowserFactory;
            }
        }
        if (!this.epackageBrowserOpeners.isEmpty()) {
            return this.epackageBrowserOpeners.get(0);
        }
        return null;
    }

    @Override
    public IEObjectBrowserOpener getDefaultEObjectBrowserOpener() {
        IEclipsePreferences preferenceNode = new InstanceScope().getNode("org.eclipse.emf.facet.util.emf.core");
        String className = preferenceNode.get("emf_facet_default_eobject_viewer", null);
        if (className != null) {
            for (IEObjectBrowserOpener eObjectBrowserFactory : this.eobjectBrowserOpeners) {
                if (!eObjectBrowserFactory.getClass().getName().equals(className)) continue;
                return eObjectBrowserFactory;
            }
        }
        if (!this.eobjectBrowserOpeners.isEmpty()) {
            return this.eobjectBrowserOpeners.get(0);
        }
        return null;
    }

    @Override
    public IResourceBrowserOpener getDefaultResourceBrowserOpener() {
        IEclipsePreferences preferenceNode = new InstanceScope().getNode("org.eclipse.emf.facet.util.emf.core");
        String className = preferenceNode.get("emf_facet_default_resource_viewer", null);
        if (className != null) {
            for (IResourceBrowserOpener resourceBrowserOpener : this.resourceBrowserOpeners) {
                if (!resourceBrowserOpener.getClass().getName().equals(className)) continue;
                return resourceBrowserOpener;
            }
        }
        if (!this.resourceBrowserOpeners.isEmpty()) {
            return this.resourceBrowserOpeners.get(0);
        }
        return null;
    }
}

