/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.util.emf.core.command.EmfCommandUtils;
import org.eclipse.emf.facet.util.emf.core.internal.exported.ICommandFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TableFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TablePackage;
import org.eclipse.emf.facet.widgets.table.ui.command.ITableCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.Messages;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ColumnSortDirection;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.TableWidgetUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.TableWidgetRuntimeException;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.BasicCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.BrutalListSetCommand;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.CommandFactoryUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.CommandList;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.RowComparator;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.CustomizationUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.FacetAndCustomCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.LocalCustomCommandFactory;
import org.eclipse.jface.viewers.IStructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableCommandFactory
implements ITableCommandFactory {
    private static final boolean DEBUG = DebugUtils.getDebugStatus((Plugin)Activator.getDefault());
    private static final boolean DEBUG_RM_ROWCOLS = DebugUtils.getDebugStatus((Plugin)Activator.getDefault(), (String)"removeUselessRowsAndColumns");
    private final Table table;
    private final BasicCommandFactory basicCmdFactory;
    private final LocalCustomCommandFactory locCustCmdFactory;
    private final FacetAndCustomCommandFactory fctCustCmdFactory;

    public TableCommandFactory(Table table, EditingDomain editingDomain, ICommandFactory commandFactory) {
        this.table = table;
        this.basicCmdFactory = new BasicCommandFactory(commandFactory, editingDomain);
        this.fctCustCmdFactory = new FacetAndCustomCommandFactory(table, this.basicCmdFactory);
        this.locCustCmdFactory = new LocalCustomCommandFactory(table, this.basicCmdFactory);
    }

    public Command createSortRowCommand(FeatureColumn featureColumn, ColumnSortDirection direction, IFacetManager facetManager, ICustomizationManager customManager) {
        ArrayList rows = new ArrayList(this.table.getRows());
        ETypedElement eTypedElement = featureColumn.getFeature();
        RowComparator comparator = new RowComparator(eTypedElement, direction, facetManager, customManager);
        Collections.sort(rows, comparator);
        String description = String.format(Messages.TableCommandFactory_row_sort_description, eTypedElement.getName());
        return new BrutalListSetCommand(this.table, TablePackage.eINSTANCE.getTable_Rows(), rows, Messages.TableCommandFactory_row_sort_label, description);
    }

    @Override
    public Command createRemoveRowByEObjectCommand(Collection<? extends EObject> eObjectRows) {
        ArrayList<Row> rowsToRemove = new ArrayList<Row>();
        for (Row row : this.table.getRows()) {
            if (!eObjectRows.contains(row.getElement())) continue;
            rowsToRemove.add(row);
        }
        return this.createRemoveRowsCommand(rowsToRemove);
    }

    public Command createRemoveUselessColumnsCommand(Collection<Row> rowsToRemove, List<FacetSet> nextLoadedFS) {
        CommandList commandList = new CommandList();
        ArrayList<Row> rowsToKeep = new ArrayList<Row>((Collection<Row>)this.table.getRows());
        rowsToKeep.removeAll(rowsToRemove);
        EList facetSets = nextLoadedFS == null ? this.table.getFacetSets() : nextLoadedFS;
        List<FeatureColumn> columns = CommandFactoryUtils.columnsToRemove(this.table, (List<? extends FacetSet>)facetSets, rowsToKeep);
        for (FeatureColumn column : columns) {
            DebugUtils.debug((boolean)DEBUG, (String)("column to remove: " + EcoreUtil.getURI((EObject)column.getFeature())));
            Command rmColumnCmd = this.basicCmdFactory.createRemoveCommand(this.table, TablePackage.eINSTANCE.getTable_Columns(), column);
            commandList.add(rmColumnCmd);
        }
        if (DEBUG) {
            DebugUtils.debug((String)("Columns to be removed: " + commandList.size()));
        }
        return EmfCommandUtils.createResult((List)commandList, (String)Messages.TableInstanceCommandFactory_removeUselessColumn);
    }

    public Command createRemoveRowsCommand(Collection<Row> rows) {
        CommandList cmdList = new CommandList();
        for (Row row : rows) {
            Command removeRowCommand = this.basicCmdFactory.createRemoveCommand(this.table, TablePackage.eINSTANCE.getTable_Rows(), row);
            cmdList.add(removeRowCommand);
        }
        Command updateColumnCmd = this.createRemoveUselessColumnsCommand(rows, null);
        cmdList.add(updateColumnCmd);
        String msg = String.format("Remove %s row(s)", cmdList.size());
        return EmfCommandUtils.createResult((List)cmdList, (String)msg);
    }

    @Override
    public Command createAddRowsCommand(Collection<? extends EObject> eObjects) {
        CommandList cmdList = new CommandList();
        int nbRows = 0;
        HashSet<EPackage> alreadyDone = new HashSet<EPackage>();
        ArrayList<EStructuralFeature> processedSF = new ArrayList<EStructuralFeature>();
        List<EObject> tableContent = TableWidgetUtils.getElements(this.table);
        for (EObject eObject : eObjects) {
            if (tableContent.contains(eObject)) continue;
            Row row = TableFactory.eINSTANCE.createRow();
            Command setToRowCmd = this.basicCmdFactory.createSetCommand(row, TablePackage.eINSTANCE.getRow_Element(), eObject);
            cmdList.add(setToRowCmd);
            Command addRowCmd = this.basicCmdFactory.createAddCommand(this.table, TablePackage.eINSTANCE.getTable_Rows(), row);
            cmdList.add(addRowCmd);
            ++nbRows;
            for (EStructuralFeature eStructuralFeature : eObject.eClass().getEAllStructuralFeatures()) {
                if (processedSF.contains(eStructuralFeature)) continue;
                processedSF.add(eStructuralFeature);
                Command createAddColumn = this.createAddColumn(alreadyDone, eStructuralFeature);
                cmdList.add(createAddColumn);
            }
        }
        String string = String.format("Add of %s rows", nbRows);
        return EmfCommandUtils.createResult((List)cmdList, (String)string);
    }

    private Command createAddColumn(Set<EPackage> alreadyDone, EStructuralFeature structuralFeature) {
        CommandList cmdList = new CommandList();
        if (!CommandFactoryUtils.isColumnAlreadyDeclared(this.table, structuralFeature)) {
            FeatureColumn referenceColumn = TableFactory.eINSTANCE.createFeatureColumn();
            referenceColumn.setFeature((ETypedElement)structuralFeature);
            Command cmd = this.basicCmdFactory.createAddCommand(this.table, TablePackage.eINSTANCE.getTable_Columns(), referenceColumn);
            cmdList.add(cmd);
            EList localCustoms = this.table.getLocalCustomizations();
            EClass eClass = structuralFeature.getEContainingClass();
            if (eClass != null) {
                EPackage ePackage = eClass.getEPackage();
                Customization customExtPackage = CustomizationUtils.findCustomizationExtendingEPackage((List<Customization>)localCustoms, ePackage);
                if (!alreadyDone.contains(ePackage) && customExtPackage == null) {
                    Command localCustomCmd = this.locCustCmdFactory.createAddLocalCustomCommand(ePackage);
                    if (localCustomCmd.canExecute()) {
                        cmdList.add(localCustomCmd);
                    }
                    alreadyDone.add(ePackage);
                }
            }
        }
        String msg = String.format("Add a column for %s::%s", structuralFeature.getEContainingClass().getName(), structuralFeature.getName());
        return EmfCommandUtils.createResult((List)cmdList, (String)msg);
    }

    @Override
    public Command createSetFacetSetsCommand(List<? extends FacetSet> facetSets) {
        return this.fctCustCmdFactory.createSetLoadedFacetSetsCommand(facetSets, true);
    }

    public Command createDeleteSelectedElementsCommand(Collection<EObject> toDelete) throws CoreException {
        CommandList commandList = new CommandList();
        for (EObject eObjectToDelete : toDelete) {
            Command deleteCommand = this.basicCmdFactory.createDeleteCommand(eObjectToDelete);
            commandList.add(deleteCommand);
        }
        Command command = EmfCommandUtils.createResult((List)commandList, (String)"delete selected");
        DebugUtils.debug((boolean)DEBUG, (String)("compoundCommand.canExecute()=" + command.canExecute()));
        return command;
    }

    public Command createDropCommand(IStructuredSelection selection, Object element, EStructuralFeature feature) {
        CommandList commandList = new CommandList();
        if (feature.isMany()) {
            for (Object object : selection.toList()) {
                Command addCommand = this.basicCmdFactory.createAddCommand(element, feature, object);
                commandList.add(addCommand);
            }
        } else if (selection.toList().size() == 1) {
            Object firstElement = selection.getFirstElement();
            Command addCommand = this.basicCmdFactory.createSetCommand(element, feature, firstElement);
            commandList.add(addCommand);
        }
        return EmfCommandUtils.createResult((List)commandList, (String)"drop");
    }

    /*
     * WARNING - void declaration
     */
    private Command delete(String label, Collection<? extends EObject> eObjects) {
        void var4_8;
        ArrayList<Command> cmdList = new ArrayList<Command>();
        for (EObject eObject : eObjects) {
            Command command = this.basicCmdFactory.createDeleteCommand(eObject);
            cmdList.add(command);
        }
        Object var4_6 = null;
        if (!cmdList.isEmpty()) {
            Command command = EmfCommandUtils.createResult(cmdList, (String)label);
        }
        return var4_8;
    }

    public final Command createRemoveUselessRowsAndColumnsCommand() {
        Command removeColumnCmd;
        Command deleteRows;
        ArrayList<Command> cmdList = new ArrayList<Command>();
        List<Row> rowsToRemove = this.findUselessRow();
        if (DEBUG_RM_ROWCOLS) {
            DebugUtils.debug((String)("Rows to be removed: " + rowsToRemove.size()));
        }
        if ((deleteRows = this.delete(Messages.TableWidgetController_DeleteUselessRows, rowsToRemove)) != null) {
            cmdList.add(deleteRows);
        }
        if ((removeColumnCmd = this.createRemoveUselessColumnsCommand(rowsToRemove, null)) != null) {
            if (!removeColumnCmd.canExecute()) {
                throw new TableWidgetRuntimeException("Command cannot be executed");
            }
            cmdList.add(removeColumnCmd);
        }
        Command command = null;
        if (!cmdList.isEmpty()) {
            command = EmfCommandUtils.createResult(cmdList, (String)Messages.TableWidgetController_RemoveUselessRowsAndColumns);
        }
        return command;
    }

    public FacetAndCustomCommandFactory getFacetAndCustomCommandFactory() {
        return this.fctCustCmdFactory;
    }

    public LocalCustomCommandFactory getLocalCustomCommandFactory() {
        return this.locCustCmdFactory;
    }

    private List<Row> findUselessRow() {
        ArrayList<Row> rowsToRemove = new ArrayList<Row>();
        for (Row row : this.table.getRows()) {
            if (row.getElement() != null && row.getElement().eResource() != null) continue;
            rowsToRemove.add(row);
        }
        return rowsToRemove;
    }
}

