/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.businessprocess;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.rcp.events.GuiEventDispatcher;
import org.eclipse.jubula.client.ui.rcp.handlers.open.AbstractOpenHandler;
import org.eclipse.jubula.client.ui.rcp.sourceprovider.NavigationSourceProvider;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBNavigationHistory
implements ISelectionListener,
GuiEventDispatcher.IEditorDirtyStateListener {
    private static final int MAX_DISPLAYED = 10;
    private static final int MAX_STORED = 50;
    private static final Logger LOG = LoggerFactory.getLogger(JBNavigationHistory.class);
    private static JBNavigationHistory instance = null;
    private List<NavHistEntry> m_navHistory = new ArrayList<NavHistEntry>();
    private int m_current = -1;
    private List<NavigationSourceProvider> m_providers = new ArrayList<NavigationSourceProvider>();

    private JBNavigationHistory() {
    }

    public static synchronized JBNavigationHistory getInstance() {
        if (instance == null) {
            instance = new JBNavigationHistory();
            GuiEventDispatcher.getInstance().addEditorDirtyStateListener(instance, false);
        }
        return instance;
    }

    public synchronized void addProvider(NavigationSourceProvider prov) {
        this.m_providers.add(prov);
    }

    public synchronized void removeProvider(NavigationSourceProvider prov) {
        this.m_providers.remove((Object)prov);
    }

    private void fireProviders() {
        boolean canBack = this.m_current > 0;
        boolean canForward = this.m_current < this.m_navHistory.size() - 1;
        boolean canEditBack = false;
        int i = 0;
        while (i < this.m_current) {
            if (this.m_navHistory.get(i).m_edited) {
                canEditBack = true;
                break;
            }
            ++i;
        }
        boolean canEditForw = false;
        int i2 = this.m_current + 1;
        while (i2 < this.m_navHistory.size()) {
            if (this.m_navHistory.get(i2).m_edited) {
                canEditForw = true;
                break;
            }
            ++i2;
        }
        for (NavigationSourceProvider prov : this.m_providers) {
            prov.fireSourceChanged(canBack, canForward, canEditBack, canEditForw);
        }
    }

    public synchronized void selectionChanged(IWorkbenchPart part, ISelection selection) {
        try {
            IPersistentObject ob = null;
            if (part instanceof AbstractJBEditor) {
                ob = ((AbstractJBEditor)part).getEditorHelper().getEditSupport().getOriginal();
            } else if (part instanceof ObjectMappingMultiPageEditor) {
                ob = ((ObjectMappingMultiPageEditor)part).getEditorHelper().getEditSupport().getOriginal();
            }
            if (ob == null || !this.m_navHistory.isEmpty() && ob.equals(this.m_navHistory.get(this.m_current).m_po)) {
                return;
            }
            this.addHistoryEntry(ob);
        }
        catch (Exception e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            this.m_navHistory.clear();
            this.m_current = -1;
        }
        this.fireProviders();
    }

    private void addHistoryEntry(IPersistentObject po) {
        int size = this.m_navHistory.size();
        if (size > 0 && ObjectUtils.equals((Object)po, (Object)this.m_navHistory.get(size - 1).m_po)) {
            return;
        }
        if (size == 50) {
            this.m_navHistory.remove(0);
        }
        this.m_navHistory.add(new NavHistEntry(po));
        this.m_current = this.m_navHistory.size() - 1;
    }

    public synchronized void move(int pos, boolean absolute) {
        int newPos = absolute ? pos : this.m_current + pos;
        if (!this.isValidPos(newPos)) {
            return;
        }
        this.setPosition(newPos);
    }

    private void setPosition(int pos) {
        int save = this.m_current;
        this.m_current = pos;
        if (AbstractOpenHandler.openEditor(this.m_navHistory.get(pos).m_po) == null) {
            this.m_current = save;
            this.m_navHistory.remove(pos);
            if (this.m_current > this.m_navHistory.size()) {
                this.m_current = this.m_navHistory.size() - 1;
            } else if (this.m_current > pos) {
                --this.m_current;
            }
        } else {
            this.m_current = pos;
        }
        this.fireProviders();
    }

    public synchronized void editedMove(int direction) {
        int end;
        int start = this.m_current + direction;
        int n = end = direction == 1 ? this.m_navHistory.size() - 1 : 0;
        if (!this.isValidPos(start) || !this.isValidPos(end)) {
            return;
        }
        int safe = 0;
        int i = start;
        while (i != end + direction) {
            if (++safe == 1000) {
                LOG.error("Infinite loop!");
            }
            if (this.m_navHistory.get(i).m_edited) {
                this.setPosition(i);
                return;
            }
            i += direction;
        }
    }

    public synchronized boolean isValidPos(int pos) {
        return pos >= 0 && pos < this.m_navHistory.size();
    }

    public synchronized SortedMap<Integer, String> getContribItems(boolean backwards, boolean edit) {
        int end;
        int start;
        TreeMap<Integer, String> res = new TreeMap<Integer, String>();
        if (backwards) {
            start = 0;
            end = this.m_current - 1;
        } else {
            start = this.m_current + 1;
            end = this.m_navHistory.size() - 1;
        }
        if (!this.isValidPos(start) || !this.isValidPos(end)) {
            return res;
        }
        int num = 0;
        int i = start;
        while (i <= end) {
            if (!edit || this.m_navHistory.get(i).m_edited) {
                IPersistentObject po = this.m_navHistory.get(i).m_po;
                String name = po instanceof ITestDataCategoryPO ? "Central Test Data" : (po instanceof IAUTMainPO ? "OM / " + po.getName() : po.getName());
                res.put(i, name);
                if (++num > 10) break;
            }
            ++i;
        }
        return res;
    }

    @Override
    public synchronized void handleEditorDirtyStateChanged(IJBEditor editor, boolean isDirty) {
        if (this.m_current < 0 || this.m_current >= this.m_navHistory.size()) {
            return;
        }
        NavHistEntry curr = this.m_navHistory.get(this.m_current);
        IPersistentObject editedPo = editor.getEditorHelper().getEditSupport().getWorkVersion();
        if (isDirty && ObjectUtils.equals((Object)editedPo, (Object)curr.m_po)) {
            curr.m_edited = true;
            this.fireProviders();
        }
    }

    private class NavHistEntry {
        private IPersistentObject m_po;
        private boolean m_edited = false;

        private NavHistEntry(IPersistentObject po) {
            this.m_po = po;
        }
    }
}

