/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing;

import java.awt.AWTError;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRobotFactory;
import org.eclipse.jubula.rc.common.exception.ComponentNotFoundException;
import org.eclipse.jubula.rc.common.listener.AUTEventListener;
import org.eclipse.jubula.rc.common.listener.BaseAUTListener;
import org.eclipse.jubula.rc.swing.driver.RobotFactoryConfig;
import org.eclipse.jubula.rc.swing.listener.CheckListener;
import org.eclipse.jubula.rc.swing.listener.ComponentHandler;
import org.eclipse.jubula.rc.swing.listener.FocusTracker;
import org.eclipse.jubula.rc.swing.listener.MappingListener;
import org.eclipse.jubula.rc.swing.listener.RecordListener;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingAUTServer
extends AUTServer {
    private static final Logger LOG = LoggerFactory.getLogger(SwingAUTServer.class);
    private static final String EDT_NAME_REGEX_KEY = "TEST_EDT_NAME_REGEX";

    public SwingAUTServer() {
        super((AUTEventListener)new MappingListener(), (AUTEventListener)new RecordListener(), (AUTEventListener)new CheckListener());
    }

    protected void startToolkitThread() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            public void eventDispatched(AWTEvent event) {
            }
        }, 0L);
    }

    protected void addToolkitEventListeners() {
        this.addToolkitEventListener(new ComponentHandler());
        this.addToolkitEventListener(new FocusTracker());
    }

    protected void addToolkitEventListener(BaseAUTListener listener) {
        if (LOG.isInfoEnabled()) {
            LOG.info("installing AWTEventListener " + listener.toString());
        }
        try {
            long mask = 0L;
            int i = 0;
            while (i < listener.getEventMask().length) {
                mask |= listener.getEventMask()[i];
                ++i;
            }
            Toolkit.getDefaultToolkit().addAWTEventListener((AWTEventListener)listener, mask);
        }
        catch (AWTError awte) {
            LOG.error(awte.getLocalizedMessage(), (Throwable)awte);
        }
        catch (SecurityException se) {
            LOG.error(se.getLocalizedMessage(), (Throwable)se);
            System.exit(21);
        }
    }

    protected void removeToolkitEventListener(BaseAUTListener listener) {
        if (LOG.isInfoEnabled()) {
            LOG.info("removing AWTEventListener " + listener.toString());
        }
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener((AWTEventListener)listener);
        }
        catch (AWTError awte) {
            LOG.error(awte.getLocalizedMessage(), (Throwable)awte);
        }
        catch (SecurityException se) {
            LOG.error(se.getLocalizedMessage(), (Throwable)se);
            System.exit(21);
        }
    }

    protected void startTasks() throws ExceptionInInitializerError, InvocationTargetException, NoSuchMethodException {
        String edtNameRegEx = EnvironmentUtils.getProcessOrSystemProperty((String)EDT_NAME_REGEX_KEY);
        if (edtNameRegEx != null) {
            try {
                Pattern.compile(edtNameRegEx);
            }
            catch (PatternSyntaxException pse) {
                throw new InvocationTargetException(pse, "Invalid TEST_EDT_NAME_REGEX value.");
            }
            final String accessibleEdtNameRegEx = edtNameRegEx;
            Thread addListenersThread = new Thread("Register initial Jubula Swing / AWT listeners"){

                public void run() {
                    boolean isThreadFound = false;
                    ThreadGroup rootThreadGroup = Thread.currentThread().getThreadGroup();
                    while (rootThreadGroup.getParent() != null) {
                        rootThreadGroup = rootThreadGroup.getParent();
                    }
                    while (!isThreadFound) {
                        Thread[] activeThreads = SwingAUTServer.getActiveThreads();
                        int i = 0;
                        while (i < activeThreads.length) {
                            if (activeThreads[i].getName().matches(accessibleEdtNameRegEx)) {
                                isThreadFound = true;
                                break;
                            }
                            ++i;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    SwingAUTServer.this.addToolKitEventListenerToAUT();
                }
            };
            addListenersThread.setDaemon(true);
            addListenersThread.start();
        } else {
            this.startToolkitThread();
            this.addToolKitEventListenerToAUT();
        }
        AUTServer.getInstance().invokeAUT();
    }

    public IRobot getRobot() {
        IRobotFactory robotFactory = new RobotFactoryConfig().getRobotFactory();
        return robotFactory.getRobot();
    }

    private static Thread[] getActiveThreads() {
        Thread[] threads;
        ThreadGroup rootThreadGroup = Thread.currentThread().getThreadGroup();
        while (rootThreadGroup.getParent() != null) {
            rootThreadGroup = rootThreadGroup.getParent();
        }
        int nAlloc = rootThreadGroup.activeCount();
        int n = 0;
        while ((n = rootThreadGroup.enumerate(threads = new Thread[nAlloc *= 2])) == nAlloc) {
        }
        Thread[] returnArray = new Thread[n];
        System.arraycopy(threads, 0, returnArray, 0, n);
        return returnArray;
    }

    public Object findComponent(IComponentIdentifier ci, int timeout) throws ComponentNotFoundException, IllegalArgumentException {
        return ComponentHandler.findComponent(ci, true, timeout);
    }

    public boolean isComponentDisappeared(IComponentIdentifier ci, int timeout) throws ComponentNotFoundException, IllegalArgumentException {
        return ComponentHandler.isComponentDisappeared(ci, timeout);
    }
}

