/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.commands;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.FixAnchorHelper;

public abstract class AbstractFixEdgeAnchorDeferredCommand
extends AbstractTransactionalCommand {
    private IGraphicalEditPart containerEP;
    private FixAnchorHelper helper;
    private static final Point orig = new Point(0, 0);
    private static final Dimension nullDimension = new Dimension(0, 0);

    public AbstractFixEdgeAnchorDeferredCommand(TransactionalEditingDomain editingDomain, String commandTitle, IGraphicalEditPart containerEP) {
        super(editingDomain, commandTitle, null);
        this.containerEP = containerEP;
        this.helper = new FixAnchorHelper(editingDomain);
    }

    public List getAffectedFiles() {
        View view;
        if (this.containerEP != null && (view = (View)this.containerEP.getModel()) != null) {
            IFile f = WorkspaceSynchronizer.getFile((Resource)view.eResource());
            return f != null ? Collections.singletonList(f) : Collections.EMPTY_LIST;
        }
        return super.getAffectedFiles();
    }

    protected void addFixAnchorCommand(AbstractConnectionEditPart connectionToRefresh, CompoundCommand commandToContribute) {
        Command cc;
        PrecisionRectangle nodeBounds;
        INodeEditPart nodeEditPart;
        Assert.isNotNull((Object)commandToContribute);
        EditPart sourceEditPart = connectionToRefresh.getSource();
        EditPart targetEditPart = connectionToRefresh.getTarget();
        if (sourceEditPart instanceof NodeEditPart) {
            nodeEditPart = (INodeEditPart)sourceEditPart;
            nodeBounds = new PrecisionRectangle(nodeEditPart.getFigure().getBounds());
            nodeEditPart.getFigure().translateToAbsolute((Translatable)nodeBounds);
            cc = this.helper.getFixAnchorCommand(nodeEditPart, nodeBounds, nodeBounds, connectionToRefresh, orig, nullDimension, true);
            if (cc != null) {
                commandToContribute.add(cc);
            }
        }
        if (targetEditPart instanceof NodeEditPart) {
            nodeEditPart = (INodeEditPart)targetEditPart;
            nodeBounds = new PrecisionRectangle(nodeEditPart.getFigure().getBounds());
            nodeEditPart.getFigure().translateToAbsolute((Translatable)nodeBounds);
            cc = this.helper.getFixAnchorCommand(nodeEditPart, nodeBounds, nodeBounds, connectionToRefresh, orig, nullDimension, false);
            if (cc != null) {
                commandToContribute.add(cc);
            }
        }
    }

    protected void cleanup() {
        this.containerEP = null;
        this.helper = null;
        super.cleanup();
    }

    protected final IFigure getContainerFigure() {
        return this.containerEP.getFigure();
    }

    protected final IGraphicalEditPart getContainerEP() {
        return this.containerEP;
    }

    public boolean canExecute() {
        return super.canExecute() && this.helper != null && this.containerEP != null;
    }
}

