/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.menu.handlers;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.gmfdiag.menu.handlers.AbstractDiagramHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectElementWithTheSameTypeHandler
extends AbstractDiagramHandler {
    protected IStructuredSelection selection;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.selection != null) {
            Object elem = this.selection.getFirstElement();
            IGraphicalEditPart part = (IGraphicalEditPart)elem;
            EObject o1 = this.getEObject((GraphicalEditPart)part);
            Map elements = part.getViewer().getEditPartRegistry();
            Object[] values = elements.values().toArray();
            ArrayList<Object> listElement = new ArrayList<Object>();
            this.add(listElement, part);
            int i = 0;
            while (i < values.length) {
                if (values[i] instanceof IGraphicalEditPart) {
                    IGraphicalEditPart nextPart = (IGraphicalEditPart)values[i];
                    EObject o2 = this.getEObject((GraphicalEditPart)nextPart);
                    if (o1 == null || o2 == null) {
                        if (part.getModel() instanceof View && nextPart.getModel() instanceof View) {
                            View view1 = (View)part.getModel();
                            View view2 = (View)nextPart.getModel();
                            if (view1.getType() != null && view1.getType().equals(view2.getType())) {
                                this.add(listElement, nextPart);
                            }
                        }
                    } else if (part instanceof ConnectionEditPart && nextPart instanceof ConnectionEditPart) {
                        if (o1 != o2 && o1.eClass().equals(o2.eClass())) {
                            this.add(listElement, nextPart);
                        }
                    } else if (o1 != o2 && o1.eClass().equals(o2.eClass()) && this.isEquivalent(part.getParent(), nextPart.getParent())) {
                        this.add(listElement, nextPart);
                    }
                }
                ++i;
            }
            part.getViewer().setSelection((ISelection)new StructuredSelection(listElement));
        }
        return null;
    }

    private void add(ArrayList<Object> listElement, IGraphicalEditPart nextPart) {
        if (nextPart.isSelectable()) {
            listElement.add(nextPart);
        }
    }

    private boolean isEquivalent(EditPart part, EditPart nextPart) {
        if (part instanceof GraphicalEditPart && nextPart instanceof GraphicalEditPart) {
            EObject eObject = this.getEObject((GraphicalEditPart)part);
            EObject eObject2 = this.getEObject((GraphicalEditPart)nextPart);
            return eObject != null && eObject2 != null && eObject.eClass().equals(eObject2.eClass());
        }
        return false;
    }

    private EObject getEObject(GraphicalEditPart part) {
        if (part.getModel() instanceof View) {
            return ((View)part.getModel()).getElement();
        }
        return null;
    }

    public static boolean verifySameTypeOfSelectedElements(ISelection selection) {
        if (!(selection instanceof StructuredSelection) || selection.isEmpty()) {
            return false;
        }
        Object[] elems = ((StructuredSelection)selection).toArray();
        if (elems.length == 1 && elems[0] instanceof DiagramEditPart) {
            return false;
        }
        boolean selectable = true;
        int i = 0;
        while (i < elems.length - 1) {
            Object elem1 = elems[i];
            Object elem2 = elems[i + 1];
            if (elem1 instanceof IGraphicalEditPart && elem2 instanceof IGraphicalEditPart) {
                IGraphicalEditPart part1 = (IGraphicalEditPart)elem1;
                IGraphicalEditPart part2 = (IGraphicalEditPart)elem2;
                selectable &= part1.isSelectable() && part2.isSelectable();
                View view1 = (View)part1.getModel();
                View view2 = (View)part2.getModel();
                if (view1 != null && view2 != null && view1.getElement() != null && view2.getElement() != null && view1.getElement().eClass() != view2.getElement().eClass()) {
                    return false;
                }
            }
            ++i;
        }
        return selectable;
    }

    public void setEnabled(Object evaluationContext) {
        this.selection = null;
        this.buildSelection();
        boolean isEnabled = false;
        if (this.selection != null) {
            isEnabled = SelectElementWithTheSameTypeHandler.verifySameTypeOfSelectedElements((ISelection)this.selection);
        }
        this.setBaseEnabled(isEnabled);
    }

    protected void buildSelection() {
        this.selection = null;
        IDiagramWorkbenchPart diagramWorkbenchPart = this.getDiagramWorkbenchPart();
        if (diagramWorkbenchPart != null) {
            this.selection = (IStructuredSelection)diagramWorkbenchPart.getSite().getSelectionProvider().getSelection();
        }
    }
}

