/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.wizard.code;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.job.ResourceBlockingOperationJob;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.codetype.CodeTypeNewOperation;
import org.eclipse.scout.sdk.s2e.ui.internal.wizard.code.CodeTypeNewWizardPage;
import org.eclipse.scout.sdk.s2e.ui.util.PackageContainer;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizard;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CodeTypeNewWizard
extends AbstractWizard
implements INewWizard {
    private static volatile Class<? extends CodeTypeNewWizardPage> pageClass = CodeTypeNewWizardPage.class;
    private CodeTypeNewWizardPage m_page1;
    private boolean m_executed = false;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        PackageContainer packageContainer = S2eUiUtils.getSharedPackageOfSelection((ISelection)selection);
        try {
            this.m_page1 = CodeTypeNewWizard.getPage1Class().getConstructor(PackageContainer.class).newInstance(packageContainer);
            this.addPage((IWizardPage)this.m_page1);
            this.setWindowTitle(this.m_page1.getTitle());
            this.setHelpAvailable(true);
            this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new SdkException((Throwable)e);
        }
    }

    public void scheduleCodeTypeCreation(final CodeTypeNewOperation op) {
        if (this.isExecuted()) {
            return;
        }
        op.setCodeTypeName(this.m_page1.getIcuName());
        op.setPackage(this.m_page1.getTargetPackage());
        op.setSharedSourceFolder(this.m_page1.getSourceFolder());
        op.setCodeTypeIdSignature(this.m_page1.getCodeTypeIdDatatypeSignature());
        op.setSuperTypeSignature(this.m_page1.getSuperTypeSignature());
        final Display d = this.getContainer().getShell().getDisplay();
        ResourceBlockingOperationJob job = new ResourceBlockingOperationJob((IOperation)op, new IResource[]{this.m_page1.getSourceFolder().getResource()});
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                d.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IType createdCodeType = op.getCreatedCodeType();
                        if (!S2eUtils.exists((IJavaElement)createdCodeType)) {
                            return;
                        }
                        S2eUiUtils.openInEditor((IJavaElement)createdCodeType);
                    }
                });
            }
        });
        job.schedule();
        this.setExecuted(true);
    }

    @Override
    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        if (!this.isExecuted()) {
            this.scheduleCodeTypeCreation(new CodeTypeNewOperation());
        }
        return true;
    }

    public boolean isExecuted() {
        return this.m_executed;
    }

    protected void setExecuted(boolean executed) {
        this.m_executed = executed;
    }

    public static Class<? extends CodeTypeNewWizardPage> getPage1Class() {
        return pageClass;
    }

    public static void setPage1Class(Class<? extends CodeTypeNewWizardPage> page1Class) {
        pageClass = page1Class;
    }
}

