/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.properties;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;
import org.eclipse.viatra.query.tooling.ui.queryresult.properties.MatchParameterPropertyDescriptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;

public class MatcherFiltersPropertySource<MATCH extends IPatternMatch>
implements IPropertySource {
    private final QueryResultTreeMatcher<MATCH> matcher;
    private final Map<PParameter, IPropertyDescriptor> descriptors = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

    public MatcherFiltersPropertySource(QueryResultTreeMatcher<MATCH> matcher) {
        this.matcher = matcher;
    }

    public Object getEditableValue() {
        return this;
    }

    public String toString() {
        boolean _isFiltered = this.matcher.isFiltered();
        if (_isFiltered) {
            return "Filtered";
        }
        return "No filters specified";
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList filters = Lists.newArrayList();
        List parameters = this.matcher.getMatcher().getSpecification().getParameters();
        boolean _isEmpty = this.descriptors.isEmpty();
        if (_isEmpty) {
            Consumer<PParameter> _function = it -> {
                MatchParameterPropertyDescriptor property = new MatchParameterPropertyDescriptor((PParameter)it, this.matcher);
                this.descriptors.put((PParameter)it, property);
                filters.add(property);
            };
            parameters.forEach(_function);
        } else {
            Consumer<PParameter> _function_1 = it -> filters.add(this.descriptors.get(it));
            parameters.forEach(_function_1);
        }
        return filters.toArray(new IPropertyDescriptor[0]);
    }

    public Object getPropertyValue(Object id) {
        PParameter param = (PParameter)id;
        return this.matcher.getFilterMatch().get(param.getName());
    }

    public boolean isPropertySet(Object id) {
        PParameter param = (PParameter)id;
        Object _get = this.matcher.getFilterMatch().get(param.getName());
        return _get != null;
    }

    public void resetPropertyValue(Object id) {
        PParameter param = (PParameter)id;
        this.matcher.getFilterMatch().set(param.getName(), null);
        this.matcher.filterUpdated(this.matcher.getFilterMatch());
    }

    public void setPropertyValue(Object id, Object value) {
        PParameter param = (PParameter)id;
        this.matcher.getFilterMatch().set(param.getName(), value);
        this.matcher.filterUpdated(this.matcher.getFilterMatch());
    }
}

