/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.specs.Spec;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.base.Charsets;
import org.gradle.internal.impldep.javax.annotation.Nullable;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.io.LineBufferingOutputStream;
import org.gradle.internal.io.SkipFirstTextStream;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.internal.io.WriterTextStream;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUtil {
    private static final Pattern WORD_SEPARATOR = Pattern.compile("\\W+");
    private static final Pattern UPPER_LOWER = Pattern.compile("(?m)([A-Z]*)([a-z0-9]*)");

    public static <T extends Collection> T flatten(Object[] elements, T addTo, boolean flattenMaps) {
        return GUtil.flatten(Arrays.asList(elements), addTo, flattenMaps);
    }

    public static <T extends Collection> T flatten(Object[] elements, T addTo) {
        return GUtil.flatten(Arrays.asList(elements), addTo);
    }

    public static <T extends Collection> T flatten(Collection elements, T addTo) {
        return GUtil.flatten(elements, addTo, true);
    }

    public static <T extends Collection> T flattenElements(Object ... elements) {
        LinkedList out = new LinkedList();
        GUtil.flatten(elements, out, true);
        return (T)out;
    }

    public static <T extends Collection> T flatten(Collection elements, T addTo, boolean flattenMapsAndArrays) {
        return GUtil.flatten(elements, addTo, flattenMapsAndArrays, flattenMapsAndArrays);
    }

    public static <T extends Collection> T flatten(Collection elements, T addTo, boolean flattenMaps, boolean flattenArrays) {
        for (Object element : elements) {
            if (element instanceof Collection) {
                GUtil.flatten((Collection)element, addTo, flattenMaps, flattenArrays);
                continue;
            }
            if (element instanceof Map && flattenMaps) {
                GUtil.flatten(((Map)element).values(), addTo, flattenMaps, flattenArrays);
                continue;
            }
            if (element.getClass().isArray() && flattenArrays) {
                GUtil.flatten(Arrays.asList((Object[])element), addTo, flattenMaps, flattenArrays);
                continue;
            }
            addTo.add(element);
        }
        return addTo;
    }

    public static Collection collectionize(Object input) {
        if (input == null) {
            return Collections.emptyList();
        }
        if (input instanceof Collection) {
            LinkedList out = new LinkedList();
            GUtil.flatten((Collection)input, out, false, true);
            return out;
        }
        if (input.getClass().isArray()) {
            LinkedList out = new LinkedList();
            GUtil.flatten(Arrays.asList((Object[])input), out, false, true);
            return out;
        }
        return Arrays.asList(input);
    }

    public static List flatten(Collection elements, boolean flattenMapsAndArrays) {
        return GUtil.flatten(elements, new ArrayList(), flattenMapsAndArrays);
    }

    public static List flatten(Collection elements) {
        return GUtil.flatten(elements, new ArrayList());
    }

    public static String asPath(Iterable<?> collection) {
        return CollectionUtils.join(File.pathSeparator, collection);
    }

    public static List<String> prefix(String prefix, Collection<String> strings) {
        ArrayList<String> prefixed = new ArrayList<String>();
        for (String string : strings) {
            prefixed.add(prefix + string);
        }
        return prefixed;
    }

    public static boolean isTrue(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Collection) {
            return ((Collection)object).size() > 0;
        }
        if (object instanceof String) {
            return ((String)object).length() > 0;
        }
        return true;
    }

    public static <T> T elvis(@Nullable T object, T defaultValue) {
        return GUtil.isTrue(object) ? object : defaultValue;
    }

    public static <V, T extends Collection<? super V>> T addToCollection(T dest, boolean failOnNull, Iterable<? extends V> ... srcs) {
        for (Iterable<V> iterable : srcs) {
            for (V v : iterable) {
                if (failOnNull && v == null) {
                    throw new IllegalArgumentException("Illegal null value provided in this collection: " + iterable);
                }
                dest.add(v);
            }
        }
        return dest;
    }

    public static <V, T extends Collection<? super V>> T addToCollection(T dest, Iterable<? extends V> ... srcs) {
        return GUtil.addToCollection(dest, false, srcs);
    }

    public static Comparator<String> caseInsensitive() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int diff = o1.compareToIgnoreCase(o2);
                if (diff != 0) {
                    return diff;
                }
                return o1.compareTo(o2);
            }
        };
    }

    public static Map addMaps(Map map1, Map map2) {
        HashMap map = new HashMap();
        map.putAll(map1);
        map.putAll(map2);
        return map;
    }

    public static void addToMap(Map<String, String> dest, Map<?, ?> src) {
        for (Map.Entry<?, ?> entry : src.entrySet()) {
            dest.put(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File propertyFile) {
        Properties properties;
        FileInputStream inputStream = new FileInputStream(propertyFile);
        try {
            properties = GUtil.loadProperties(inputStream);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        inputStream.close();
        return properties;
    }

    public static Properties loadProperties(URL url) {
        try {
            URLConnection uc = url.openConnection();
            uc.setUseCaches(false);
            return GUtil.loadProperties(uc.getInputStream());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Properties loadProperties(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProperties(Properties properties, File propertyFile) {
        try {
            FileOutputStream propertiesFileOutputStream = new FileOutputStream(propertyFile);
            try {
                properties.store(propertiesFileOutputStream, null);
            }
            finally {
                propertiesFileOutputStream.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProperties(Properties properties, OutputStream outputStream) {
        try {
            try {
                properties.store(outputStream, null);
            }
            finally {
                outputStream.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void savePropertiesNoDateComment(Properties properties, File propertyFile) {
        try {
            FileOutputStream propertiesFileOutputStream = new FileOutputStream(propertyFile);
            try {
                GUtil.savePropertiesNoDateComment(properties, propertiesFileOutputStream);
            }
            finally {
                propertiesFileOutputStream.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Deprecated
    public static void savePropertiesNoDateComment(Properties properties, OutputStream outputStream) {
        GUtil.saveProperties(properties, new LineBufferingOutputStream(new SkipFirstTextStream(new WriterTextStream(new OutputStreamWriter(outputStream, Charsets.ISO_8859_1)))));
    }

    public static Map map(Object ... objects) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        assert (objects.length % 2 == 0);
        for (int i = 0; i < objects.length; i += 2) {
            map.put(objects[i], objects[i + 1]);
        }
        return map;
    }

    public static String toString(Iterable<?> names) {
        Formatter formatter = new Formatter();
        boolean first = true;
        for (Object name : names) {
            if (first) {
                formatter.format("'%s'", name);
                first = false;
                continue;
            }
            formatter.format(", '%s'", name);
        }
        return formatter.toString();
    }

    public static String toCamelCase(CharSequence string) {
        return GUtil.toCamelCase(string, false);
    }

    public static String toLowerCamelCase(CharSequence string) {
        return GUtil.toCamelCase(string, true);
    }

    private static String toCamelCase(CharSequence string, boolean lower) {
        if (string == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        Matcher matcher = WORD_SEPARATOR.matcher(string);
        int pos = 0;
        boolean first = true;
        while (matcher.find()) {
            String chunk = string.subSequence(pos, matcher.start()).toString();
            pos = matcher.end();
            if (chunk.isEmpty()) continue;
            if (lower && first) {
                chunk = StringUtils.uncapitalize(chunk);
                first = false;
            } else {
                chunk = StringUtils.capitalize(chunk);
            }
            builder.append(chunk);
        }
        String rest = string.subSequence(pos, string.length()).toString();
        rest = lower && first ? StringUtils.uncapitalize(rest) : StringUtils.capitalize(rest);
        builder.append(rest);
        return builder.toString();
    }

    public static String toConstant(CharSequence string) {
        if (string == null) {
            return null;
        }
        return GUtil.toWords(string, '_').toUpperCase();
    }

    public static String toWords(CharSequence string) {
        return GUtil.toWords(string, ' ');
    }

    public static String toWords(CharSequence string, char separator) {
        if (string == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int pos = 0;
        Matcher matcher = UPPER_LOWER.matcher(string);
        while (pos < string.length()) {
            matcher.find(pos);
            if (matcher.end() == pos) {
                ++pos;
                continue;
            }
            if (builder.length() > 0) {
                builder.append(separator);
            }
            String group1 = matcher.group(1).toLowerCase();
            String group2 = matcher.group(2);
            if (group2.length() == 0) {
                builder.append(group1);
            } else {
                if (group1.length() > 1) {
                    builder.append(group1.substring(0, group1.length() - 1));
                    builder.append(separator);
                    builder.append(group1.substring(group1.length() - 1));
                } else {
                    builder.append(group1);
                }
                builder.append(group2);
            }
            pos = matcher.end();
        }
        return builder.toString();
    }

    public static byte[] serialize(Object object) {
        StreamByteBuffer buffer = new StreamByteBuffer();
        GUtil.serialize(object, buffer.getOutputStream());
        return buffer.readAsByteArray();
    }

    public static void serialize(Object object, OutputStream outputStream) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> Comparator<T> last(final Comparator<? super T> comparator, final T lastValue) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                boolean o2Last;
                boolean o1Last = comparator.compare(o1, lastValue) == 0;
                boolean bl = o2Last = comparator.compare(o2, lastValue) == 0;
                if (o1Last && o2Last) {
                    return 0;
                }
                if (o1Last && !o2Last) {
                    return 1;
                }
                if (!o1Last && o2Last) {
                    return -1;
                }
                return comparator.compare(o1, o2);
            }
        };
    }

    public static <T> T uncheckedCall(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    public static <T extends Enum<T>> T toEnum(Class<? extends T> enumType, Object value) {
        if (enumType.isInstance(value)) {
            return (T)((Enum)enumType.cast(value));
        }
        if (value instanceof CharSequence) {
            String literal = value.toString();
            T match = GUtil.findEnumValue(enumType, literal);
            if (match != null) {
                return match;
            }
            String alternativeLiteral = GUtil.toWords(literal, '_');
            match = GUtil.findEnumValue(enumType, alternativeLiteral);
            if (match != null) {
                return match;
            }
            throw new IllegalArgumentException(String.format("Cannot convert string value '%s' to an enum value of type '%s' (valid case insensitive values: %s)", literal, enumType.getName(), CollectionUtils.join(", ", CollectionUtils.collect(Arrays.asList(enumType.getEnumConstants()), new Transformer<String, T>(){

                @Override
                public String transform(T t) {
                    return ((Enum)t).name();
                }
            }))));
        }
        throw new IllegalArgumentException(String.format("Cannot convert value '%s' of type '%s' to enum type '%s'", value, value.getClass().getName(), enumType.getName()));
    }

    private static <T extends Enum<T>> T findEnumValue(Class<? extends T> enumType, final String literal) {
        List<T> enumConstants = Arrays.asList(enumType.getEnumConstants());
        return (T)((Enum)CollectionUtils.findFirst(enumConstants, new Spec<T>(){

            @Override
            public boolean isSatisfiedBy(T enumValue) {
                return ((Enum)enumValue).name().equalsIgnoreCase(literal);
            }
        }));
    }

    public static <T extends Enum<T>> EnumSet<T> toEnumSet(Class<T> enumType, Object[] values) {
        return GUtil.toEnumSet(enumType, Arrays.asList(values));
    }

    public static <T extends Enum<T>> EnumSet<T> toEnumSet(Class<T> enumType, Iterable<?> values) {
        EnumSet<T> result = EnumSet.noneOf(enumType);
        for (Object value : values) {
            result.add(GUtil.toEnum(enumType, value));
        }
        return result;
    }

    public static boolean endsWith(CharSequence longer, CharSequence shorter) {
        int shorterLength;
        if (longer instanceof String && shorter instanceof String) {
            return ((String)longer).endsWith((String)shorter);
        }
        int longerLength = longer.length();
        if (longerLength < (shorterLength = shorter.length())) {
            return false;
        }
        for (int i = shorterLength; i > 0; --i) {
            if (longer.charAt(longerLength - i) == shorter.charAt(shorterLength - i)) continue;
            return false;
        }
        return true;
    }
}

