/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.extension.experimental;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.PaletteEntryExtension;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.resource.ImageDescriptor;

public class EditpartExtensionManager {
    protected static final Logger logger = Logger.getLogger(EditpartExtensionManager.class.getName());
    private static Map<Expression, IConfigurationElement> extensionMap = new HashMap<Expression, IConfigurationElement>();
    private static List<PaletteEntryExtension> palettes = new ArrayList<PaletteEntryExtension>();

    static {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.birt.report.designer.ui.reportItemEditpart");
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement[] enablements = elements[i].getChildren("enablement");
                if (enablements.length != 0) {
                    try {
                        extensionMap.put(ExpressionConverter.getDefault().perform(enablements[0]), elements[i]);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    IConfigurationElement[] paletteEntries = elements[i].getChildren("paletteEntry");
                    if (paletteEntries.length == 1) {
                        PaletteEntryExtension entry = new PaletteEntryExtension();
                        entry.setItemName(paletteEntries[0].getAttribute("itemName"));
                        String displayName = DEUtil.getMetaDataDictionary().getExtension(entry.getItemName()).getDisplayName();
                        entry.setLabel(displayName);
                        entry.setMenuLabel(paletteEntries[0].getAttribute("menuLabel"));
                        entry.setDescription(paletteEntries[0].getAttribute("description"));
                        entry.setIcon(EditpartExtensionManager.getImageDescriptor(paletteEntries[0], paletteEntries[0].getAttribute("icon")));
                        entry.setIconLarge(EditpartExtensionManager.getImageDescriptor(paletteEntries[0], paletteEntries[0].getAttribute("largeIcon")));
                        entry.setCategory(paletteEntries[0].getAttribute("category"));
                        entry.setCategoryDisplayName(paletteEntries[0].getAttribute("categoryDisplayName"));
                        entry.setCommand(paletteEntries[0].getAttribute("createCommand"));
                        EditpartExtensionManager.registerImage(entry);
                        palettes.add(entry);
                    }
                }
                ++i;
            }
        }
    }

    private static ImageDescriptor getImageDescriptor(IConfigurationElement extension, String iconPath) {
        if (iconPath == null) {
            return null;
        }
        URL path = Platform.getBundle((String)extension.getNamespace()).getEntry("/");
        try {
            return ImageDescriptor.createFromURL((URL)new URL(path, iconPath));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static void registerImage(PaletteEntryExtension entry) {
        String symbolName = ReportPlatformUIImages.getIconSymbolName(entry.getItemName(), "paletteIcon");
        ReportPlatformUIImages.declareImage(symbolName, entry.getIcon());
        symbolName = ReportPlatformUIImages.getIconSymbolName(entry.getItemName(), "outlineIcon");
        ReportPlatformUIImages.declareImage(symbolName, entry.getIcon());
    }

    public static EditPart createEditPart(EditPart context, Object model) {
        EvaluationContext econtext = new EvaluationContext(null, model);
        Iterator<Expression> iterator = extensionMap.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                Expression expression = iterator.next();
                if (expression.evaluate((IEvaluationContext)econtext) != EvaluationResult.TRUE) continue;
                EditPart editPart = (EditPart)extensionMap.get(expression).createExecutableExtension("type");
                editPart.setModel(model);
                return editPart;
            }
            catch (CoreException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return null;
    }

    public static PaletteEntryExtension getPaletteEntry(String extensionName) {
        for (PaletteEntryExtension entry : palettes) {
            if (!entry.getItemName().equals(extensionName)) continue;
            return entry;
        }
        return null;
    }

    public static PaletteEntryExtension[] getPaletteEntries() {
        return palettes.toArray(new PaletteEntryExtension[palettes.size()]);
    }
}

