/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.preferences.ElementNameLabelProvider;
import org.eclipse.birt.report.designer.ui.preferences.ElementNamesCellModifier;
import org.eclipse.birt.report.designer.ui.preferences.IItemListViewer;
import org.eclipse.birt.report.designer.ui.preferences.IStatusChangeListener;
import org.eclipse.birt.report.designer.ui.preferences.ItemContent;
import org.eclipse.birt.report.designer.ui.preferences.ItemContentList;
import org.eclipse.birt.report.designer.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.birt.report.designer.ui.util.PixelConverter;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ElementNamesConfigurationBlock
extends OptionsConfigurationBlock {
    private final OptionsConfigurationBlock.Key PREF_DEFAULT_NAME = this.getReportKey("designer.preview.preference.elementname.defaultname.preferencestore");
    private final OptionsConfigurationBlock.Key PREF_CUSTOM_NAME = this.getReportKey("designer.preview.preference.elementname.customname.preferencestore");
    private final OptionsConfigurationBlock.Key PREF_DESCRIPTION = this.getReportKey("designer.preview.preference.elementname.description.preferencestore");
    private PixelConverter fPixelConverter;
    private static final int columnWidth = Integer.parseInt(Messages.getString((String)"designer.preview.preference.elementname.columnwidth"));
    private static final String[] elementNames = new String[]{Messages.getString((String)"designer.preview.preference.elementname.defaultname"), Messages.getString((String)"designer.preview.preference.elementname.customname"), Messages.getString((String)"designer.preview.preference.elementname.description")};
    private Table table;
    private TableViewer tableViewer;
    private ItemContentList itemContentList;

    public ElementNamesConfigurationBlock(IStatusChangeListener context, IProject project) {
        super(context, ReportPlugin.getDefault(), project);
        this.setKeys(this.getKeys());
    }

    private OptionsConfigurationBlock.Key[] getKeys() {
        OptionsConfigurationBlock.Key[] keys = new OptionsConfigurationBlock.Key[]{this.PREF_DEFAULT_NAME, this.PREF_CUSTOM_NAME, this.PREF_DESCRIPTION};
        return keys;
    }

    @Override
    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComp.setLayout((Layout)layout);
        Composite othersComposite = this.createBuildPathTabContent(mainComp);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(20);
        othersComposite.setLayoutData((Object)gridData);
        this.validateSettings(null, null, null);
        return mainComp;
    }

    private Composite createBuildPathTabContent(Composite parent) {
        Composite pageContent = new Composite(parent, 0);
        GridData data = new GridData(1810);
        data.grabExcessHorizontalSpace = true;
        pageContent.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        pageContent.setLayout((Layout)layout);
        this.createTable(pageContent);
        this.createTableViewer();
        this.tableViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ElementNameLabelProvider());
        this.itemContentList = new ItemContentList(this, this.getKeys());
        this.tableViewer.setInput((Object)this.itemContentList);
        this.sortTable(this.tableViewer.getTable().getColumn(0), true);
        return pageContent;
    }

    private void createTable(Composite parent) {
        int tableStyle = 101124;
        this.table = new Table(parent, tableStyle);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        this.table.setLayoutData((Object)data);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        int i = 0;
        while (i < elementNames.length) {
            TableColumn column = new TableColumn(this.table, 0, i);
            column.setText(elementNames[i]);
            column.setWidth(columnWidth);
            column.addSelectionListener(new SelectionListener(){
                boolean asc = true;

                public void widgetSelected(SelectionEvent e) {
                    TableColumn selectedColumn = (TableColumn)e.widget;
                    if (ElementNamesConfigurationBlock.this.table.getSortColumn() == selectedColumn) {
                        this.asc = !this.asc;
                    }
                    ElementNamesConfigurationBlock.this.sortTable(selectedColumn, this.asc);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            ++i;
        }
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(elementNames);
        CellEditor[] editors = new CellEditor[elementNames.length];
        int i = 0;
        while (i < elementNames.length) {
            TextCellEditor textEditor = new TextCellEditor((Composite)this.table);
            ((Text)textEditor.getControl()).setTextLimit(60);
            if (i == 1) {
                ((Text)textEditor.getControl()).addVerifyListener(new VerifyListener(){

                    public void verifyText(VerifyEvent e) {
                        e.doit = e.text.indexOf(";") < 0;
                    }
                });
            }
            editors[i] = textEditor;
            ++i;
        }
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setCellModifier((ICellModifier)new ElementNamesCellModifier(this));
    }

    private void sortTable(final TableColumn column, final boolean asc) {
        Table table = this.tableViewer.getTable();
        table.setSortColumn(column);
        table.setSortDirection(asc ? 128 : 1024);
        this.tableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                int result;
                switch (ElementNamesConfigurationBlock.this.tableViewer.getTable().indexOf(column)) {
                    default: {
                        result = ((ItemContent)o1).getDisplayName().compareTo(((ItemContent)o2).getDisplayName());
                        break;
                    }
                    case 1: {
                        result = ((ItemContent)o1).getCustomName().compareTo(((ItemContent)o2).getCustomName());
                        break;
                    }
                    case 2: {
                        result = ((ItemContent)o1).getDescription().compareTo(((ItemContent)o2).getDescription());
                    }
                }
                return asc ? result : result * -1;
            }
        });
    }

    public List getElementNames() {
        return Arrays.asList(elementNames);
    }

    @Override
    protected void updateControls() {
        this.itemContentList = new ItemContentList(this, this.getKeys());
        this.tableViewer.setInput((Object)this.itemContentList);
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public ItemContentList getContentList() {
        return this.itemContentList;
    }

    class ContentProvider
    implements IStructuredContentProvider,
    IItemListViewer {
        ContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput != null) {
                ((ItemContentList)newInput).addChangeListener(this);
            }
            if (oldInput != null) {
                ((ItemContentList)oldInput).removeChangeListener(this);
            }
        }

        public void dispose() {
            ElementNamesConfigurationBlock.this.itemContentList.removeChangeListener(this);
        }

        public Object[] getElements(Object parent) {
            return ElementNamesConfigurationBlock.this.itemContentList.getContents().toArray();
        }

        @Override
        public void addContent(ItemContent content) {
            ElementNamesConfigurationBlock.this.tableViewer.add((Object)content);
        }

        @Override
        public void removeContent(ItemContent content) {
            ElementNamesConfigurationBlock.this.tableViewer.remove((Object)content);
        }

        @Override
        public void updateContent(ItemContent content) {
            ElementNamesConfigurationBlock.this.tableViewer.update((Object)content, null);
        }
    }
}

