/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.adapters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.model.BPELExtensibleElement;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.CompensationHandler;
import org.eclipse.bpel.model.CorrelationSets;
import org.eclipse.bpel.model.EventHandler;
import org.eclipse.bpel.model.FaultHandler;
import org.eclipse.bpel.model.MessageExchanges;
import org.eclipse.bpel.model.PartnerLinks;
import org.eclipse.bpel.model.Scope;
import org.eclipse.bpel.model.TerminationHandler;
import org.eclipse.bpel.model.Variables;
import org.eclipse.bpel.ui.actions.CreateCorrelationSetAction;
import org.eclipse.bpel.ui.actions.CreateMessageExchangeAction;
import org.eclipse.bpel.ui.actions.CreatePartnerLinkAction;
import org.eclipse.bpel.ui.actions.CreateVariableAction;
import org.eclipse.bpel.ui.actions.editpart.AbstractAction;
import org.eclipse.bpel.ui.adapters.ContainerActivityAdapter;
import org.eclipse.bpel.ui.adapters.ICompensationHandlerHolder;
import org.eclipse.bpel.ui.adapters.IContainer;
import org.eclipse.bpel.ui.adapters.IEventHandlerHolder;
import org.eclipse.bpel.ui.adapters.IFaultHandlerHolder;
import org.eclipse.bpel.ui.adapters.ITerminationHandlerHolder;
import org.eclipse.bpel.ui.adapters.delegates.ActivityContainer;
import org.eclipse.bpel.ui.adapters.delegates.MultiContainer;
import org.eclipse.bpel.ui.adapters.delegates.OptionalIndirectContainer;
import org.eclipse.bpel.ui.adapters.delegates.ReferenceContainer;
import org.eclipse.bpel.ui.editparts.OutlineTreeEditPart;
import org.eclipse.bpel.ui.editparts.ScopeEditPart;
import org.eclipse.gef.EditPart;

public class ScopeAdapter
extends ContainerActivityAdapter
implements IFaultHandlerHolder,
ICompensationHandlerHolder,
ITerminationHandlerHolder,
IEventHandlerHolder {
    @Override
    public IContainer createContainerDelegate() {
        MultiContainer omc = new MultiContainer();
        omc.add(new ActivityContainer(BPELPackage.eINSTANCE.getScope_Activity()));
        omc.add(new OptionalIndirectContainer(BPELPackage.eINSTANCE.getScope_PartnerLinks(), new ReferenceContainer(BPELPackage.eINSTANCE.getPartnerLinks_Children())));
        omc.add(new OptionalIndirectContainer(BPELPackage.eINSTANCE.getScope_CorrelationSets(), new ReferenceContainer(BPELPackage.eINSTANCE.getCorrelationSets_Children())));
        omc.add(new OptionalIndirectContainer(BPELPackage.eINSTANCE.getScope_Variables(), new ReferenceContainer(BPELPackage.eINSTANCE.getVariables_Children())));
        omc.add(new OptionalIndirectContainer(BPELPackage.eINSTANCE.getScope_MessageExchanges(), new ReferenceContainer(BPELPackage.eINSTANCE.getMessageExchanges_Children())));
        omc.add(new ReferenceContainer(BPELPackage.eINSTANCE.getScope_FaultHandlers()));
        omc.add(new ReferenceContainer(BPELPackage.eINSTANCE.getScope_CompensationHandler()));
        omc.add(new ReferenceContainer(BPELPackage.eINSTANCE.getScope_TerminationHandler()));
        omc.add(new ReferenceContainer(BPELPackage.eINSTANCE.getScope_EventHandlers()));
        return omc;
    }

    @Override
    public FaultHandler getFaultHandler(Object object) {
        return ((Scope)object).getFaultHandlers();
    }

    @Override
    public void setFaultHandler(Object object, FaultHandler faultHandler) {
        ((Scope)object).setFaultHandlers(faultHandler);
    }

    @Override
    public EventHandler getEventHandler(Object object) {
        return ((Scope)object).getEventHandlers();
    }

    @Override
    public void setEventHandler(Object object, EventHandler eventHandler) {
        ((Scope)object).setEventHandlers(eventHandler);
    }

    @Override
    public CompensationHandler getCompensationHandler(Object object) {
        return ((Scope)object).getCompensationHandler();
    }

    @Override
    public void setCompensationHandler(Object object, CompensationHandler compensationHandler) {
        ((Scope)object).setCompensationHandler(compensationHandler);
    }

    @Override
    public TerminationHandler getTerminationHandler(Object object) {
        return ((Scope)object).getTerminationHandler();
    }

    @Override
    public void setTerminationHandler(Object object, TerminationHandler terminationHandler) {
        ((Scope)object).setTerminationHandler(terminationHandler);
    }

    @Override
    public EditPart createEditPart(EditPart context, Object model) {
        ScopeEditPart result = new ScopeEditPart();
        result.setModel(model);
        return result;
    }

    @Override
    public EditPart createOutlineEditPart(EditPart context, final Object model) {
        OutlineTreeEditPart result = new OutlineTreeEditPart(){

            @Override
            protected List<BPELExtensibleElement> getModelChildren() {
                MessageExchanges exchanges;
                CorrelationSets sets;
                Variables variables;
                Scope scope = (Scope)model;
                ArrayList<BPELExtensibleElement> list = new ArrayList<BPELExtensibleElement>();
                PartnerLinks links = scope.getPartnerLinks();
                if (links != null) {
                    list.add((BPELExtensibleElement)links);
                }
                if ((variables = scope.getVariables()) != null) {
                    list.add((BPELExtensibleElement)variables);
                }
                if ((sets = scope.getCorrelationSets()) != null) {
                    list.add((BPELExtensibleElement)sets);
                }
                if ((exchanges = scope.getMessageExchanges()) != null) {
                    list.add((BPELExtensibleElement)exchanges);
                }
                ActivityContainer container = new ActivityContainer(BPELPackage.eINSTANCE.getScope_Activity());
                List<Scope> list2 = container.getChildren(scope);
                list.addAll(list2);
                return list;
            }
        };
        result.setModel(model);
        return result;
    }

    @Override
    public List<AbstractAction> getEditPartActions(EditPart editPart) {
        List<AbstractAction> actions = super.getEditPartActions(editPart);
        actions.add(new CreatePartnerLinkAction(editPart));
        actions.add(new CreateVariableAction(editPart));
        actions.add(new CreateCorrelationSetAction(editPart));
        actions.add(new CreateMessageExchangeAction(editPart));
        return actions;
    }
}

