/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.ui.internal.wizards.oxm;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jpt.common.core.internal.utility.PathTools;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.core.internal.utility.ProjectTools;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.ui.internal.wizards.NewJptFileWizardPage;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.operations.OxmFileCreationDataModelProvider;
import org.eclipse.jpt.jaxb.eclipselink.ui.JptJaxbEclipseLinkUiImages;
import org.eclipse.jpt.jaxb.eclipselink.ui.JptJaxbEclipseLinkUiMessages;
import org.eclipse.jpt.jaxb.eclipselink.ui.internal.plugin.JptJaxbEclipseLinkUiPlugin;
import org.eclipse.jpt.jaxb.eclipselink.ui.internal.wizards.oxm.OxmFileOptionsWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.IDataModelPausibleOperation;
import org.eclipse.wst.common.frameworks.internal.dialog.ui.MessageDialog;
import org.eclipse.wst.common.frameworks.internal.ui.ErrorDialog;
import org.eclipse.wst.common.frameworks.internal.ui.WTPCommonUIResourceHandler;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;

public class OxmFileWizard
extends Wizard
implements INewWizard {
    protected IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new OxmFileCreationDataModelProvider());
    protected IStructuredSelection initialSelection;
    protected IStructuredSelection mungedSelection;
    private IWizardPage firstPage;
    private IWizardPage secondPage;

    public OxmFileWizard() {
        this.setWindowTitle(JptJaxbEclipseLinkUiMessages.OXM_FILE_WIZARD__TITLE);
        this.setDefaultPageImageDescriptor(JptJaxbEclipseLinkUiImages.OXM_FILE_BANNER);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.initialSelection = selection;
        this.mungedSelection = selection;
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Object firstSelection = selection.getFirstElement();
        IPackageFragment pkg = this.extractPackage(firstSelection);
        IContainer container = this.extractContainer(pkg, firstSelection);
        while (container != null && !container.exists()) {
            container = container.getParent();
        }
        if (container != null) {
            this.mungedSelection = new StructuredSelection((Object)container);
        }
        if (pkg != null) {
            this.config.setProperty("OxmFileCreationDataModelProperties.PACKAGE_NAME", (Object)pkg.getElementName());
        }
    }

    private IPackageFragment extractPackage(Object selection) {
        return (IPackageFragment)PlatformTools.getAdapter((Object)selection, IPackageFragment.class);
    }

    private JaxbProject getJaxbProject(Object selection) {
        IProject project = this.getProject(selection);
        return project == null ? null : this.getJaxbProject(project);
    }

    private IProject getProject(Object selection) {
        return (IProject)PlatformTools.getAdapter((Object)selection, IProject.class);
    }

    private JaxbProject getJaxbProject(IProject project) {
        return (JaxbProject)project.getAdapter(JaxbProject.class);
    }

    private IContainer extractContainer(IPackageFragment pkg, Object selection) {
        IResource resource;
        if (pkg != null && (resource = pkg.getResource()) instanceof IContainer) {
            return (IContainer)resource;
        }
        resource = (IResource)PlatformTools.getAdapter((Object)selection, IResource.class);
        if (resource == null) {
            return null;
        }
        if (resource instanceof IProject) {
            return this.getDefaultContainer((IProject)resource);
        }
        if (resource instanceof IContainer) {
            return (IContainer)resource;
        }
        return resource.getParent();
    }

    private IContainer getDefaultContainer(IProject project) {
        if (ProjectTools.hasFacet((IProject)project, (IProjectFacet)JaxbProject.FACET)) {
            ProjectResourceLocator locator = (ProjectResourceLocator)project.getAdapter(ProjectResourceLocator.class);
            return locator.getDefaultLocation();
        }
        return project;
    }

    public void addPages() {
        super.addPages();
        this.firstPage = this.buildOxmFileNewFileWizardPage();
        this.secondPage = this.buildOxmFileOptionsWizardPage();
        this.addPage(this.firstPage);
        this.addPage(this.secondPage);
    }

    protected NewJptFileWizardPage buildOxmFileNewFileWizardPage() {
        return new NewJptFileWizardPage("Page_1", this.mungedSelection, this.config, JptJaxbEclipseLinkUiMessages.OXM_FILE_WIZARD__NEW_FILE_PAGE__TITLE, JptJaxbEclipseLinkUiMessages.OXM_FILE_WIZARD__NEW_FILE_PAGE__DESC);
    }

    protected OxmFileOptionsWizardPage buildOxmFileOptionsWizardPage() {
        return new OxmFileOptionsWizardPage("Page_2", this.config, JptJaxbEclipseLinkUiMessages.OXM_FILE_WIZARD__FILE_OPTIONS_PAGE__TITLE, JptJaxbEclipseLinkUiMessages.OXM_FILE_WIZARD__FILE_OPTIONS_PAGE__DESC);
    }

    public boolean canFinish() {
        return this.firstPage.isPageComplete() && this.config.validate().getSeverity() != 4;
    }

    protected IDataModelPausibleOperation getOperation() {
        return (IDataModelPausibleOperation)this.config.getDefaultOperation();
    }

    public boolean performFinish() {
        this.createOxmFile();
        try {
            this.postPerformFinish();
        }
        catch (Exception e) {
            JptJaxbEclipseLinkUiPlugin.instance().logError(e);
        }
        return true;
    }

    protected boolean createOxmFile() {
        try {
            IStatus st = this.runOperations();
            if (st.getSeverity() == 4) {
                JptJaxbEclipseLinkUiPlugin.instance().getLog().log(st);
                Throwable t = st.getException() == null ? new CoreException(st) : st.getException();
                ErrorDialog.openError((Shell)this.getShell(), (String)WTPCommonUIResourceHandler.getString((String)WTPCommonUIResourceHandler.WTPWizard_UI_0, (Object[])new Object[]{this.getWindowTitle()}), (String)WTPCommonUIResourceHandler.getString((String)WTPCommonUIResourceHandler.WTPWizard_UI_1, (Object[])new Object[]{this.getWindowTitle()}), (Throwable)t, (int)0, (boolean)false);
            } else if (st.getSeverity() == 2) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)WTPCommonUIResourceHandler.getString((String)WTPCommonUIResourceHandler.WTPWizard_UI_2, (Object[])new Object[]{this.getWindowTitle()}), (String)st.getMessage(), (IStatus)st, (int)2);
            }
        }
        catch (Exception e) {
            JptJaxbEclipseLinkUiPlugin.instance().logError(e);
            ErrorDialog.openError((Shell)this.getShell(), (String)WTPCommonUIResourceHandler.getString((String)WTPCommonUIResourceHandler.WTPWizard_UI_0, (Object[])new Object[]{this.getWindowTitle()}), (String)WTPCommonUIResourceHandler.getString((String)WTPCommonUIResourceHandler.WTPWizard_UI_1, (Object[])new Object[]{this.getWindowTitle()}), (Throwable)e, (int)0, (boolean)false);
        }
        return true;
    }

    protected IStatus runOperations() {
        class CatchThrowableRunnableWithProgress
        implements IRunnableWithProgress {
            public IStatus status = null;
            public Throwable caught = null;

            CatchThrowableRunnableWithProgress() {
            }

            public void run(IProgressMonitor pm) {
                try {
                    this.status = OxmFileWizard.this.getOperation().execute(pm, null);
                }
                catch (Throwable e) {
                    this.caught = e;
                }
            }
        }
        CatchThrowableRunnableWithProgress runnable = new CatchThrowableRunnableWithProgress();
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)runnable);
        }
        catch (Throwable e) {
            runnable.caught = e;
        }
        if (runnable.caught == null) {
            return runnable.status;
        }
        JptJaxbEclipseLinkUiPlugin.instance().logError(runnable.caught);
        ErrorDialog.openError((Shell)this.getShell(), (String)WTPCommonUIResourceHandler.getString((String)WTPCommonUIResourceHandler.WTPWizard_UI_0, (Object[])new Object[]{this.getWindowTitle()}), (String)WTPCommonUIResourceHandler.getString((String)WTPCommonUIResourceHandler.WTPWizard_UI_1, (Object[])new Object[]{this.getWindowTitle()}), (Throwable)runnable.caught, (int)0, (boolean)false);
        return JptJaxbEclipseLinkUiPlugin.instance().buildErrorStatus(runnable.caught);
    }

    protected void postPerformFinish() throws InvocationTargetException {
        try {
            IPath containerPath = (IPath)this.config.getProperty("JptFileCreationDataModelProperties.CONTAINER_PATH");
            String fileName = this.config.getStringProperty("JptFileCreationDataModelProperties.FILE_NAME");
            IContainer container = PathTools.getContainer((IPath)containerPath);
            IFile file = container.getFile((IPath)new Path(fileName));
            this.openEditor(file);
        }
        catch (Exception cantOpen) {
            throw new InvocationTargetException(cantOpen);
        }
    }

    private void openEditor(final IFile file) {
        if (file != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchPage page = WorkbenchTools.getActivePage();
                        if (page != null) {
                            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                        }
                    }
                    catch (PartInitException e) {
                        JptJaxbEclipseLinkUiPlugin.instance().logError(e);
                    }
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
        this.config.dispose();
    }
}

