/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.launch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.perf.PerfCore;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.SourceDisassemblyData;
import org.eclipse.linuxtools.internal.perf.StatData;
import org.eclipse.linuxtools.internal.perf.launch.Messages;
import org.eclipse.linuxtools.internal.perf.ui.SourceDisassemblyView;
import org.eclipse.linuxtools.internal.perf.ui.StatView;
import org.eclipse.linuxtools.profiling.launch.ConfigUtils;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteConnection;
import org.eclipse.linuxtools.profiling.launch.RemoteConnectionException;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class PerfLaunchConfigDelegate
extends AbstractCLaunchDelegate {
    private static final String OUTPUT_STR = "--output=";
    private static final String EMPTY_STRING = "";
    private IPath binPath;
    private IPath workingDirPath;
    private IProject project;

    protected String getPluginID() {
        return "org.eclipse.linuxtools.perf";
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block26: {
            try {
                ConfigUtils configUtils = new ConfigUtils(config);
                this.project = configUtils.getProject();
                PerfPlugin.getDefault().setProfiledProject(this.project);
                if (!PerfCore.checkPerfInPath(this.project)) {
                    Status status = new Status(4, "org.eclipse.linuxtools.perf", "Error: Perf was not found on PATH");
                    throw new CoreException((IStatus)status);
                }
                URI workingDirURI = new URI(config.getAttribute("REMOTE_WORKING_DIRECTORY_NAME", EMPTY_STRING));
                if (workingDirURI.toString().equals(EMPTY_STRING)) {
                    workingDirURI = this.getWorkingDirectory(config).toURI();
                    this.workingDirPath = Path.fromPortableString((String)workingDirURI.getPath());
                    this.binPath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
                } else {
                    this.workingDirPath = Path.fromPortableString((String)(String.valueOf(workingDirURI.getPath()) + '/'));
                    URI binURI = new URI(configUtils.getExecutablePath());
                    this.binPath = Path.fromPortableString((String)binURI.getPath().toString());
                }
                PerfPlugin.getDefault().setWorkingDir(this.workingDirPath);
                if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.ShowStat", false)) {
                    this.showStat(config, launch);
                    break block26;
                }
                String perfPathString = RuntimeProcessFactory.getFactory().whichCommand("perf", this.project);
                RemoteConnection workingDirRC = new RemoteConnection(workingDirURI);
                IRemoteFileProxy workingDirRFP = workingDirRC.getRmtFileProxy();
                IFileStore workingDir = workingDirRFP.getResource(workingDirURI.getPath());
                String[] arguments = this.getProgramArgumentsArray(config);
                ArrayList<String> command = new ArrayList<String>(4 + arguments.length);
                command.addAll(Arrays.asList(PerfCore.getRecordString(config)));
                command.add(this.binPath.toPortableString());
                command.set(0, perfPathString);
                command.add(2, "--output=perf.data");
                command.addAll(Arrays.asList(arguments));
                String[] commandArray = command.toArray(new String[command.size()]);
                Process pProxy = RuntimeProcessFactory.getFactory().exec(commandArray, this.getEnvironment(config), workingDir, this.project);
                MessageConsole console = new MessageConsole("Perf Console", null);
                console.activate();
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
                MessageConsoleStream stream = console.newMessageStream();
                if (pProxy != null) {
                    Throwable throwable = null;
                    Object var18_23 = null;
                    try (BufferedReader error = new BufferedReader(new InputStreamReader(pProxy.getErrorStream()));){
                        String err = error.readLine();
                        while (err != null) {
                            stream.println(err);
                            err = error.readLine();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                pProxy.destroy();
                PrintStream print = null;
                if (config.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", true)) {
                    ConsolePlugin plugin = ConsolePlugin.getDefault();
                    IConsoleManager conMan = plugin.getConsoleManager();
                    IConsole[] existing = conMan.getConsoles();
                    IOConsole binaryOutCons = null;
                    IConsole[] iConsoleArray = existing;
                    int n = existing.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConsole x = iConsoleArray[n2];
                        if (x.getName().contains(this.renderProcessLabel(commandArray[0]))) {
                            binaryOutCons = (IOConsole)x;
                        }
                        ++n2;
                    }
                    if (binaryOutCons == null && existing.length != 0 && existing[existing.length - 1] instanceof IOConsole) {
                        binaryOutCons = (IOConsole)existing[existing.length - 1];
                    }
                    if (binaryOutCons != null) {
                        IOConsoleOutputStream outputTo = binaryOutCons.newOutputStream();
                        print = new PrintStream((OutputStream)outputTo);
                    }
                    int i = 0;
                    while (i < command.size()) {
                        print.print(String.valueOf((String)command.get(i)) + " ");
                        ++i;
                    }
                    print.println();
                    print.println("Analysing recorded perf.data, please wait...");
                }
                PerfCore.report(config, this.workingDirPath, monitor, null, print);
                URI perfDataURI = null;
                IRemoteFileProxy proxy = null;
                perfDataURI = new URI(String.valueOf(workingDirURI.toString()) + '/' + "perf.data");
                proxy = RemoteProxyManager.getInstance().getFileProxy(perfDataURI);
                IFileStore perfDataFileStore = proxy.getResource(perfDataURI.getPath());
                IFileInfo info = perfDataFileStore.fetchInfo();
                info.setAttribute(2, true);
                perfDataFileStore.putInfo(info, 1024, null);
                PerfCore.refreshView(this.renderProcessLabel(this.binPath.toPortableString()));
                if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.ShowSourceDisassembly", false)) {
                    this.showSourceDisassembly(Path.fromPortableString((String)(String.valueOf(workingDirURI.toString()) + '/')));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.abort(e.getLocalizedMessage(), null, 150);
            }
            catch (RemoteConnectionException e) {
                e.printStackTrace();
                this.abort(e.getLocalizedMessage(), null, 150);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                this.abort(e.getLocalizedMessage(), null, 150);
            }
        }
    }

    private void showSourceDisassembly(IPath workingDir) {
        String title = this.renderProcessLabel(String.valueOf(workingDir.toPortableString()) + "perf.data");
        SourceDisassemblyData sdData = new SourceDisassemblyData(title, workingDir, this.project);
        sdData.parse();
        PerfPlugin.getDefault().setSourceDisassemblyData(sdData);
        SourceDisassemblyView.refreshView();
    }

    private void showStat(ILaunchConfiguration config, ILaunch launch) throws CoreException {
        String[] arguments = this.getProgramArgumentsArray(config);
        int runCount = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.StatRunCount", 1);
        StringBuilder args = new StringBuilder();
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            args.append(arg);
            args.append(" ");
            ++n2;
        }
        URI binURI = null;
        try {
            binURI = new URI(this.binPath.toPortableString());
        }
        catch (URISyntaxException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.MsgProxyError, (String)Messages.MsgProxyError);
        }
        String title = this.renderProcessLabel(MessageFormat.format(Messages.PerfLaunchConfigDelegate_stat_title, binURI.getPath(), args.toString(), String.valueOf(runCount)));
        List configEvents = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.SelectedEvents", PerfPlugin.ATTR_SelectedEvents_default);
        String[] statEvents = new String[]{};
        if (!config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", true)) {
            statEvents = configEvents == null ? statEvents : configEvents.toArray(new String[0]);
        }
        StatData sd = new StatData(title, this.workingDirPath, binURI.getPath(), arguments, runCount, statEvents, this.project);
        sd.setLaunch(launch);
        sd.parse();
        PerfPlugin.getDefault().setStatData(sd);
        sd.updateStatData();
        StatView.refreshView();
    }
}

