/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.localizer;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.services.localizer.IObjectLocalizer;

public abstract class AbstractObjectLocalizer
implements IObjectLocalizer {
    @Override
    public Map<EObject, EObject> getLocalEObjects(ResourceSet localSet, Iterable<? extends EObject> remoteObjects) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (EObject eObject : remoteObjects) {
            result.put((Object)eObject, (Object)this.getLocalEObject(localSet, eObject));
        }
        return result.build();
    }

    @Override
    public Map<Resource, Resource> getLocalResources(ResourceSet localSet, Iterable<? extends Resource> remoteResources) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Resource resource : remoteResources) {
            result.put((Object)resource, (Object)this.getLocalResource(localSet, resource));
        }
        return result.build();
    }

    protected ResourceSet getResourceSet(EObject object) {
        Resource resource = null;
        if (object instanceof Resource) {
            resource = (Resource)object;
        } else if (object != null) {
            resource = object.eResource();
        }
        return resource == null ? null : resource.getResourceSet();
    }
}

