/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.emf;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.scope.IEngineContext;
import org.eclipse.viatra.query.runtime.api.scope.IIndexingErrorListener;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.base.api.BaseIndexOptions;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;
import org.eclipse.viatra.query.runtime.emf.EMFBaseIndexWrapper;
import org.eclipse.viatra.query.runtime.emf.EMFEngineContext;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

public class EMFScope
extends QueryScope {
    private Set<? extends Notifier> scopeRoots;
    private BaseIndexOptions options;

    public EMFScope(Notifier scopeRoot) {
        this(Collections.singleton(scopeRoot), new BaseIndexOptions());
    }

    public EMFScope(Notifier scopeRoot, BaseIndexOptions options) {
        this(Collections.singleton(scopeRoot), options);
    }

    public EMFScope(Set<? extends ResourceSet> scopeRoots) {
        this(scopeRoots, new BaseIndexOptions());
    }

    public EMFScope(Set<? extends Notifier> scopeRoots, BaseIndexOptions options) {
        if (scopeRoots.isEmpty()) {
            throw new IllegalArgumentException("No scope roots given");
        }
        if (scopeRoots.size() == 1) {
            Predicate[] predicateArray = new Predicate[3];
            predicateArray[0] = EObject.class::isInstance;
            predicateArray[1] = Resource.class::isInstance;
            predicateArray[2] = ResourceSet.class::isInstance;
            this.checkScopeRoots(scopeRoots, predicateArray);
        } else {
            Predicate[] predicateArray = new Predicate[1];
            predicateArray[0] = ResourceSet.class::isInstance;
            this.checkScopeRoots(scopeRoots, predicateArray);
        }
        this.scopeRoots = new HashSet<Notifier>(scopeRoots);
        this.options = options.copy();
    }

    @SafeVarargs
    private final void checkScopeRoots(Set<? extends Notifier> scopeRoots, Predicate<Notifier> ... predicates) {
        for (Notifier notifier : scopeRoots) {
            Predicate compoundPredicate = Arrays.stream(predicates).collect(Collectors.reducing(a -> true, a -> a, (a, b) -> a.or(b)));
            if (compoundPredicate.test(notifier)) continue;
            throw new ViatraQueryException("Incremental EMF query engine can only be attached on the contents of an EMF EObject, Resource, ResourceSet or multiple ResourceSets. Received instead: " + (notifier == null ? "(null)" : notifier.getClass().getName()), "Invalid EMF model root");
        }
    }

    public Set<? extends Notifier> getScopeRoots() {
        return this.scopeRoots;
    }

    public BaseIndexOptions getOptions() {
        return this.options.copy();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.options == null ? 0 : this.options.hashCode());
        result = 31 * result + (this.scopeRoots == null ? 0 : this.scopeRoots.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EMFScope)) {
            return false;
        }
        EMFScope other = (EMFScope)obj;
        if (this.options == null ? other.options != null : !this.options.equals((Object)other.options)) {
            return false;
        }
        return !(this.scopeRoots == null ? other.scopeRoots != null : !this.scopeRoots.equals(other.scopeRoots));
    }

    public String toString() {
        return String.format("EMFScope(%s):%s", this.options, this.scopeRoots.stream().map(notifier -> this.scopeRootString((Notifier)notifier)).collect(Collectors.joining(",")));
    }

    private String scopeRootString(Notifier notifier) {
        if (notifier instanceof Resource) {
            Resource resource = (Resource)notifier;
            return String.format("%s(%s)", resource.getClass(), resource.getURI());
        }
        if (notifier instanceof ResourceSet) {
            ResourceSet resourceSet = (ResourceSet)notifier;
            return resourceSet.getResources().stream().map(Resource::getURI).map(Object::toString).collect(Collectors.joining(", ", resourceSet.getClass() + "(", ")"));
        }
        return notifier.toString();
    }

    @Override
    protected IEngineContext createEngineContext(ViatraQueryEngine engine, IIndexingErrorListener errorListener, Logger logger) {
        return new EMFEngineContext(this, engine, errorListener, logger);
    }

    public static NavigationHelper extractUnderlyingEMFIndex(ViatraQueryEngine engine) {
        QueryScope scope = engine.getScope();
        if (scope instanceof EMFScope) {
            return ((EMFBaseIndexWrapper)AdvancedViatraQueryEngine.from(engine).getBaseIndex()).getNavigationHelper();
        }
        throw new IllegalArgumentException("Cannot extract EMF base index from VIATRA Query engine instantiated on non-EMF scope " + scope);
    }
}

