/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.internal.apiimpl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IMatchUpdateListener;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQueryGroup;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineLifecycleListener;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineManager;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineOptions;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.api.ViatraQueryModelUpdateListener;
import org.eclipse.viatra.query.runtime.api.impl.BaseMatcher;
import org.eclipse.viatra.query.runtime.api.scope.IBaseIndex;
import org.eclipse.viatra.query.runtime.api.scope.IEngineContext;
import org.eclipse.viatra.query.runtime.api.scope.IIndexingErrorListener;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.internal.apiimpl.QueryResultWrapper;
import org.eclipse.viatra.query.runtime.internal.engine.LifecycleProvider;
import org.eclipse.viatra.query.runtime.internal.engine.ModelUpdateProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.IMatcherCapability;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackend;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendHintProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.IUpdateable;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryBackendContext;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryCacheContext;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryResultProviderAccess;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.psystem.analysis.QueryAnalyzer;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQueries;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQueryHeader;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.query.runtime.registry.IDefaultRegistryView;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.QuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

public final class ViatraQueryEngineImpl
extends AdvancedViatraQueryEngine
implements IQueryBackendHintProvider,
IQueryCacheContext,
IQueryResultProviderAccess {
    private static final String ERROR_ACCESSING_BACKEND = "Error while accessing query evaluator backend";
    private static final String QUERY_ON_DISPOSED_ENGINE_MESSAGE = "Cannot evaluate query on disposed engine!";
    private final ViatraQueryEngineManager manager;
    private final QueryScope scope;
    private IEngineContext engineContext;
    private final Multimap<IQuerySpecification<? extends ViatraQueryMatcher<?>>, ViatraQueryMatcher<?>> matchers = ArrayListMultimap.create();
    private volatile Map<IQueryBackendFactory, IQueryBackend> queryBackends = new HashMap<IQueryBackendFactory, IQueryBackend>();
    private final ViatraQueryEngineOptions engineOptions;
    private QueryAnalyzer queryAnalyzer;
    private boolean delayMessageDelivery = false;
    private final LifecycleProvider lifecycleProvider;
    private final ModelUpdateProvider modelUpdateProvider;
    private Logger logger;
    private boolean disposed = false;
    private boolean tainted = false;
    private IIndexingErrorListener taintListener = new SelfTaintListener(this);

    public ViatraQueryEngineImpl(ViatraQueryEngineManager manager, QueryScope scope, ViatraQueryEngineOptions engineOptions) {
        this.manager = manager;
        this.scope = scope;
        this.lifecycleProvider = new LifecycleProvider(this, this.getLogger());
        this.modelUpdateProvider = new ModelUpdateProvider(this, this.getLogger());
        this.engineContext = scope.createEngineContext(this, this.taintListener, this.getLogger());
        this.engineOptions = engineOptions != null ? engineOptions : ViatraQueryEngineOptions.getDefault();
    }

    public ViatraQueryEngineImpl(ViatraQueryEngineManager manager, QueryScope scope) {
        this(manager, scope, ViatraQueryEngineOptions.getDefault());
    }

    @Override
    public boolean isUpdatePropagationDelayed() {
        return this.delayMessageDelivery;
    }

    @Override
    public <V> V delayUpdatePropagation(Callable<V> callable) throws InvocationTargetException {
        boolean wasAlreadyDelayed = this.delayMessageDelivery;
        V result = null;
        if (!wasAlreadyDelayed) {
            this.delayMessageDelivery = true;
        }
        try {
            result = callable.call();
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
        if (!wasAlreadyDelayed) {
            this.delayMessageDelivery = false;
            for (IQueryBackend backend : this.queryBackends.values()) {
                backend.flushUpdates();
            }
        }
        return result;
    }

    @Override
    public Set<? extends ViatraQueryMatcher<? extends IPatternMatch>> getCurrentMatchers() {
        return new HashSet(this.matchers.values());
    }

    @Override
    public <Matcher extends ViatraQueryMatcher<? extends IPatternMatch>> Matcher getMatcher(IQuerySpecification<Matcher> querySpecification) {
        return this.getMatcher(querySpecification, null);
    }

    @Override
    public <Matcher extends ViatraQueryMatcher<? extends IPatternMatch>> Matcher getMatcher(IQuerySpecification<Matcher> querySpecification, QueryEvaluationHint optionalEvaluationHints) {
        IMatcherCapability capability = this.getRequestedCapability(querySpecification, optionalEvaluationHints);
        Matcher matcher = this.doGetExistingMatcher(querySpecification, capability);
        if (matcher != null) {
            return matcher;
        }
        matcher = querySpecification.instantiate();
        BaseMatcher baseMatcher = (BaseMatcher)matcher;
        ((QueryResultWrapper)baseMatcher).setBackend(this, this.getResultProvider(querySpecification, optionalEvaluationHints), capability);
        this.internalRegisterMatcher(querySpecification, baseMatcher);
        return matcher;
    }

    @Override
    public <Matcher extends ViatraQueryMatcher<? extends IPatternMatch>> Matcher getExistingMatcher(IQuerySpecification<Matcher> querySpecification) {
        return this.getExistingMatcher(querySpecification, null);
    }

    @Override
    public <Matcher extends ViatraQueryMatcher<? extends IPatternMatch>> Matcher getExistingMatcher(IQuerySpecification<Matcher> querySpecification, QueryEvaluationHint optionalOverrideHints) {
        return this.doGetExistingMatcher(querySpecification, this.getRequestedCapability(querySpecification, optionalOverrideHints));
    }

    private <Matcher extends ViatraQueryMatcher<? extends IPatternMatch>> Matcher doGetExistingMatcher(IQuerySpecification<Matcher> querySpecification, IMatcherCapability requestedCapability) {
        for (ViatraQueryMatcher matcher : this.matchers.get(querySpecification)) {
            BaseMatcher baseMatcher = (BaseMatcher)matcher;
            if (!baseMatcher.getCapabilities().canBeSubstitute(requestedCapability)) continue;
            return (Matcher)matcher;
        }
        return null;
    }

    @Override
    public ViatraQueryMatcher<? extends IPatternMatch> getMatcher(String patternFQN) {
        IQuerySpecificationRegistry registry = QuerySpecificationRegistry.getInstance();
        IDefaultRegistryView view = registry.getDefaultView();
        IQuerySpecification querySpecification = (IQuerySpecification)view.getEntry(patternFQN).get();
        if (querySpecification != null) {
            return this.getMatcher(querySpecification);
        }
        throw new ViatraQueryException(String.format("No matcher could be constructed for the pattern with FQN %s; if the generated matcher class is not available, please access for the first time using getMatcher(IQuerySpecification)", patternFQN), "No matcher could be constructed for given pattern FQN.");
    }

    @Override
    public IBaseIndex getBaseIndex() {
        return this.engineContext.getBaseIndex();
    }

    public final Logger getLogger() {
        if (this.logger == null) {
            int hash = System.identityHashCode(this);
            this.logger = Logger.getLogger((String)(String.valueOf(ViatraQueryLoggingUtil.getLogger(ViatraQueryEngine.class).getName()) + "." + hash));
            if (this.logger == null) {
                throw new AssertionError((Object)("Configuration error: unable to create VIATRA Query runtime logger for engine " + hash));
            }
        }
        return this.logger;
    }

    private void internalRegisterMatcher(IQuerySpecification<?> querySpecification, ViatraQueryMatcher<?> matcher) {
        this.matchers.put(querySpecification, matcher);
        this.lifecycleProvider.matcherInstantiated(matcher);
    }

    @Override
    public IQueryBackend getQueryBackend(IQueryBackendFactory iQueryBackendFactory) {
        IQueryBackend iQueryBackend = this.queryBackends.get(iQueryBackendFactory);
        if (iQueryBackend == null) {
            final IQueryRuntimeContext queryRuntimeContext = this.engineContext.getQueryRuntimeContext();
            iQueryBackend = this.queryBackends.get(iQueryBackendFactory);
            if (iQueryBackend == null) {
                iQueryBackend = iQueryBackendFactory.create(new IQueryBackendContext(){

                    public IQueryRuntimeContext getRuntimeContext() {
                        return queryRuntimeContext;
                    }

                    public IQueryCacheContext getQueryCacheContext() {
                        return ViatraQueryEngineImpl.this;
                    }

                    public Logger getLogger() {
                        return ViatraQueryEngineImpl.this.logger;
                    }

                    public IQueryBackendHintProvider getHintProvider() {
                        return ViatraQueryEngineImpl.this;
                    }

                    public IQueryResultProviderAccess getResultProviderAccess() {
                        return ViatraQueryEngineImpl.this;
                    }

                    public QueryAnalyzer getQueryAnalyzer() {
                        if (ViatraQueryEngineImpl.this.queryAnalyzer == null) {
                            ViatraQueryEngineImpl.this.queryAnalyzer = new QueryAnalyzer(queryRuntimeContext.getMetaContext());
                        }
                        return ViatraQueryEngineImpl.this.queryAnalyzer;
                    }

                    public boolean areUpdatesDelayed() {
                        return ViatraQueryEngineImpl.this.delayMessageDelivery;
                    }

                    public IMatcherCapability getRequiredMatcherCapability(PQuery query, QueryEvaluationHint hint) {
                        return ViatraQueryEngineImpl.this.engineOptions.getQueryBackendFactory(hint).calculateRequiredCapability(query, hint);
                    }
                });
                this.queryBackends.put(iQueryBackendFactory, iQueryBackend);
            }
        }
        return iQueryBackend;
    }

    @Override
    public void dispose() {
        if (this.manager != null) {
            throw new UnsupportedOperationException(String.format("Cannot dispose() managed VIATRA Query Engine. Attempted for scope %s.", this.scope));
        }
        this.wipe();
        this.disposed = true;
        this.lifecycleProvider.engineDisposed();
        try {
            this.engineContext.dispose();
        }
        catch (IllegalStateException ex) {
            this.getLogger().warn((Object)"The base index could not be disposed along with the VIATRA Query engine, as there are still active listeners on it.");
        }
    }

    @Override
    public void wipe() {
        if (this.manager != null) {
            throw new UnsupportedOperationException(String.format("Cannot wipe() managed VIATRA Query Engine. Attempted for scope %s.", this.scope));
        }
        if (this.queryBackends != null) {
            for (IQueryBackend backend : this.queryBackends.values()) {
                backend.dispose();
            }
            this.queryBackends.clear();
        }
        this.matchers.clear();
        this.queryAnalyzer = null;
        this.lifecycleProvider.engineWiped();
    }

    @Override
    public boolean isTainted() {
        return this.tainted;
    }

    @Override
    public boolean isManaged() {
        return this.manager != null;
    }

    private <Match extends IPatternMatch> IQueryResultProvider getUnderlyingResultProvider(BaseMatcher<Match> matcher) {
        return matcher.backend;
    }

    @Override
    public <Match extends IPatternMatch> void addMatchUpdateListener(ViatraQueryMatcher<Match> matcher, IMatchUpdateListener<? super Match> listener, boolean fireNow) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (String)"Cannot add null listener!");
        Preconditions.checkArgument((matcher.getEngine() == this ? 1 : 0) != 0, (String)"Cannot register listener for matcher of different engine!");
        Preconditions.checkArgument((!this.disposed ? 1 : 0) != 0, (String)"Cannot register listener on matcher of disposed engine!");
        BaseMatcher bm = (BaseMatcher)matcher;
        IUpdateable updateDispatcher = (updateElement, isInsertion) -> {
            IPatternMatch match = null;
            try {
                match = (IPatternMatch)bm.newMatch(updateElement.getElements());
                if (isInsertion) {
                    listener.notifyAppearance(match);
                } else {
                    listener.notifyDisappearance(match);
                }
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                this.logger.warn((Object)String.format("The incremental pattern matcher encountered an error during %s a callback on %s of match %s of pattern %s. Error message: %s. (Developer note: %s in %s callback)", match == null ? "preparing" : "invoking", isInsertion ? "insertion" : "removal", match == null ? updateElement.toString() : match.prettyPrint(), matcher.getPatternName(), e.getMessage(), e.getClass().getSimpleName(), listener), e);
            }
        };
        IQueryResultProvider resultProvider = this.getUnderlyingResultProvider(bm);
        resultProvider.addUpdateListener(updateDispatcher, listener, fireNow);
    }

    @Override
    public <Match extends IPatternMatch> void removeMatchUpdateListener(ViatraQueryMatcher<Match> matcher, IMatchUpdateListener<? super Match> listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (String)"Cannot remove null listener!");
        Preconditions.checkArgument((matcher.getEngine() == this ? 1 : 0) != 0, (String)"Cannot remove listener from matcher of different engine!");
        Preconditions.checkArgument((!this.disposed ? 1 : 0) != 0, (String)"Cannot remove listener from matcher of disposed engine!");
        BaseMatcher bm = (BaseMatcher)matcher;
        try {
            IQueryResultProvider resultProvider = this.getUnderlyingResultProvider(bm);
            resultProvider.removeUpdateListener(listener);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error while removing listener " + listener + " from the matcher of " + matcher.getPatternName()), (Throwable)e);
        }
    }

    @Override
    public void addModelUpdateListener(ViatraQueryModelUpdateListener listener) {
        this.modelUpdateProvider.addListener(listener);
    }

    @Override
    public void removeModelUpdateListener(ViatraQueryModelUpdateListener listener) {
        this.modelUpdateProvider.removeListener(listener);
    }

    @Override
    public void addLifecycleListener(ViatraQueryEngineLifecycleListener listener) {
        this.lifecycleProvider.addListener(listener);
    }

    @Override
    public void removeLifecycleListener(ViatraQueryEngineLifecycleListener listener) {
        this.lifecycleProvider.removeListener(listener);
    }

    public IQueryResultProvider getResultProvider(IQuerySpecification<?> query) {
        Preconditions.checkState((!this.disposed ? 1 : 0) != 0, (String)QUERY_ON_DISPOSED_ENGINE_MESSAGE);
        return this.getResultProviderInternal(query, null);
    }

    public IQueryResultProvider getResultProvider(IQuerySpecification<?> query, QueryEvaluationHint hint) {
        Preconditions.checkState((!this.disposed ? 1 : 0) != 0, (String)QUERY_ON_DISPOSED_ENGINE_MESSAGE);
        return this.getResultProviderInternal(query, hint);
    }

    private IQueryResultProvider getResultProviderInternal(IQuerySpecification<?> query, QueryEvaluationHint hint) {
        return this.getResultProviderInternal(query.getInternalQueryRepresentation(), hint);
    }

    private IQueryResultProvider getResultProviderInternal(PQuery query, QueryEvaluationHint hint) {
        Preconditions.checkArgument((query != null ? 1 : 0) != 0, (String)"Query cannot be null!");
        Preconditions.checkArgument((query.getStatus() != PQuery.PQueryStatus.ERROR ? 1 : 0) != 0, (String)"Cannot initialize a result provider for the erronoues query `%s`.", (Object[])new Object[]{query.getSimpleName()});
        IQueryBackend backend = this.getQueryBackend(this.engineOptions.getQueryBackendFactory(this.getQueryEvaluationHint(query, hint)));
        return backend.getResultProvider(query, hint);
    }

    private IQueryBackend getQueryBackend(PQuery query) {
        IQueryBackendFactory factory = this.engineOptions.getQueryBackendFactory(this.getQueryEvaluationHint(query));
        return this.getQueryBackend(factory);
    }

    private IQueryBackend getCachingQueryBackend(PQuery query) {
        IQueryBackend regularBackend = this.getQueryBackend(query);
        if (regularBackend.isCaching()) {
            return regularBackend;
        }
        return this.getQueryBackend(this.engineOptions.getDefaultCachingBackendFactory());
    }

    public boolean isResultCached(PQuery query) {
        try {
            return this.getCachingQueryBackend(query).peekExistingResultProvider(query) != null;
        }
        catch (ViatraQueryException iqe) {
            this.getLogger().error((Object)ERROR_ACCESSING_BACKEND, (Throwable)((Object)iqe));
            return false;
        }
    }

    public IQueryResultProvider getCachingResultProvider(PQuery query) {
        try {
            return this.getCachingQueryBackend(query).getResultProvider(query);
        }
        catch (ViatraQueryException iqe) {
            this.getLogger().error((Object)ERROR_ACCESSING_BACKEND, (Throwable)((Object)iqe));
            throw iqe;
        }
    }

    private QueryEvaluationHint getEngineDefaultHint() {
        return this.engineOptions.getEngineDefaultHints();
    }

    public QueryEvaluationHint getQueryEvaluationHint(PQuery query) {
        return this.getEngineDefaultHint().overrideBy(query.getEvaluationHints());
    }

    private QueryEvaluationHint getQueryEvaluationHint(IQuerySpecification<?> querySpecification, QueryEvaluationHint optionalOverrideHints) {
        return this.getQueryEvaluationHint(querySpecification.getInternalQueryRepresentation()).overrideBy(optionalOverrideHints);
    }

    private QueryEvaluationHint getQueryEvaluationHint(PQuery query, QueryEvaluationHint optionalOverrideHints) {
        return this.getQueryEvaluationHint(query).overrideBy(optionalOverrideHints);
    }

    private IMatcherCapability getRequestedCapability(IQuerySpecification<?> querySpecification, QueryEvaluationHint optionalOverrideHints) {
        QueryEvaluationHint hint = this.getQueryEvaluationHint(querySpecification, optionalOverrideHints);
        return this.engineOptions.getQueryBackendFactory(hint).calculateRequiredCapability(querySpecification.getInternalQueryRepresentation(), hint);
    }

    @Override
    public void prepareGroup(IQueryGroup queryGroup, final QueryEvaluationHint optionalEvaluationHints) {
        try {
            Preconditions.checkState((!this.disposed ? 1 : 0) != 0, (String)QUERY_ON_DISPOSED_ENGINE_MESSAGE);
            final HashSet specifications = new HashSet(queryGroup.getSpecifications());
            Collection patterns = specifications.stream().map(IQuerySpecification::getInternalQueryRepresentation).collect(Collectors.toList());
            patterns.forEach(PQuery::ensureInitialized);
            Collection erroneousPatterns = patterns.stream().filter(PQueries.queryStatusPredicate((PQuery.PQueryStatus)PQuery.PQueryStatus.ERROR)).map(PQueryHeader::getFullyQualifiedName).collect(Collectors.toList());
            Preconditions.checkState((boolean)erroneousPatterns.isEmpty(), (String)"Erroneous query(s) found: %s", (Object[])new Object[]{erroneousPatterns.stream().collect(Collectors.joining(", "))});
            try {
                this.engineContext.getBaseIndex().coalesceTraversals(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        for (IQuerySpecification query : specifications) {
                            ViatraQueryEngineImpl.this.getResultProviderInternal(query, optionalEvaluationHints);
                        }
                        return null;
                    }
                });
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof QueryProcessingException) {
                    throw (QueryProcessingException)cause;
                }
                if (cause instanceof ViatraQueryException) {
                    throw (ViatraQueryException)((Object)cause);
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                assert (false);
            }
        }
        catch (QueryProcessingException e) {
            throw new ViatraQueryException(e);
        }
    }

    @Override
    public QueryScope getScope() {
        return this.scope;
    }

    @Override
    public ViatraQueryEngineOptions getEngineOptions() {
        return this.engineOptions;
    }

    @Override
    public IQueryResultProvider getResultProviderOfMatcher(ViatraQueryMatcher<? extends IPatternMatch> matcher) {
        return ((QueryResultWrapper)((Object)matcher)).backend;
    }

    public IQueryResultProvider getResultProvider(PQuery query, QueryEvaluationHint overrideHints) {
        try {
            return this.getResultProviderInternal(query, overrideHints);
        }
        catch (ViatraQueryException e) {
            this.getLogger().error((Object)ERROR_ACCESSING_BACKEND, (Throwable)((Object)e));
            throw e;
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    private static class SelfTaintListener
    implements IIndexingErrorListener {
        WeakReference<ViatraQueryEngineImpl> queryEngineRef;
        private boolean noTaintDetectedYet = true;

        public SelfTaintListener(ViatraQueryEngineImpl queryEngine) {
            this.queryEngineRef = new WeakReference<ViatraQueryEngineImpl>(queryEngine);
        }

        public void engineBecameTainted(String description, Throwable t) {
            ViatraQueryEngineImpl queryEngine = (ViatraQueryEngineImpl)this.queryEngineRef.get();
            if (queryEngine != null) {
                queryEngine.tainted = true;
                queryEngine.lifecycleProvider.engineBecameTainted(description, t);
            }
        }

        protected void notifyTainted(String description, Throwable t) {
            if (this.noTaintDetectedYet) {
                this.noTaintDetectedYet = false;
                this.engineBecameTainted(description, t);
            }
        }

        @Override
        public void error(String description, Throwable t) {
        }

        @Override
        public void fatal(String description, Throwable t) {
            this.notifyTainted(description, t);
        }
    }
}

