/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.creation.factory;

import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.ExecutionFlowUtils;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.AbstractExplicitFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryInfo;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.state.EditorState;

public final class InstanceFactoryCreationSupport
extends AbstractExplicitFactoryCreationSupport {
    private final InstanceFactoryInfo m_factory;

    public InstanceFactoryCreationSupport(InstanceFactoryInfo factory, FactoryMethodDescription description) {
        super(description);
        this.m_factory = factory;
    }

    public InstanceFactoryCreationSupport(InstanceFactoryInfo factory, FactoryMethodDescription description, MethodInvocation invocation) {
        super(description, invocation);
        this.m_factory = factory;
    }

    public String toString() {
        return "instance factory: {" + this.m_factory.getVariableSupport().toString() + "}" + " " + this.m_description.getSignature();
    }

    public InstanceFactoryInfo getFactory() {
        return this.m_factory;
    }

    public CreationSupport getLiveComponentCreation() {
        FactoryMethodDescription factoryMethodDescription = this.getDescription();
        return new LiveCreationSupport(factoryMethodDescription);
    }

    protected String add_getSource_invocationExpression(NodeTarget target) throws Exception {
        return String.valueOf(TemplateUtils.getExpression(this.m_factory)) + ".";
    }

    public IClipboardCreationSupport getClipboard() throws Exception {
        final String factoryClassName = this.m_description.getDeclaringClass().getName();
        final String methodSignature = this.m_description.getSignature();
        final String argumentsSource = this.getClipboardArguments();
        return new IClipboardCreationSupport(){
            private static final long serialVersionUID = 0L;

            @Override
            public CreationSupport create(JavaInfo rootObject) throws Exception {
                AstEditor editor = rootObject.getEditor();
                Class<?> factoryClass = EditorState.get(editor).getEditorLoader().loadClass(factoryClassName);
                InstanceFactoryInfo factoryInfo = this.getFactory(rootObject, factoryClass);
                FactoryMethodDescription description = FactoryDescriptionHelper.getDescription(editor, factoryClass, methodSignature, false);
                InstanceFactoryCreationSupport creationSupport = new InstanceFactoryCreationSupport(factoryInfo, description);
                creationSupport.m_addArguments = argumentsSource;
                return creationSupport;
            }

            private InstanceFactoryInfo getFactory(JavaInfo rootObject, Class<?> factoryClass) throws Exception {
                List<InstanceFactoryInfo> factories = InstanceFactoryInfo.getFactories(rootObject, factoryClass);
                if (factories.size() == 1) {
                    return factories.get(0);
                }
                Assert.isTrue((boolean)factories.isEmpty(), (String)("Only single and no instance factories expected for " + factoryClassName + "." + methodSignature + ", but found " + factories));
                return InstanceFactoryInfo.add(rootObject, factoryClass);
            }
        };
    }

    private final class LiveCreationSupport
    extends AbstractExplicitFactoryCreationSupport {
        private final String m_factoryTypeName;
        private boolean m_canBeEvaluated;

        private LiveCreationSupport(FactoryMethodDescription description) {
            super(description);
            this.m_canBeEvaluated = false;
            this.m_factoryTypeName = InstanceFactoryCreationSupport.this.m_factory.getDescription().getComponentClass().getName();
        }

        public boolean canBeEvaluated() {
            if (!this.m_canBeEvaluated) {
                this.m_canBeEvaluated = true;
                return false;
            }
            return true;
        }

        public Object create(EvaluationContext context, ExecutionFlowUtils.ExecutionFlowFrameVisitor visitor) throws Exception {
            IExpressionEvaluator evaluator = new IExpressionEvaluator(){

                public Object evaluate(EvaluationContext _context, Expression expression, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
                    CastExpression castExpression;
                    String typeName;
                    if (expression instanceof CastExpression && (typeName = AstNodeUtils.getFullyQualifiedName((castExpression = (CastExpression)expression).getType(), false)).equals(LiveCreationSupport.this.m_factoryTypeName) && castExpression.getExpression() instanceof NullLiteral) {
                        return InstanceFactoryCreationSupport.this.m_factory.getObject();
                    }
                    return AstEvaluationEngine.UNKNOWN;
                }
            };
            context.addEvaluator(evaluator);
            try {
                Object object = AstEvaluationEngine.evaluate(context, (Expression)this.m_invocation);
                return object;
            }
            finally {
                context.removeEvaluator(evaluator);
            }
        }

        protected String add_getSource_invocationExpression(NodeTarget target) throws Exception {
            return "((" + this.m_factoryTypeName + ") null).";
        }

        public CreationSupport getLiveComponentCreation() {
            throw new NotImplementedException();
        }
    }
}

