(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "../parser/htmlScanner", "vscode-languageserver-types", "./tagProviders", "../htmlLanguageTypes"], factory);
    }
})(function (require, exports) {
    /*---------------------------------------------------------------------------------------------
     *  Copyright (c) Microsoft Corporation. All rights reserved.
     *  Licensed under the MIT License. See License.txt in the project root for license information.
     *--------------------------------------------------------------------------------------------*/
    'use strict';
    Object.defineProperty(exports, "__esModule", { value: true });
    var htmlScanner_1 = require("../parser/htmlScanner");
    var vscode_languageserver_types_1 = require("vscode-languageserver-types");
    var tagProviders_1 = require("./tagProviders");
    var htmlLanguageTypes_1 = require("../htmlLanguageTypes");
    function doHover(document, position, htmlDocument) {
        var offset = document.offsetAt(position);
        var node = htmlDocument.findNodeAt(offset);
        if (!node || !node.tag) {
            return null;
        }
        var tagProviders = tagProviders_1.allTagProviders.filter(function (p) { return p.isApplicable(document.languageId); });
        function getTagHover(tag, range, open) {
            tag = tag.toLowerCase();
            var _loop_1 = function (provider) {
                var hover = null;
                provider.collectTags(function (t, label) {
                    if (t === tag) {
                        var tagLabel = open ? '<' + tag + '>' : '</' + tag + '>';
                        hover = { contents: [{ language: 'html', value: tagLabel }, vscode_languageserver_types_1.MarkedString.fromPlainText(label)], range: range };
                    }
                });
                if (hover) {
                    return { value: hover };
                }
            };
            for (var _i = 0, tagProviders_2 = tagProviders; _i < tagProviders_2.length; _i++) {
                var provider = tagProviders_2[_i];
                var state_1 = _loop_1(provider);
                if (typeof state_1 === "object")
                    return state_1.value;
            }
            return null;
        }
        function getTagNameRange(tokenType, startOffset) {
            var scanner = htmlScanner_1.createScanner(document.getText(), startOffset);
            var token = scanner.scan();
            while (token !== htmlLanguageTypes_1.TokenType.EOS && (scanner.getTokenEnd() < offset || scanner.getTokenEnd() === offset && token !== tokenType)) {
                token = scanner.scan();
            }
            if (token === tokenType && offset <= scanner.getTokenEnd()) {
                return { start: document.positionAt(scanner.getTokenOffset()), end: document.positionAt(scanner.getTokenEnd()) };
            }
            return null;
        }
        if (node.endTagStart && offset >= node.endTagStart) {
            var tagRange_1 = getTagNameRange(htmlLanguageTypes_1.TokenType.EndTag, node.endTagStart);
            if (tagRange_1) {
                return getTagHover(node.tag, tagRange_1, false);
            }
            return null;
        }
        var tagRange = getTagNameRange(htmlLanguageTypes_1.TokenType.StartTag, node.start);
        if (tagRange) {
            return getTagHover(node.tag, tagRange, true);
        }
        return null;
    }
    exports.doHover = doHover;
});
//# sourceMappingURL=htmlHover.js.map