/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.xtend.typesystem.xsd.util.XSDLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessControlURIConverter
implements URIConverter {
    private URIConverter delegate;
    private Set<String> denySchemes = null;
    private static Log log = XSDLog.getLog(AccessControlURIConverter.class);
    private Pattern denyRegex = null;

    public AccessControlURIConverter() {
        this((URIConverter)new ExtensibleURIConverterImpl());
    }

    public AccessControlURIConverter(URIConverter delegate) {
        this.delegate = delegate;
    }

    protected void checkAccess(URI uri) throws AccessDeniedException {
        if (!this.mayAccess(uri)) {
            throw new AccessDeniedException("Access denied to " + uri);
        }
    }

    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        this.checkAccess(uri);
        return this.delegate.contentDescription(uri, options);
    }

    public InputStream createInputStream(URI uri) throws IOException {
        this.checkAccess(uri);
        return this.delegate.createInputStream(uri);
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        this.checkAccess(uri);
        return this.delegate.createInputStream(uri, options);
    }

    public OutputStream createOutputStream(URI uri) throws IOException {
        this.checkAccess(uri);
        return this.delegate.createOutputStream(uri);
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        this.checkAccess(uri);
        return this.delegate.createOutputStream(uri, options);
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        this.checkAccess(uri);
        this.delegate.delete(uri, options);
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        return this.mayAccess(uri) && this.delegate.exists(uri, options);
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        if (!this.mayAccess(uri)) {
            return Collections.emptyMap();
        }
        return this.delegate.getAttributes(uri, options);
    }

    public EList<ContentHandler> getContentHandlers() {
        return this.delegate.getContentHandlers();
    }

    public URIHandler getURIHandler(URI uri) {
        return this.delegate.getURIHandler(uri);
    }

    public EList<URIHandler> getURIHandlers() {
        return this.delegate.getURIHandlers();
    }

    public Map<URI, URI> getURIMap() {
        return this.delegate.getURIMap();
    }

    protected boolean mayAccess(URI uri) {
        boolean r = this.mayAccessInternal(uri);
        if (log.isInfoEnabled()) {
            log.info((Object)("Accessing '" + uri + "' -> " + (r ? "granted" : "denied")));
        }
        return r;
    }

    protected boolean mayAccessInternal(URI uri) {
        if (this.denySchemes != null && uri.scheme() != null && this.denySchemes.contains(uri.scheme().toLowerCase())) {
            return false;
        }
        return this.denyRegex == null || !this.denyRegex.matcher(uri.toString()).matches();
    }

    public URI normalize(URI uri) {
        return this.delegate.normalize(uri);
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        if (this.mayAccess(uri)) {
            this.delegate.setAttributes(uri, attributes, options);
        }
    }

    public void setDenyRegex(String regex) {
        this.denyRegex = Pattern.compile(regex);
    }

    public void setDenySchemes(String[] schemes) {
        this.denySchemes = new HashSet<String>();
        String[] stringArray = schemes;
        int n = schemes.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.denySchemes.add(s.trim().toLowerCase());
            ++n2;
        }
    }

    public static class AccessDeniedException
    extends IOException {
        private static final long serialVersionUID = -5476458803177882220L;

        public AccessDeniedException() {
        }

        public AccessDeniedException(String s) {
            super(s);
        }
    }
}

