/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.debug.internal.script.model;

import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

/**
 * ScriptStackFrame
 */
public class ScriptStackFrame extends ScriptDebugElement implements IStackFrame
{
	private int id;
	private ScriptDebugThread thread;
	private String name;
	private int lineNumber = 1;

	/**Constructor
	 * @param thread
	 * @param name
	 * @param id
	 */
	public ScriptStackFrame( ScriptDebugThread thread, String name, int id )
	{
		super( (ScriptDebugTarget) thread.getDebugTarget( ) );
		this.id = id;
		this.thread = thread;
		this.name = name;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStackFrame#getCharEnd()
	 */
	public int getCharEnd( ) throws DebugException
	{
		return -1;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStackFrame#getCharStart()
	 */
	public int getCharStart( ) throws DebugException
	{
		return -1;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStackFrame#getLineNumber()
	 */
	public int getLineNumber( ) throws DebugException
	{
		return lineNumber;
	}

	/**Sets the line number
	 * @param line
	 */
	public void setLineNumber( int line )
	{
		this.lineNumber = line;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStackFrame#getName()
	 */
	public String getName( ) throws DebugException
	{
		return getId( ) + "()" + "line: " + getLineNumber( ); //$NON-NLS-1$ //$NON-NLS-2$
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStackFrame#getRegisterGroups()
	 */
	public IRegisterGroup[] getRegisterGroups( ) throws DebugException
	{
		return new IRegisterGroup[0];
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStackFrame#getThread()
	 */
	public IThread getThread( )
	{
		return thread;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStackFrame#getVariables()
	 */
	public IVariable[] getVariables( ) throws DebugException
	{
		return ( (ScriptDebugTarget) getDebugTarget( ) ).getVariables( this );
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStackFrame#hasRegisterGroups()
	 */
	public boolean hasRegisterGroups( ) throws DebugException
	{
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStackFrame#hasVariables()
	 */
	public boolean hasVariables( ) throws DebugException
	{
		return getVariables( ).length > 0;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStep#canStepInto()
	 */
	public boolean canStepInto( )
	{
		return getThread( ).canStepInto( );
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStep#canStepOver()
	 */
	public boolean canStepOver( )
	{
		return getThread( ).canStepOver( );
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStep#canStepReturn()
	 */
	public boolean canStepReturn( )
	{
		return getThread( ).canStepReturn( );
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStep#isStepping()
	 */
	public boolean isStepping( )
	{
		return getThread( ).isStepping( );
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStep#stepInto()
	 */
	public void stepInto( ) throws DebugException
	{
		getThread( ).stepInto( );
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStep#stepOver()
	 */
	public void stepOver( ) throws DebugException
	{
		getThread( ).stepOver( );

	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStep#stepReturn()
	 */
	public void stepReturn( ) throws DebugException
	{
		getThread( ).stepReturn( );
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.ISuspendResume#canResume()
	 */
	public boolean canResume( )
	{
		return getThread( ).canResume( );
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.ISuspendResume#canSuspend()
	 */
	public boolean canSuspend( )
	{
		return getThread( ).canSuspend( );
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.ISuspendResume#isSuspended()
	 */
	public boolean isSuspended( )
	{
		return getThread( ).isSuspended( );
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.ISuspendResume#resume()
	 */
	public void resume( ) throws DebugException
	{
		getThread( ).resume( );
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.ISuspendResume#suspend()
	 */
	public void suspend( ) throws DebugException
	{
		getThread( ).suspend( );

	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.ITerminate#canTerminate()
	 */
	public boolean canTerminate( )
	{
		return getThread( ).canTerminate( );
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.ITerminate#isTerminated()
	 */
	public boolean isTerminated( )
	{
		return getThread( ).isTerminated( );
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.ITerminate#terminate()
	 */
	public void terminate( ) throws DebugException
	{
		getThread( ).terminate( );

	}

	/**Gets the identifier
	 * @return
	 */
	protected int getIdentifier( )
	{
		return id;
	}

	/**Gets the Id
	 * @return
	 */
	public String getId( )
	{
		return name;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals( Object obj )
	{
		if ( obj instanceof ScriptStackFrame )
		{
			ScriptStackFrame sf = (ScriptStackFrame) obj;
			try
			{
				return sf.getName( ).equals( getName( ) )
						&& sf.getLineNumber( ) == getLineNumber( )
						&& sf.id == id;
			}
			catch ( DebugException e )
			{
				//donothing
			}
		}
		return false;
	}

	/**Gets the file name.
	 * @return
	 */
	public String getFileName( )
	{
		return ( (ScriptDebugTarget) getDebugTarget( ) ).getFileName( );
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.birt.report.debug.internal.script.model.ScriptDebugElement#getDisplayName()
	 */
	public String getDisplayName( )
	{
		Object obj = ModuleUtil.getScriptObject(((ScriptDebugTarget)getDebugTarget( )).getModuleHandle( ),
				getId( ) );
		String name = ""; //$NON-NLS-1$
		if ( obj instanceof PropertyHandle )
		{
			name = DEUtil.getFlatHirarchyPathName( ( (PropertyHandle) obj ).getElementHandle( ) )
					+ "." //$NON-NLS-1$
					+ ( (PropertyHandle) obj ).getDefn( ).getName( );
			name = name + "()" + " line: " + lineNumber; //$NON-NLS-1$ //$NON-NLS-2$
		}
		else
		{
			try
			{
				name = getName( );
			}
			catch ( DebugException e )
			{
				name = getId( );
			}
		}
		return name;
	}
}
