/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles;

import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.RowHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.NothingLocator;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.IContainer;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.RowTracker;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class RowHandle
extends AbstractHandle
implements IContainer {
    private static final String TOOLTIP_TABLE_DETAIL = Messages.getString((String)"RowHandle.tooltip.TableDetail");
    private static final String TOOLTIP_TABLE_HEADER = Messages.getString((String)"RowHandle.tooltip.TableHeader");
    private static final String TOOLTIP_TABLE_FOOTER = Messages.getString((String)"RowHandle.tooltip.TableFooter");
    private static final String TOOLTIP_GROUP_HEADER = Messages.getString((String)"RowHandle.tooltip.GroupHeader");
    private static final String TOOLTIP_GROUP_FOOTER = Messages.getString((String)"RowHandle.tooltip.GroupFooter");
    private static final String TOOLTIP_GRID_ROW = Messages.getString((String)"RowHandle.tooltip.GridRow");
    private int rowNumber;

    protected DragTracker createDragTracker() {
        return new RowTracker((TableEditPart)this.getOwner(), this.rowNumber, this);
    }

    public RowHandle(TableEditPart owner, int number) {
        this(owner, new NothingLocator(owner.getFigure()), number);
    }

    public RowHandle(TableEditPart owner, Locator loc, int number) {
        super((GraphicalEditPart)owner, loc);
        this.rowNumber = number;
        this.initialize();
    }

    public boolean containsPoint(int x, int y) {
        return this.getBounds().getCopy().shrink(2, 2).contains(x, y);
    }

    public int getHeight() {
        TableEditPart part = (TableEditPart)this.getOwner();
        return HandleAdapterFactory.getInstance().getRowHandleAdapter(part.getRow(this.rowNumber)).getHeight();
    }

    protected void initialize() {
        this.setOpaque(true);
        LineBorder bd = new LineBorder(1);
        bd.setColor(ReportColorConstants.HandleBorderColor);
        this.setBorder((Border)bd);
        String tp = this.getTooltipText();
        if (tp != null) {
            Label tooltip = new Label(tp);
            tooltip.setBorder((Border)new MarginBorder(0, 2, 0, 2));
            this.setToolTip((IFigure)tooltip);
        }
        this.setCursor(Cursors.ARROW);
    }

    protected void paintFigure(Graphics graphics) {
        if (this.isSelect()) {
            graphics.setBackgroundColor(ReportColorConstants.SelctionFillColor);
        } else {
            graphics.setBackgroundColor(ReportColorConstants.TableGuideFillColor);
        }
        graphics.setLineStyle(1);
        Rectangle bounds = this.getBounds().getCopy().resize(-1, -1);
        graphics.fillRectangle(bounds);
        Font font = FontManager.getFont((String)"Dialog", (int)7, (int)0);
        graphics.setFont(font);
        Image image = this.getImage();
        if (image == null) {
            return;
        }
        graphics.setForegroundColor(ColorConstants.white);
        graphics.setXORMode(true);
        org.eclipse.swt.graphics.Rectangle rect = image.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        graphics.drawImage(image, x, y);
        TableEditPart part = (TableEditPart)this.getOwner();
        RowHandleAdapter rowHandleAdapter = HandleAdapterFactory.getInstance().getRowHandleAdapter(part.getRow(this.getRowNumber()));
        String type = rowHandleAdapter.getType();
        String displayName = rowHandleAdapter.getDisplayName();
        if ("gh".equals(type) || "gf".equals(type)) {
            graphics.drawString(displayName, x + rect.width + 2, y + 2);
        }
        graphics.setBackgroundColor(ColorConstants.black);
        graphics.setXORMode(false);
    }

    @Override
    public boolean contains(Point pt) {
        return false;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public void setRowNumber(int rowNumber) {
        this.rowNumber = rowNumber;
    }

    private String getTooltipText() {
        TableEditPart part = (TableEditPart)this.getOwner();
        RowHandleAdapter rha = HandleAdapterFactory.getInstance().getRowHandleAdapter(part.getRow(this.getRowNumber()));
        String type = rha.getType();
        if ("H".equals(type)) {
            return TOOLTIP_TABLE_HEADER;
        }
        if ("D".equals(type)) {
            return TOOLTIP_TABLE_DETAIL;
        }
        if ("F".equals(type)) {
            return TOOLTIP_TABLE_FOOTER;
        }
        if ("gh".equals(type)) {
            DesignElementHandle obj = rha.getHandle().getContainer();
            String name = null;
            try {
                name = ExpressionUtil.getColumnBindingName((String)((TableGroupHandle)obj).getKeyExpr());
            }
            catch (BirtException birtException) {}
            if (obj instanceof TableGroupHandle && name != null) {
                return String.valueOf(TOOLTIP_GROUP_HEADER) + " (" + name + ")";
            }
            return TOOLTIP_GROUP_HEADER;
        }
        if ("gf".equals(type)) {
            DesignElementHandle obj = rha.getHandle().getContainer();
            String name = null;
            try {
                name = ExpressionUtil.getColumnBindingName((String)((TableGroupHandle)obj).getKeyExpr());
            }
            catch (BirtException birtException) {}
            if (obj instanceof TableGroupHandle && name != null) {
                return String.valueOf(TOOLTIP_GROUP_FOOTER) + " (" + name + ")";
            }
            return TOOLTIP_GROUP_FOOTER;
        }
        return TOOLTIP_GRID_ROW;
    }

    private Image getImage() {
        TableEditPart part = (TableEditPart)this.getOwner();
        if (part.getRow(this.getRowNumber()) == null) {
            return null;
        }
        String type = HandleAdapterFactory.getInstance().getRowHandleAdapter(part.getRow(this.getRowNumber())).getType();
        if ("H".equals(type)) {
            type = "Header";
        } else if ("D".equals(type)) {
            type = "Details";
        } else if ("F".equals(type)) {
            type = "Footer";
        } else if ("gh".equals(type)) {
            type = "Group Header";
        } else if ("gf".equals(type)) {
            type = "Group Footer";
        } else {
            return null;
        }
        return ReportPlatformUIImages.getImage(type);
    }

    @Override
    public boolean isSelect() {
        TableEditPart part = (TableEditPart)this.getOwner();
        List list = part.getViewer().getSelectedEditParts();
        Object obj = part.getRow(this.getRowNumber());
        int size = list.size();
        int i = 0;
        while (i < size) {
            if (((EditPart)list.get(i)).getModel() == obj) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public GraphicalEditPart getOwner() {
        return super.getOwner();
    }
}

