/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.css.engine.value.Value;

public class DataFormatValue
extends Value
implements Serializable,
Cloneable {
    static final long serialVersionUID = 3867198141728167271L;
    private static int ENDING_TAG = -1;
    private static int VERSION_0 = 0;
    private static int FORMATS = 5;
    private static int STRING_FORMAT = 0;
    private static int NUMBER_FORMAT = 1;
    private static int DATE_FORMAT = 2;
    private static int TIME_FORMAT = 3;
    private static int DATETIME_FORMAT = 4;
    protected FormatValue[] values = new FormatValue[FORMATS];

    @Override
    public short getCssValueType() {
        return 3;
    }

    public FormatValue getStringFormat() {
        return this.values[STRING_FORMAT];
    }

    public void setStringFormat(String pattern, String locale) {
        this.values[DataFormatValue.STRING_FORMAT] = new FormatValue(pattern, locale);
    }

    public String getStringPattern() {
        if (this.values[STRING_FORMAT] == null) {
            return null;
        }
        return this.values[DataFormatValue.STRING_FORMAT].pattern;
    }

    public String getStringLocale() {
        if (this.values[STRING_FORMAT] == null) {
            return null;
        }
        return this.values[DataFormatValue.STRING_FORMAT].locale;
    }

    public FormatValue getNumberFormat() {
        return this.values[NUMBER_FORMAT];
    }

    public void setNumberFormat(String pattern, String locale) {
        this.values[DataFormatValue.NUMBER_FORMAT] = new FormatValue(pattern, locale);
    }

    public String getNumberPattern() {
        if (this.values[NUMBER_FORMAT] == null) {
            return null;
        }
        return this.values[DataFormatValue.NUMBER_FORMAT].pattern;
    }

    public String getNumberLocale() {
        if (this.values[NUMBER_FORMAT] == null) {
            return null;
        }
        return this.values[DataFormatValue.NUMBER_FORMAT].locale;
    }

    public FormatValue getDateFormat() {
        return this.values[DATE_FORMAT];
    }

    public void setDateFormat(String pattern, String locale) {
        this.values[DataFormatValue.DATE_FORMAT] = new FormatValue(pattern, locale);
    }

    public String getDatePattern() {
        if (this.values[DATE_FORMAT] == null) {
            return null;
        }
        return this.values[DataFormatValue.DATE_FORMAT].pattern;
    }

    public String getDateLocale() {
        if (this.values[DATE_FORMAT] == null) {
            return null;
        }
        return this.values[DataFormatValue.DATE_FORMAT].locale;
    }

    public FormatValue getTimeFormat() {
        return this.values[TIME_FORMAT];
    }

    public void setTimeFormat(String pattern, String locale) {
        this.values[DataFormatValue.TIME_FORMAT] = new FormatValue(pattern, locale);
    }

    public String getTimePattern() {
        if (this.values[TIME_FORMAT] == null) {
            return null;
        }
        return this.values[DataFormatValue.TIME_FORMAT].pattern;
    }

    public String getTimeLocale() {
        if (this.values[TIME_FORMAT] == null) {
            return null;
        }
        return this.values[DataFormatValue.TIME_FORMAT].locale;
    }

    public FormatValue getDateTimeFormat() {
        return this.values[DATETIME_FORMAT];
    }

    public void setDateTimeFormat(String pattern, String locale) {
        this.values[DataFormatValue.DATETIME_FORMAT] = new FormatValue(pattern, locale);
    }

    public String getDateTimePattern() {
        if (this.values[DATETIME_FORMAT] == null) {
            return null;
        }
        return this.values[DataFormatValue.DATETIME_FORMAT].pattern;
    }

    public String getDateTimeLocale() {
        if (this.values[DATETIME_FORMAT] == null) {
            return null;
        }
        return this.values[DataFormatValue.DATETIME_FORMAT].locale;
    }

    public DataFormatValue clone() {
        try {
            return (DataFormatValue)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public static void write(DataOutputStream out, DataFormatValue value) throws IOException {
        IOUtil.writeInt((OutputStream)out, (int)VERSION_0);
        if (value != null) {
            int i = 0;
            while (i < value.values.length) {
                FormatValue format = value.values[i];
                if (format != null) {
                    IOUtil.writeInt((OutputStream)out, (int)i);
                    IOUtil.writeString((DataOutputStream)out, (String)format.pattern);
                    IOUtil.writeString((DataOutputStream)out, (String)format.locale);
                }
                ++i;
            }
        }
        IOUtil.writeInt((OutputStream)out, (int)ENDING_TAG);
    }

    public static DataFormatValue read(DataInputStream in) throws IOException {
        int version = IOUtil.readInt((InputStream)in);
        if (version == VERSION_0) {
            DataFormatValue value = new DataFormatValue();
            int field = IOUtil.readInt((InputStream)in);
            while (field != ENDING_TAG) {
                String pattern = IOUtil.readString((DataInputStream)in);
                String locale = IOUtil.readString((DataInputStream)in);
                value.values[field] = new FormatValue(pattern, locale);
                field = IOUtil.readInt((InputStream)in);
            }
            return value;
        }
        return null;
    }

    public static DataFormatValue createDataFormatValue(DataFormatValue oldValue) {
        if (oldValue == null) {
            return new DataFormatValue();
        }
        return oldValue.clone();
    }

    private static class FormatValue {
        String pattern;
        String locale;

        public FormatValue(String p, String l) {
            this.pattern = p;
            this.locale = l;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String getLocale() {
            return this.locale;
        }
    }
}

