/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import org.eclipse.cdt.internal.ui.refactoring.rename.RenameMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.resource.RenameResourceProcessor;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class CResourceRenameRefactoringInputPage
extends UserInputWizardPage {
    public static final String KEY_UPDATE_REFERENCES = "updateReferences";
    private static final String DIALOG_SETTINGS_KEY = "CResourceRenameRefactoringInputPage";
    private IDialogSettings fDialogSettings;
    private Text fNameField;
    private RenameResourceProcessor fRefactoringProcessor;
    private Button updateReferences;

    public CResourceRenameRefactoringInputPage(RenameResourceProcessor processor) {
        super(DIALOG_SETTINGS_KEY);
        this.fRefactoringProcessor = processor;
        IDialogSettings ds = CUIPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = ds.getSection(DIALOG_SETTINGS_KEY);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = ds.addNewSection(DIALOG_SETTINGS_KEY);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 0);
        label.setText(RenameMessages.CResourceRenameRefactoringInputPage_new_name);
        label.setLayoutData((Object)new GridData());
        this.fNameField = new Text(composite, 2048);
        String resourceName = this.fRefactoringProcessor.getNewResourceName();
        this.fNameField.setText(resourceName);
        this.fNameField.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CResourceRenameRefactoringInputPage.this.validatePage();
            }
        });
        int lastIndexOfDot = resourceName.lastIndexOf(46);
        if (this.fRefactoringProcessor.getResource().getType() == 1 && lastIndexOfDot > 0) {
            this.fNameField.setSelection(0, lastIndexOfDot);
        } else {
            this.fNameField.selectAll();
        }
        this.updateReferences = new Button(composite, 32);
        this.updateReferences.setText(RenameMessages.CResourceRenameRefactoringInputPage_update_references);
        String value = this.fDialogSettings.get(KEY_UPDATE_REFERENCES);
        boolean updateRefs = value != null ? Boolean.parseBoolean(value) : true;
        this.updateReferences.setSelection(updateRefs);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.updateReferences.setLayoutData((Object)gridData);
        Link link = new Link(composite, 0);
        link.setText("<a>" + RenameMessages.CResourceRenameRefactoringInputPage_open_preferences + "</a>");
        link.setToolTipText(RenameMessages.CResourceRenameRefactoringInputPage_open_preferences_tooltip);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        link.setLayoutData((Object)gridData);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)CResourceRenameRefactoringInputPage.this.getShell(), (String)"org.eclipse.cdt.ui.preferences.OrganizeIncludesPreferencePage", null, null);
                dialog.open();
            }
        });
        Dialog.applyDialogFont((Control)composite);
        this.setPageComplete(false);
        this.setControl((Control)composite);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.fNameField.setFocus();
        }
        super.setVisible(visible);
    }

    private void validatePage() {
        String text = this.fNameField.getText();
        RefactoringStatus status = this.fRefactoringProcessor.validateNewElementName(text);
        this.setPageComplete(status);
    }

    protected boolean performFinish() {
        this.saveRefactoringSettings();
        this.saveDialogSettings();
        return super.performFinish();
    }

    public IWizardPage getNextPage() {
        this.saveRefactoringSettings();
        this.saveDialogSettings();
        return super.getNextPage();
    }

    private void saveDialogSettings() {
        this.fDialogSettings.put(KEY_UPDATE_REFERENCES, this.updateReferences.getSelection());
    }

    private void saveRefactoringSettings() {
        this.fRefactoringProcessor.setNewResourceName(this.fNameField.getText());
        this.fRefactoringProcessor.setUpdateReferences(this.updateReferences.getSelection());
    }
}

