/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.wizards;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.eclemma.core.AgentExecutionDataSource;
import org.eclipse.eclemma.core.IExecutionDataSource;
import org.eclipse.eclemma.core.URLExecutionDataSource;
import org.eclipse.eclemma.internal.ui.ContextHelp;
import org.eclipse.eclemma.internal.ui.UIMessages;
import org.eclipse.eclemma.internal.ui.wizards.WidgetHistory;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SessionImportPage1
extends WizardPage {
    private static final String ID = "SessionImportPage1";
    private static final String STORE_PREFIX = "SessionImportPage1.";
    private static final String STORE_SOURCE = "SessionImportPage1.source";
    private static final String STORE_FILES = "SessionImportPage1.files";
    private static final String STORE_URLS = "SessionImportPage1.urls";
    private static final String STORE_ADDRESS = "SessionImportPage1.address";
    private static final String STORE_PORT = "SessionImportPage1.port";
    private static final String STORE_RESET = "SessionImportPage1.reset";
    private static final String STORE_COPY = "SessionImportPage1.copy";
    private Button fileradio;
    private Button urlradio;
    private Button agentradio;
    private Combo filecombo;
    private Button browsebutton;
    private Combo urlcombo;
    private Text addresstext;
    private Text porttext;
    private Button resetcheck;
    private Button referenceradio;
    private Button copyradio;
    private IExecutionDataSource dataSource;

    protected SessionImportPage1() {
        super(ID);
        this.setTitle(UIMessages.ImportSessionPage1_title);
        this.setDescription(UIMessages.ImportSessionPage1_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        parent = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        Composite sourceGroup = new Composite(parent, 0);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 1).applyTo((Control)sourceGroup);
        GridLayoutFactory.swtDefaults().numColumns(5).applyTo(sourceGroup);
        this.createFileBlock(sourceGroup);
        this.createUrlBlock(sourceGroup);
        this.createAgentBlock(sourceGroup);
        this.createOptionsBlock(parent);
        this.setControl((Control)parent);
        ContextHelp.setHelp((Control)parent, "org.eclipse.eclemma.ui.session_import_context");
        this.restoreWidgetValues();
        this.updateStatus();
    }

    private void createFileBlock(Composite parent) {
        this.fileradio = new Button(parent, 16);
        this.fileradio.setText(UIMessages.ImportSessionPage1ExecutionDataFile_label);
        this.fileradio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionImportPage1.this.updateEnablement();
                SessionImportPage1.this.updateStatus();
            }
        });
        this.filecombo = new Combo(parent, 2048);
        this.filecombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SessionImportPage1.this.updateStatus();
            }
        });
        GridDataFactory.swtDefaults().span(3, 1).grab(true, false).align(4, 0x1000000).hint(this.convertHorizontalDLUsToPixels(80), -1).applyTo((Control)this.filecombo);
        this.browsebutton = new Button(parent, 0);
        this.browsebutton.setText(UIMessages.BrowseAction_label);
        GridDataFactory.swtDefaults().hint(this.convertHorizontalDLUsToPixels(61), -1).applyTo((Control)this.browsebutton);
        this.browsebutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionImportPage1.this.openBrowseDialog();
            }
        });
    }

    private void createUrlBlock(Composite parent) {
        this.urlradio = new Button(parent, 16);
        this.urlradio.setText(UIMessages.ImportSessionPage1ExecutionDataUrl_label);
        this.urlradio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionImportPage1.this.updateEnablement();
                SessionImportPage1.this.updateStatus();
            }
        });
        this.urlcombo = new Combo(parent, 2048);
        this.urlcombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SessionImportPage1.this.updateStatus();
            }
        });
        GridDataFactory.swtDefaults().span(4, 1).align(4, 0x1000000).applyTo((Control)this.urlcombo);
    }

    private void createAgentBlock(Composite parent) {
        this.agentradio = new Button(parent, 16);
        this.agentradio.setText(UIMessages.ImportSessionPage1ExecutionDataAddress_label);
        this.agentradio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionImportPage1.this.updateStatus();
                SessionImportPage1.this.updateEnablement();
            }
        });
        this.addresstext = new Text(parent, 2048);
        this.addresstext.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SessionImportPage1.this.updateStatus();
            }
        });
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.addresstext);
        new Label(parent, 0).setText(UIMessages.ImportSessionPage1ExecutionDataPort_label);
        this.porttext = new Text(parent, 2048);
        this.porttext.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SessionImportPage1.this.updateStatus();
            }
        });
        this.resetcheck = new Button(parent, 32);
        this.resetcheck.setText(UIMessages.ImportSessionPage1ExecutionDataReset_label);
        this.resetcheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionImportPage1.this.updateStatus();
            }
        });
    }

    private void createOptionsBlock(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        Group group = new Group(parent, 0);
        group.setText(UIMessages.ImportSessionPage1ModeGroup_label);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout());
        this.referenceradio = new Button((Composite)group, 16);
        this.referenceradio.setText(UIMessages.ImportSessionPage1Reference_label);
        this.copyradio = new Button((Composite)group, 16);
        this.copyradio.setText(UIMessages.ImportSessionPage1Copy_label);
    }

    private void openBrowseDialog() {
        FileDialog fd = new FileDialog(this.getShell(), 4096);
        fd.setText(UIMessages.ImportSessionPage1BrowseDialog_title);
        fd.setFileName(this.filecombo.getText());
        fd.setFilterExtensions(new String[]{"*.exec", "*.*"});
        String file = fd.open();
        if (file != null) {
            this.filecombo.setText(file);
        }
    }

    private void updateEnablement() {
        this.filecombo.setEnabled(this.fileradio.getSelection());
        this.browsebutton.setEnabled(this.fileradio.getSelection());
        this.urlcombo.setEnabled(this.urlradio.getSelection());
        this.addresstext.setEnabled(this.agentradio.getSelection());
        this.porttext.setEnabled(this.agentradio.getSelection());
        this.resetcheck.setEnabled(this.agentradio.getSelection());
    }

    private void updateStatus() {
        this.dataSource = null;
        if (this.fileradio.getSelection()) {
            File execfile = new File(this.filecombo.getText());
            if (!execfile.exists() || !execfile.isFile()) {
                this.setErrorMessage(UIMessages.ImportSessionPage1NoExecutionDataFile_message);
                this.setPageComplete(false);
                return;
            }
            try {
                this.dataSource = new URLExecutionDataSource(execfile.toURL());
            }
            catch (MalformedURLException malformedURLException) {
                this.setErrorMessage(UIMessages.ImportSessionPage1NoExecutionDataFile_message);
                this.setPageComplete(false);
                return;
            }
        }
        if (this.urlradio.getSelection()) {
            try {
                this.dataSource = new URLExecutionDataSource(new URL(this.urlcombo.getText()));
            }
            catch (MalformedURLException malformedURLException) {
                this.setErrorMessage(UIMessages.ImportSessionPage1NoExecutionDataUrl_message);
                this.setPageComplete(false);
                return;
            }
        }
        if (this.agentradio.getSelection()) {
            String address = this.addresstext.getText();
            if (address.length() == 0) {
                this.setErrorMessage(UIMessages.ImportSessionPage1NoExecutionDataAddress_message);
                this.setPageComplete(false);
                return;
            }
            try {
                int port = Integer.parseInt(this.porttext.getText());
                this.dataSource = new AgentExecutionDataSource(address, port, this.resetcheck.getSelection());
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(UIMessages.ImportSessionPage1NoExecutionDataPort_message);
                this.setPageComplete(false);
                return;
            }
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        WidgetHistory.restoreRadio(settings, STORE_SOURCE, this.fileradio, this.urlradio, this.agentradio);
        WidgetHistory.restoreCombo(settings, STORE_FILES, this.filecombo);
        WidgetHistory.restoreCombo(settings, STORE_URLS, this.urlcombo);
        WidgetHistory.restoreText(settings, STORE_ADDRESS, this.addresstext, "127.0.0.1");
        WidgetHistory.restoreText(settings, STORE_PORT, this.porttext, String.valueOf(6300));
        WidgetHistory.restoreCheck(settings, STORE_RESET, this.resetcheck);
        WidgetHistory.restoreRadio(settings, STORE_COPY, this.referenceradio, this.copyradio);
        this.updateEnablement();
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        WidgetHistory.saveRadio(settings, STORE_SOURCE, this.fileradio, this.urlradio, this.agentradio);
        WidgetHistory.saveCombo(settings, STORE_FILES, this.filecombo);
        WidgetHistory.saveCombo(settings, STORE_URLS, this.urlcombo);
        WidgetHistory.saveText(settings, STORE_ADDRESS, this.addresstext);
        WidgetHistory.saveText(settings, STORE_PORT, this.porttext);
        WidgetHistory.saveCheck(settings, STORE_RESET, this.resetcheck);
        WidgetHistory.saveRadio(settings, STORE_COPY, this.referenceradio, this.copyradio);
    }

    public IExecutionDataSource getExecutionDataSource() {
        return this.dataSource;
    }

    public boolean getCreateCopy() {
        return this.copyradio.getSelection();
    }
}

