/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.ui.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.eclemma.internal.ui.EclEmmaUIPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;

public class CoverageLaunchShortcut
implements ILaunchShortcut,
IExecutableExtension {
    private String delegateId;
    private ILaunchShortcut delegate;

    private ILaunchShortcut getDelegate() {
        if (this.delegate == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.debug.ui", "launchShortcuts");
            IConfigurationElement[] iConfigurationElementArray = extensionPoint.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                if (this.delegateId.equals(config.getAttribute("id"))) {
                    try {
                        this.delegate = (ILaunchShortcut)config.createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        EclEmmaUIPlugin.log(e);
                    }
                    break;
                }
                ++n2;
            }
            if (this.delegate == null) {
                String msg = "ILaunchShortcut declaration not found: " + this.delegateId;
                EclEmmaUIPlugin.getInstance().getLog().log(EclEmmaUIPlugin.errorStatus(msg, null));
            }
        }
        return this.delegate;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.delegateId = String.valueOf(data);
    }

    public void launch(ISelection selection, String mode) {
        ILaunchShortcut delegate = this.getDelegate();
        if (delegate != null) {
            delegate.launch(selection, "coverage");
        }
    }

    public void launch(IEditorPart editor, String mode) {
        ILaunchShortcut delegate = this.getDelegate();
        if (delegate != null) {
            delegate.launch(editor, "coverage");
        }
    }
}

