/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.helper;

import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.Invocation;
import org.eclipse.egf.model.fcore.ModelElement;
import org.eclipse.egf.model.fcore.Orchestration;

public class ActivityCycleFinder {
    private Stack<Activity> _activities = new Stack();
    private Activity _activity;

    public ActivityCycleFinder(Activity activity) {
        Assert.isNotNull((Object)activity);
        this._activity = activity;
    }

    public ModelElement getFirstRepetition() {
        this._activities.clear();
        return this.getFirstRepetition(this._activity);
    }

    protected ModelElement getFirstRepetition(Activity activity) {
        if (activity == null) {
            return null;
        }
        if (activity instanceof FactoryComponent) {
            this._activities.push(activity);
            ModelElement element = this.getFirstRepetition(((FactoryComponent)activity).getOrchestration());
            if (element == null) {
                this._activities.pop();
            }
            return element;
        }
        return null;
    }

    protected ModelElement getFirstRepetition(Orchestration orchestration) {
        if (orchestration == null) {
            return null;
        }
        for (Invocation invocation : orchestration.getInvocations()) {
            ModelElement element = this.getFirstRepetition(invocation);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    protected ModelElement getFirstRepetition(Invocation invocation) {
        if (invocation == null || invocation.getInvokedActivity() == null) {
            return null;
        }
        if (this.activityLookup(invocation.getInvokedActivity())) {
            return invocation;
        }
        return this.getFirstRepetition(invocation.getInvokedActivity());
    }

    private boolean activityLookup(Activity activity) {
        if (activity == null) {
            return false;
        }
        return this._activities.search(activity) != -1;
    }
}

