/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.server.IQueryContext;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.QueryHandlerFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.util.factory.ProductCreationException;

public class InstancesQueryHandler
implements IQueryHandler {
    public void executeQuery(CDOQueryInfo info, IQueryContext context) {
        EClass type = (EClass)info.getParameters().get("type");
        if (type != null) {
            List subTypes;
            this.executeQuery(type, context);
            if (!Boolean.TRUE.equals(info.getParameters().get("exact")) && (subTypes = (List)context.getView().getRepository().getPackageRegistry().getSubTypes().get(type)) != null && !subTypes.isEmpty()) {
                for (EClass subType : subTypes) {
                    if (context.getResultCount() == 0) break;
                    this.executeQuery(subType, context);
                }
            }
        }
    }

    private void executeQuery(EClass type, final IQueryContext context) {
        if (type.isInterface() || type.isAbstract()) {
            return;
        }
        CDOBranch branch = context.getBranch();
        long timeStamp = context.getTimeStamp();
        InternalRepository repository = (InternalRepository)context.getView().getRepository();
        repository.handleRevisions(type, branch, false, timeStamp, false, new CDORevisionHandler(){

            public boolean handleRevision(CDORevision revision) {
                if (revision instanceof DetachedCDORevision) {
                    return true;
                }
                return context.addResult(revision);
            }
        });
    }

    public static class Factory
    extends QueryHandlerFactory {
        public Factory() {
            super("instances");
        }

        public InstancesQueryHandler create(String description) throws ProductCreationException {
            return new InstancesQueryHandler();
        }
    }
}

