/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.dialogs;

import static org.eclipse.epp.internal.logging.aeri.ide.dialogs.UI.gl;

import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ExternalServersEnabledAlert extends IconAndMessageDialog {

    public ExternalServersEnabledAlert(@Nullable Shell parentShell) {
        super(parentShell);
        setShellStyle(getShellStyle() | SWT.SHEET);
    }

    @Override
    protected void configureShell(Shell newShell) {
        newShell.setText(Messages.DIALOG_TITLE_EXTERNAL_SERVERS_ENABLED);
        super.configureShell(newShell);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite) super.createDialogArea(parent);
        gl().numColumns(2).applyTo(container);
        message = Messages.DIALOG_MESSAGE_EXTERNAL_SERVERS_ENABLED;
        createMessageArea(container);
        return container;
    }

    @Override
    protected Image getImage() {
        return getInfoImage();
    }
}
