/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.dialogs;

import static org.apache.commons.lang3.StringUtils.*;

import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.logging.aeri.core.SendMode;
import org.eclipse.jface.viewers.LabelProvider;

public class SendModeLabelProvider extends LabelProvider {
    @Override
    public String getText(Object element) {
        SendMode mode = (SendMode) element;
        switch (mode) {
        case NOTIFY:
            return Messages.SEND_MODE_NOTIFY_LABEL;
        case BACKGROUND:
            return Messages.SEND_MODE_BACKGROUND_LABEL;
        case NEVER:
            return Messages.SEND_MODE_NEVER_LABEL;
        }
        return capitalize(lowerCase(replaceChars(element.toString(), '_', ' ')));
    }
}
