/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.internal.modelelements;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.editor.welcome.internal.modelelements.LanguageObservable;
import org.eclipse.papyrus.infra.editor.welcome.internal.modelelements.LanguagesObservableProperty;
import org.eclipse.papyrus.infra.editor.welcome.internal.modelelements.PrivateLayoutValue;
import org.eclipse.papyrus.infra.editor.welcome.internal.modelelements.RestoreActivePageValue;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElement;

public class WelcomeModelElement
extends EMFModelElement {
    private final String PRIVATE_LAYOUT = "privateLayout";
    private final String RESTORE_ACTIVE_PAGE = "restoreActivePage";
    private final String LANGUAGES = "languages";

    public WelcomeModelElement(EObject source, EditingDomain domain) {
        super(source, domain);
    }

    protected IObservable doGetObservable(String propertyPath) {
        IObservableList<LanguageObservable> result;
        switch (propertyPath) {
            case "privateLayout": {
                result = new PrivateLayoutValue(this);
                break;
            }
            case "restoreActivePage": {
                result = new RestoreActivePageValue(this);
                break;
            }
            case "languages": {
                result = new LanguagesObservableProperty(this).get();
                break;
            }
            default: {
                result = super.doGetObservable(propertyPath);
            }
        }
        return result;
    }

    protected boolean isFeatureEditable(String propertyPath) {
        boolean result;
        switch (propertyPath) {
            case "privateLayout": {
                result = true;
                break;
            }
            case "restoreActivePage": {
                IObservableValue privateLayout = (IObservableValue)this.getObservable("privateLayout");
                result = Boolean.TRUE.equals(privateLayout.getValue());
                break;
            }
            case "languages": {
                result = true;
                break;
            }
            default: {
                result = super.isFeatureEditable(propertyPath);
            }
        }
        return result;
    }

    protected boolean isElementEditable() {
        return true;
    }

    public boolean forceRefresh(String propertyPath) {
        boolean result;
        switch (propertyPath) {
            case "restoreActivePage": {
                result = true;
                break;
            }
            default: {
                result = super.forceRefresh(propertyPath);
            }
        }
        return result;
    }
}

