/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.modelresource;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.papyrus.infra.core.resource.AbstractModelWithSharedResource;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.internationalization.Activator;
import org.eclipse.papyrus.infra.internationalization.InternationalizationEntry;
import org.eclipse.papyrus.infra.internationalization.InternationalizationFactory;
import org.eclipse.papyrus.infra.internationalization.InternationalizationLibrary;
import org.eclipse.papyrus.infra.internationalization.InternationalizationPackage;
import org.eclipse.papyrus.infra.internationalization.commands.ResetNameCommand;
import org.eclipse.papyrus.infra.internationalization.commands.ResetNameTransactionalCommand;
import org.eclipse.papyrus.infra.internationalization.common.editor.IInternationalizationEditor;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.internationalization.helper.InternationalizationResourceHelper;
import org.eclipse.papyrus.infra.internationalization.resource.InternationalizationResource;
import org.eclipse.papyrus.infra.internationalization.utils.EntryPartLabelSynchronizer;
import org.eclipse.papyrus.infra.internationalization.utils.InternationalizationKeyResolver;
import org.eclipse.papyrus.infra.internationalization.utils.PreferencePartLabelSynchronizer;
import org.eclipse.papyrus.infra.internationalization.utils.PropertiesFilesUtils;
import org.eclipse.papyrus.infra.internationalization.utils.QualifiedNameUtils;
import org.eclipse.papyrus.infra.internationalization.utils.ResourceBundleAndURI;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.NattableconfigurationPackage;

public class InternationalizationModelResource
extends AbstractModelWithSharedResource<InternationalizationLibrary>
implements IModel {
    public static final String MODEL_ID = "org.eclipse.papyrus.infra.internationalization.resource.InternationalizationModel";
    protected Map<URI, Map<Locale, Resource>> propertiesByLocale = null;
    protected Set<EObject> deletedObjects = null;
    protected Map<EObject, Adapter> adapters = null;
    protected Map<EObject, IInternationalizationEditor> editorPartByEObject = null;
    protected Map<EObject, Map<InternationalizationEntry, EntryPartLabelSynchronizer>> entriesLabelSynchronizerByEObject = null;
    protected Map<EObject, PreferencePartLabelSynchronizer> preferencePartLabelSynchronizers = null;
    protected Set<Resource> resourcesToNotSave = new HashSet<Resource>();
    protected Map<Resource, InternationalizationLibrary> resourceContents;

    public InternationalizationModelResource() {
        this.propertiesByLocale = new HashMap<URI, Map<Locale, Resource>>();
        if (InternationalizationPreferencesUtils.isInternationalizationNeedToBeLoaded()) {
            Activator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("language")) {
                        for (Resource resource : new HashSet(InternationalizationModelResource.this.getResources())) {
                            InternationalizationModelResource.this.loadModel(InternationalizationModelResource.this.getInitialURIForResource(resource).trimFileExtension());
                        }
                    }
                }
            });
        }
        this.deletedObjects = new HashSet<EObject>();
        this.adapters = new HashMap<EObject, Adapter>();
        this.resourceContents = new HashMap<Resource, InternationalizationLibrary>();
    }

    public void init(ModelSet modelSet) {
        super.init(modelSet);
        InternationalizationResourceHelper.installUMLInternationalizationSupport((ResourceSet)modelSet);
    }

    protected InternationalizationKeyResolver createKeyResolver() {
        return new InternationalizationKeyResolver();
    }

    public void loadModel(URI uriWithoutExtension) {
        this.loadModel(uriWithoutExtension, true);
    }

    public void loadModel(URI uriWithoutExtension, boolean needToLoadOtherProperties) {
        URI uri;
        if (InternationalizationPreferencesUtils.isInternationalizationNeedToBeLoaded() && this.needToBeLoaded(uri = uriWithoutExtension.appendFileExtension(this.getModelFileExtension()))) {
            this.resourceURI = uri;
            Locale locale = InternationalizationPreferencesUtils.getLocalePreference((URI)uriWithoutExtension);
            try {
                this.resource = this.loadResource(uri, locale);
                if (needToLoadOtherProperties) {
                    this.resourceURI = uri;
                    String existingResourceLoadedName = "";
                    if (this.resource != null) {
                        existingResourceLoadedName = this.resource.getURI().lastSegment();
                    }
                    this.loadOthersPropertiesFiles(uri, existingResourceLoadedName);
                }
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }

    protected boolean needToBeLoaded(URI uri) {
        return !this.propertiesByLocale.containsKey(uri);
    }

    public void addResourceToModel(URI uri, Resource resource, Locale locale) {
        this.resourceURI = uri.trimFileExtension().appendFileExtension(this.getModelFileExtension());
        this.configureResource(this.resourceURI, resource, locale);
    }

    protected void loadOthersPropertiesFiles(URI uri, String loadedResourceFile) {
        URI uriWithoutExtension = uri.trimFileExtension();
        String modelName = uriWithoutExtension.segment(uriWithoutExtension.segmentCount() - 1);
        URI folderURI = uriWithoutExtension.trimSegments(1);
        IProject parentFolder = null;
        if (folderURI.isPlatformResource()) {
            String uriPlatformString = folderURI.toPlatformString(true);
            try {
                parentFolder = ResourcesPlugin.getWorkspace().getRoot().getProject(uriPlatformString);
            }
            catch (Exception exception) {
                parentFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(uriPlatformString));
            }
        }
        if (parentFolder != null) {
            String extension = "." + this.getModelFileExtension();
            try {
                IResource[] iResourceArray = parentFolder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resourceEntry = iResourceArray[n2];
                    if (resourceEntry.getName().startsWith(modelName) && resourceEntry.getName().endsWith(extension)) {
                        String fileNAmeWithoutExtension = resourceEntry.getName().substring(0, resourceEntry.getName().length() - extension.length());
                        String possibleLocale = fileNAmeWithoutExtension.substring(modelName.length());
                        if (!resourceEntry.getName().equals(loadedResourceFile) || possibleLocale.isEmpty()) {
                            if (possibleLocale.isEmpty() && this.getResourceForURIAndLocale(uri, new Locale("")) == null) {
                                URI newURI = folderURI.appendSegment(fileNAmeWithoutExtension).appendFileExtension(this.getModelFileExtension());
                                this.loadResource(newURI, new Locale(""));
                            } else if (possibleLocale.startsWith("_")) {
                                possibleLocale = possibleLocale.substring(1);
                                Locale localeFound = null;
                                Iterator<Locale> availableLocales = Arrays.asList(Locale.getAvailableLocales()).iterator();
                                while (availableLocales.hasNext() && localeFound == null) {
                                    Locale currentAvailableLocale = availableLocales.next();
                                    if (!currentAvailableLocale.toString().equals(possibleLocale)) continue;
                                    localeFound = currentAvailableLocale;
                                }
                                if (localeFound != null) {
                                    this.loadResource(uri, localeFound);
                                }
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    protected Resource loadResource(URI uri, Locale locale) {
        Resource resource = null;
        ResourceBundleAndURI resourceBundleAndURI = PropertiesFilesUtils.getResourceBundle(uri, locale);
        if (resourceBundleAndURI != null) {
            resource = this.getResourceSet().getResource(resourceBundleAndURI.getUri(), false);
            if (resource != null) {
                this.configureResource(uri, resource, locale);
            } else {
                resource = this.modelSet.createResource(resourceBundleAndURI.getUri());
                this.configureResource(uri, resource, locale);
                if (InternationalizationPreferencesUtils.isInternationalizationExternalFilesNeedToBeLoaded()) {
                    this.startSnippets();
                }
            }
            if (!resource.isLoaded()) {
                if (this.modelSet.getTransactionalEditingDomain().isReadOnly(resource)) {
                    this.unload(resource);
                    this.getResources().remove(resource);
                    this.modelSet.getResources().remove((Object)resource);
                    if (InternationalizationPreferencesUtils.isInternationalizationExternalFilesNeedToBeLoaded()) {
                        URI initialResourceURI = resource.getURI();
                        String lastSegment = initialResourceURI.lastSegment();
                        URI newResourceURI = this.modelSet.getURIWithoutExtension();
                        newResourceURI = newResourceURI.trimSegments(1);
                        newResourceURI = newResourceURI.appendSegment(lastSegment);
                        resource = this.getResourceSet().getResource(newResourceURI, false);
                        if (resource == null) {
                            resource = this.modelSet.createResource(newResourceURI);
                        }
                        this.configureResource(initialResourceURI, resource, locale);
                        if (resource instanceof InternationalizationResource) {
                            Map defaultLoadOptions = ((InternationalizationResource)resource).getDefaultLoadOptions();
                            defaultLoadOptions.put("unsafeAddCommand", true);
                        }
                        try {
                            resource.load(null);
                            Object libraryContent = ((InternationalizationResource)resource).getDefaultSaveOptions().get("resourceContent");
                            if (libraryContent instanceof InternationalizationLibrary) {
                                this.resourceContents.put(resource, (InternationalizationLibrary)libraryContent);
                            }
                        }
                        catch (IOException e) {
                            Activator.log.error("Error during load resource.", (Throwable)e);
                        }
                    }
                    this.resourcesToNotSave.add(resource);
                    this.modelSet.getResources().remove((Object)resource);
                } else {
                    try {
                        resource.load(null);
                        Object libraryContent = ((InternationalizationResource)resource).getDefaultSaveOptions().get("resourceContent");
                        if (libraryContent instanceof InternationalizationLibrary) {
                            this.resourceContents.put(resource, (InternationalizationLibrary)libraryContent);
                        }
                    }
                    catch (IOException e) {
                        Activator.log.error("Error during load resource.", (Throwable)e);
                    }
                }
            }
            this.loadInternationalizationContent(uri, locale);
        } else if (InternationalizationPreferencesUtils.isInternationalizationExternalFilesNeedToBeLoaded()) {
            this.startSnippets();
        }
        return resource;
    }

    public void createModel(URI uriWithoutExtension) {
        if (InternationalizationPreferencesUtils.isInternationalizationNeedToBeLoaded()) {
            super.createModel(uriWithoutExtension);
            URI uri = uriWithoutExtension.appendFileExtension(this.getModelFileExtension());
            Resource resource = this.getResourceSet().getResource(uri, false);
            Locale locale = null;
            if (resource != null) {
                locale = InternationalizationPreferencesUtils.getLocalePreference((URI)resource.getURI());
                this.configureResource(this.resourceURI, resource, locale);
                this.loadInternationalizationContent(uri, locale);
                resource.setModified(true);
                try {
                    this.saveResource(resource);
                }
                catch (IOException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
    }

    protected void configureResource(URI uri, Resource resourceToConfigure, Locale locale) {
        if (resourceToConfigure instanceof InternationalizationResource) {
            Map defaultLoadOptions = ((InternationalizationResource)resourceToConfigure).getDefaultLoadOptions();
            defaultLoadOptions.put("internationalizationKeyResolver", this.createKeyResolver());
            defaultLoadOptions.put("internationalizationLocale", locale);
            defaultLoadOptions.put("internationalizationURI", uri);
        }
        super.configureResource(resourceToConfigure);
        if (this.propertiesByLocale.get(uri) == null) {
            this.propertiesByLocale.put(uri, new HashMap());
        }
        this.propertiesByLocale.get(uri).put(locale, resourceToConfigure);
    }

    protected void loadInternationalizationContent(URI uri, Locale locale) {
        InternationalizationLibrary library;
        Resource resource = this.getResourceForURIAndLocale(uri, locale);
        if (resource != null && (library = this.getInternationalizationLibrary(resource)) != null) {
            for (InternationalizationEntry entry : library.getEntries()) {
                if (!(entry.getKey() instanceof EObject)) continue;
                this.addModifiedAdapter((EObject)entry.getKey(), resource);
            }
        }
    }

    protected Resource createResource(URI uri, Locale locale) {
        URI propertiesURI;
        this.resourceURI = propertiesURI = uri.trimFileExtension().appendFileExtension(this.getModelFileExtension());
        String lastSegment = propertiesURI.trimFileExtension().lastSegment();
        lastSegment = String.valueOf(lastSegment) + "_" + locale.toString();
        propertiesURI = propertiesURI.trimSegments(1);
        propertiesURI = propertiesURI.appendSegment(lastSegment);
        propertiesURI = propertiesURI.appendFileExtension(this.getModelFileExtension());
        Resource resultResource = this.modelSet.createResource(propertiesURI);
        this.configureResource(this.resourceURI, resultResource, locale);
        if (!resultResource.isLoaded()) {
            try {
                resultResource.load(null);
            }
            catch (IOException e) {
                Activator.log.error("Error during load resource.", (Throwable)e);
            }
        }
        this.createInternationalizationContent(resultResource);
        this.startSnippets();
        this.resource = resultResource;
        return resultResource;
    }

    protected void createInternationalizationContent(Resource resource) {
        if (resource != null) {
            InternationalizationLibrary library = InternationalizationFactory.eINSTANCE.createInternationalizationLibrary();
            ((InternationalizationResource)resource).getDefaultSaveOptions().put("resourceContent", library);
            this.resourceContents.put(resource, library);
        }
    }

    public void setModelURI(URI uriWithoutExtension) {
        this.resourceURI = uriWithoutExtension.appendFileExtension(this.getModelFileExtension());
        for (Resource resource : this.getResources()) {
            if (this.resourcesToNotSave.contains(resource)) continue;
            this.updateURI(resource, uriWithoutExtension);
        }
    }

    protected void updateURI(Resource resource, URI newURIwithoutExtension) {
        URI initialURI = this.getInitialURIForResource(resource);
        Locale locale = this.getLocaleForResource(resource);
        URI newBaseURI = newURIwithoutExtension.trimFileExtension();
        if (locale != null && !locale.toString().isEmpty()) {
            String lastSegment = newBaseURI.lastSegment();
            lastSegment = String.valueOf(lastSegment) + "_" + locale.toString();
            newBaseURI = newBaseURI.trimSegments(1);
            newBaseURI = newBaseURI.appendSegment(lastSegment);
        }
        newBaseURI = newBaseURI.appendFileExtension(this.getModelFileExtension());
        resource.setURI(newBaseURI);
        if (locale != null) {
            this.propertiesByLocale.get(initialURI).remove(locale);
            if (this.propertiesByLocale.get(initialURI).isEmpty()) {
                this.propertiesByLocale.remove(initialURI);
            }
        }
        if (this.propertiesByLocale.get(this.resourceURI) == null) {
            this.propertiesByLocale.put(this.resourceURI, new HashMap());
        }
        this.propertiesByLocale.get(this.resourceURI).put(locale, resource);
    }

    public void saveModel() throws IOException {
        for (Resource resource : this.getResources()) {
            if (this.resourcesToNotSave.contains(resource)) continue;
            this.saveResource(resource);
        }
    }

    protected void saveResource(Resource resource) throws IOException {
        if (!this.resourcesToNotSave.contains(resource)) {
            Map saveOptions = null;
            if (resource instanceof XMLResource) {
                saveOptions = ((XMLResource)resource).getDefaultSaveOptions();
                if (resource instanceof InternationalizationResource) {
                    saveOptions.put("internationalizationDeletedObjects", this.deletedObjects);
                    saveOptions.put("internationalizationKeyResolver", this.createKeyResolver());
                }
            }
            resource.save(saveOptions);
        }
    }

    protected void addModifiedAdapter(final EObject eObject, final Resource resource) {
        if (!this.adapters.containsKey(eObject)) {
            Adapter modifiedAdapter = new Adapter(){

                public void setTarget(Notifier newTarget) {
                }

                public void notifyChanged(Notification notification) {
                    Object newValue;
                    if (4 == notification.getEventType() || 6 == notification.getEventType()) {
                        Object oldValue = notification.getOldValue();
                        if (oldValue instanceof EObject) {
                            InternationalizationModelResource.this.deletedObjects.add((EObject)oldValue);
                        }
                    } else if ((3 == notification.getEventType() || 5 == notification.getEventType()) && (newValue = notification.getNewValue()) instanceof EObject && InternationalizationModelResource.this.deletedObjects.contains(newValue)) {
                        InternationalizationModelResource.this.deletedObjects.remove((EObject)newValue);
                    }
                    if (eObject.eResource() != null && InternationalizationModelResource.this.getLocalesAndResourcesForURI(eObject.eResource().getURI()) != null) {
                        for (Resource res : InternationalizationModelResource.this.getLocalesAndResourcesForURI(eObject.eResource().getURI()).values()) {
                            res.setModified(true);
                        }
                    } else {
                        resource.setModified(true);
                    }
                }

                public boolean isAdapterForType(Object type) {
                    return false;
                }

                public Notifier getTarget() {
                    return null;
                }
            };
            eObject.eAdapters().add((Object)modifiedAdapter);
            this.adapters.put(eObject, modifiedAdapter);
        }
    }

    protected boolean isModelRoot(EObject object) {
        return object instanceof InternationalizationLibrary;
    }

    public String getModelFileExtension() {
        return "properties";
    }

    public ModelSet getModelManager() {
        return super.getModelManager();
    }

    public boolean isRelatedResource(Resource resource) {
        return super.isRelatedResource(resource);
    }

    public String getIdentifier() {
        return MODEL_ID;
    }

    public String getValueForEntryKey(URI uri, Object key, Locale locale) {
        InternationalizationEntry entry = this.getEntryForKey(uri, key, locale);
        return entry != null ? entry.getValue() : null;
    }

    public String getValueForEntryKey(URI uri, EObject key) {
        InternationalizationEntry entry = this.getEntryForKey(uri, key, InternationalizationPreferencesUtils.getLocalePreference((EObject)InternationalizationModelResource.getParentEObject(key)));
        return entry != null ? entry.getValue() : null;
    }

    public InternationalizationEntry getEntryForKey(URI uri, Object key, Locale locale) {
        InternationalizationLibrary library;
        InternationalizationEntry result = null;
        Resource resource = this.getResourceForURIAndLocale(uri, locale);
        if (resource == null) {
            resource = this.getResourceForURIAndLocale(uri, new Locale(""));
        }
        if (resource != null && (library = this.getInternationalizationLibrary(resource)) != null) {
            Iterator entries = library.getEntries().iterator();
            while (entries.hasNext() && result == null) {
                InternationalizationEntry entry = (InternationalizationEntry)entries.next();
                if (!entry.getKey().equals(key)) continue;
                result = entry;
            }
        }
        return result;
    }

    public Command getSetValueCommand(EditingDomain domain, URI uri, final EObject key, String value, Locale locale) {
        CompoundCommand resultCommand = null;
        if (InternationalizationPreferencesUtils.isInternationalizationNeedToBeLoaded()) {
            InternationalizationLibrary library;
            Resource resource = this.getResourceForURIAndLocale(uri, locale);
            if (resource == null) {
                resource = this.getResourceForURIAndLocale(uri, new Locale(""));
            }
            if ((library = this.getInternationalizationLibrary(resource)) != null) {
                Iterator entries = library.getEntries().iterator();
                while (entries.hasNext() && resultCommand == null) {
                    Command setNameValueCommand;
                    InternationalizationEntry entry = (InternationalizationEntry)entries.next();
                    if (!entry.getKey().equals(key)) continue;
                    if (value == null || value.isEmpty()) {
                        resultCommand = new CompoundCommand("Remove entry");
                        resultCommand.append((Command)new RemoveCommand(domain, (EObject)library, (EStructuralFeature)InternationalizationPackage.eINSTANCE.getInternationalizationLibrary_Entries(), (Object)entry));
                        if (entry.getKey() instanceof EObject && (setNameValueCommand = this.getSetNameValueCommand(domain, (EObject)entry.getKey())) != null) {
                            resultCommand.append(setNameValueCommand);
                        }
                        resource.setModified(true);
                        continue;
                    }
                    resultCommand = new CompoundCommand("Set entry value");
                    resultCommand.append((Command)new SetCommand(domain, (EObject)entry, (EStructuralFeature)InternationalizationPackage.eINSTANCE.getInternationalizationEntry_Value(), (Object)value));
                    if (entry.getKey() instanceof EObject && (setNameValueCommand = this.getSetNameValueCommand(domain, (EObject)entry.getKey())) != null) {
                        resultCommand.append(setNameValueCommand);
                    }
                    resource.setModified(true);
                }
            }
            if (resultCommand == null && value != null && !value.isEmpty()) {
                Command setNameValueCommand;
                final InternationalizationEntry entry = InternationalizationFactory.eINSTANCE.createInternationalizationEntry();
                entry.setKey(key);
                entry.setValue(value);
                if (resource == null) {
                    resultCommand = new CompoundCommand("Create entry");
                    resultCommand.append((Command)new CreatePropertiesResourceCommand(uri, entry, InternationalizationPreferencesUtils.getLocalePreference((EObject)InternationalizationModelResource.getParentEObject(key))));
                    setNameValueCommand = this.getSetNameValueCommand(domain, (EObject)entry.getKey());
                    if (setNameValueCommand != null) {
                        resultCommand.append(setNameValueCommand);
                    }
                } else {
                    resultCommand = new CompoundCommand("Create entry");
                    resultCommand.append((Command)new AddCommand(domain, (EObject)library, (EStructuralFeature)InternationalizationPackage.eINSTANCE.getInternationalizationLibrary_Entries(), (Object)entry));
                    setNameValueCommand = this.getSetNameValueCommand(domain, (EObject)entry.getKey());
                    if (setNameValueCommand != null) {
                        resultCommand.append(setNameValueCommand);
                    }
                    resource.setModified(true);
                }
                if (this.editorPartByEObject != null && this.editorPartByEObject.containsKey(key) && resultCommand != null) {
                    CompoundCommand tmpCommand = resultCommand;
                    resultCommand = new CompoundCommand("Change label value");
                    resultCommand.append((Command)tmpCommand);
                    resultCommand.append((Command)new AbstractCommand(){

                        public void execute() {
                            InternationalizationModelResource.this.addPartLabelSynchronizerForEntry(key, entry);
                        }

                        protected boolean prepare() {
                            return true;
                        }

                        public void undo() {
                        }

                        public void redo() {
                        }
                    });
                }
            }
        }
        return resultCommand;
    }

    public void setValue(URI uri, EObject key, String value, Locale locale) {
        if (InternationalizationPreferencesUtils.isInternationalizationNeedToBeLoaded()) {
            InternationalizationEntry entry;
            Resource resource = this.getResourceForURIAndLocale(uri, locale);
            if (resource == null) {
                resource = this.createResource(uri, InternationalizationPreferencesUtils.getLocalePreference((EObject)InternationalizationModelResource.getParentEObject(key)));
            }
            InternationalizationLibrary library = this.getInternationalizationLibrary(resource);
            Iterator entries = library.getEntries().iterator();
            boolean hasFound = false;
            while (entries.hasNext() && !hasFound) {
                entry = (InternationalizationEntry)entries.next();
                if (!entry.getKey().equals(key)) continue;
                if (value == null || value.isEmpty()) {
                    entries.remove();
                } else {
                    entry.setValue(value);
                    if (entry.getKey() instanceof EObject) {
                        this.setNameValue((EObject)entry.getKey());
                    }
                }
                hasFound = true;
            }
            if (!hasFound && value != null && !value.isEmpty()) {
                entry = InternationalizationFactory.eINSTANCE.createInternationalizationEntry();
                entry.setKey(key);
                entry.setValue(value);
                library.getEntries().add((Object)entry);
                this.setNameValue(entry);
                if (this.editorPartByEObject.containsKey(key)) {
                    this.addPartLabelSynchronizerForEntry(key, entry);
                }
            }
            resource.setModified(true);
        }
    }

    protected Command getSetNameValueCommand(EditingDomain domain, EObject eObject) {
        ResetNameCommand result = null;
        if (InternationalizationPreferencesUtils.isInternationalizationNeedToBeLoaded()) {
            if (domain instanceof TransactionalEditingDomain) {
                if (eObject instanceof Diagram) {
                    result = new GMFtoEMFCommandWrapper((ICommand)new ResetNameTransactionalCommand((TransactionalEditingDomain)domain, eObject, (EStructuralFeature)NotationPackage.eINSTANCE.getDiagram_Name()));
                } else if (eObject instanceof Table) {
                    result = new GMFtoEMFCommandWrapper((ICommand)new ResetNameTransactionalCommand((TransactionalEditingDomain)domain, eObject, (EStructuralFeature)NattableconfigurationPackage.eINSTANCE.getTableNamedElement_Name()));
                }
            } else if (eObject instanceof Diagram) {
                result = new ResetNameCommand(domain, eObject, (EStructuralFeature)NotationPackage.eINSTANCE.getDiagram_Name());
            } else if (eObject instanceof Table) {
                result = new ResetNameCommand(domain, eObject, (EStructuralFeature)NattableconfigurationPackage.eINSTANCE.getTableNamedElement_Name());
            }
        }
        return result;
    }

    protected void setNameValue(EObject eObject) {
        if (eObject instanceof Diagram) {
            String oldName = ((Diagram)eObject).getName();
            ((Diagram)eObject).setName("");
            ((Diagram)eObject).setName(oldName);
        } else if (eObject instanceof Table) {
            String oldName = ((Table)eObject).getName();
            ((Table)eObject).setName("");
            ((Table)eObject).setName(oldName);
        }
    }

    public InternationalizationLibrary getInternationalizationLibrary(Resource resource) {
        if (resource != null && this.resourceContents.containsKey(resource)) {
            return this.resourceContents.get(resource);
        }
        return null;
    }

    public Set<Locale> getAvailablePropertiesLocales(URI uri) {
        URI uriWithCorrectExtension = uri.trimFileExtension().appendFileExtension(this.getModelFileExtension());
        return this.propertiesByLocale.containsKey(uriWithCorrectExtension) ? this.propertiesByLocale.get(uriWithCorrectExtension).keySet() : new HashSet<Locale>(0);
    }

    public Map<Locale, Resource> getLocalesAndResourcesForURI(URI uri) {
        Map<Locale, Resource> result = null;
        URI propertiesURI = uri.trimFileExtension().appendFileExtension(this.getModelFileExtension());
        if (this.propertiesByLocale.containsKey(propertiesURI)) {
            result = this.propertiesByLocale.get(propertiesURI);
        }
        return result;
    }

    public Resource getResourceForURIAndLocale(URI uri, Locale locale) {
        Map<Locale, Resource> resourceByLocale;
        Resource resultResource = null;
        URI propertiesURI = uri.trimFileExtension().appendFileExtension(this.getModelFileExtension());
        if (this.propertiesByLocale.containsKey(propertiesURI) && (resourceByLocale = this.propertiesByLocale.get(propertiesURI)).containsKey(locale)) {
            resultResource = resourceByLocale.get(locale);
        }
        return resultResource;
    }

    public Locale getLocaleForResource(Resource resource) {
        Locale resultLocale = null;
        for (URI uri : this.propertiesByLocale.keySet()) {
            Map<Locale, Resource> resourceByLocale = this.propertiesByLocale.get(uri);
            for (Map.Entry<Locale, Resource> entry : resourceByLocale.entrySet()) {
                if (!entry.getValue().equals(resource)) continue;
                resultLocale = entry.getKey();
            }
        }
        return resultLocale;
    }

    protected URI getInitialURIForResource(Resource resource) {
        URI initialURI = null;
        Iterator<URI> uriIterator = this.propertiesByLocale.keySet().iterator();
        while (uriIterator.hasNext() && initialURI == null) {
            URI uri = uriIterator.next();
            if (!this.propertiesByLocale.get(uri).values().contains(resource)) continue;
            initialURI = uri;
        }
        return initialURI;
    }

    protected static EObject getParentEObject(EObject eObject) {
        EObject parentEObject = eObject;
        if (eObject instanceof Table) {
            parentEObject = ((Table)eObject).getOwner() != null ? ((Table)eObject).getOwner() : ((Table)eObject).getContext();
        } else if (eObject instanceof Diagram) {
            parentEObject = QualifiedNameUtils.getOwner((Diagram)eObject);
        }
        return parentEObject;
    }

    public boolean isLoadedResourcesForURI(URI uri) {
        return this.propertiesByLocale.containsKey(uri.trimFileExtension().appendFileExtension(this.getModelFileExtension()));
    }

    public void unload() {
        for (Resource resource : this.getResources()) {
            URI initialUri = this.getInitialURIForResource(resource);
            if (initialUri != null) {
                this.unload(initialUri);
            }
            this.unload(resource);
        }
        for (EObject eObject : this.adapters.keySet()) {
            Adapter adapter = this.adapters.get(eObject);
            eObject.eAdapters().remove((Object)adapter);
            adapter = null;
        }
        this.adapters.clear();
        if (this.editorPartByEObject != null) {
            this.editorPartByEObject.clear();
            this.editorPartByEObject = null;
        }
        if (this.entriesLabelSynchronizerByEObject != null) {
            for (Map.Entry entry : this.entriesLabelSynchronizerByEObject.entrySet()) {
                for (EntryPartLabelSynchronizer partLabelSynchronizer : ((Map)entry.getValue()).values()) {
                    partLabelSynchronizer.dispose();
                }
            }
            this.entriesLabelSynchronizerByEObject.clear();
            this.entriesLabelSynchronizerByEObject = null;
        }
        if (this.preferencePartLabelSynchronizers != null) {
            for (PreferencePartLabelSynchronizer preferencePartLabelSynchronizer : this.preferencePartLabelSynchronizers.values()) {
                preferencePartLabelSynchronizer.dispose();
            }
            this.preferencePartLabelSynchronizers.clear();
            this.preferencePartLabelSynchronizers = null;
        }
        this.resourcesToNotSave.clear();
        this.resourceContents.clear();
        this.resource = null;
        super.unload();
    }

    public void unload(URI uri) {
        PropertiesFilesUtils.removeResourceBundle(uri);
        if (this.propertiesByLocale.containsKey(uri)) {
            this.propertiesByLocale.remove(uri);
        }
    }

    public void unload(Resource resource) {
        PropertiesFilesUtils.removeResourceBundle(resource.getURI());
        URI initialUri = this.getInitialURIForResource(resource);
        if (this.propertiesByLocale.containsKey(initialUri)) {
            Iterator<Map.Entry<Locale, Resource>> entriesIterator = this.propertiesByLocale.get(initialUri).entrySet().iterator();
            while (entriesIterator.hasNext()) {
                Map.Entry<Locale, Resource> entry = entriesIterator.next();
                if (!entry.getValue().equals(resource)) continue;
                entriesIterator.remove();
            }
            if (this.propertiesByLocale.get(initialUri).isEmpty()) {
                this.propertiesByLocale.remove(initialUri);
            }
        }
        this.resourceContents.remove(resource);
        resource.unload();
    }

    public void addEditorPartForEObject(EObject eObject, IInternationalizationEditor editorPart) {
        if (this.editorPartByEObject == null) {
            this.editorPartByEObject = new HashMap<EObject, IInternationalizationEditor>();
        }
        if (!this.editorPartByEObject.containsKey(eObject)) {
            this.editorPartByEObject.put(eObject, editorPart);
        }
        URI uri = eObject.eResource().getURI();
        for (Locale locale : this.getAvailablePropertiesLocales(uri)) {
            InternationalizationEntry entry = this.getEntryForKey(uri, eObject, locale);
            this.addPartLabelSynchronizerForEntry(eObject, entry);
        }
        this.addPartLabelSynchronizerForPreferenceStore(eObject);
    }

    protected void addPartLabelSynchronizerForEntry(EObject eObject, InternationalizationEntry entry) {
        if (this.entriesLabelSynchronizerByEObject == null) {
            this.entriesLabelSynchronizerByEObject = new HashMap<EObject, Map<InternationalizationEntry, EntryPartLabelSynchronizer>>();
        }
        Map<Object, Object> entriesLabelSynchronizer = null;
        if (this.entriesLabelSynchronizerByEObject.containsKey(eObject)) {
            entriesLabelSynchronizer = this.entriesLabelSynchronizerByEObject.get(eObject);
        } else {
            entriesLabelSynchronizer = new HashMap();
            this.entriesLabelSynchronizerByEObject.put(eObject, entriesLabelSynchronizer);
        }
        if (!entriesLabelSynchronizer.containsKey(entry)) {
            entriesLabelSynchronizer.put(entry, new EntryPartLabelSynchronizer(entry, this.editorPartByEObject.get(eObject), this));
        }
    }

    protected void addPartLabelSynchronizerForPreferenceStore(EObject eObject) {
        IPreferenceStore preferenceStore;
        if (this.preferencePartLabelSynchronizers == null) {
            this.preferencePartLabelSynchronizers = new HashMap<EObject, PreferencePartLabelSynchronizer>();
        }
        if (!this.preferencePartLabelSynchronizers.containsKey(eObject) && (preferenceStore = InternationalizationPreferencesUtils.getPreferenceStore((EObject)eObject)) != null) {
            this.preferencePartLabelSynchronizers.put(eObject, new PreferencePartLabelSynchronizer(preferenceStore, eObject, this.editorPartByEObject.get(eObject), this));
        }
    }

    private class CreatePropertiesResourceCommand
    extends AbstractCommand {
        protected URI uri;
        protected InternationalizationEntry entryToAdd;
        protected Resource createdResource;
        protected Locale locale;

        public CreatePropertiesResourceCommand(URI uri, InternationalizationEntry entry, Locale locale) {
            super("Create properties resource");
            this.uri = uri.trimFileExtension().appendFileExtension(InternationalizationModelResource.this.getModelFileExtension());
            this.entryToAdd = entry;
            this.locale = locale;
        }

        protected boolean prepare() {
            return this.uri.fileExtension().equals("properties");
        }

        public void execute() {
            this.createdResource = InternationalizationModelResource.this.createResource(this.uri, this.locale);
            if (this.entryToAdd != null) {
                InternationalizationLibrary library = InternationalizationModelResource.this.getInternationalizationLibrary(this.createdResource);
                library.getEntries().add((Object)this.entryToAdd);
            }
            if (InternationalizationModelResource.this.modelSet.getResourcesToDeleteOnSave().contains(this.createdResource.getURI())) {
                InternationalizationModelResource.this.modelSet.getResourcesToDeleteOnSave().remove(this.createdResource.getURI());
            }
        }

        public void undo() {
            InternationalizationModelResource.this.unload(this.uri);
            this.createdResource.unload();
            InternationalizationModelResource.this.getResources().remove(this.createdResource);
            InternationalizationModelResource.this.modelSet.getResourcesToDeleteOnSave().add(this.createdResource.getURI());
        }

        public void redo() {
            this.execute();
        }
    }
}

