/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.export.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.gmfdiag.style.PapyrusDiagramStyle;
import org.eclipse.papyrus.uml.export.util.FileUtil;
import org.eclipse.uml2.uml.Element;

public class IconHelper {
    private static final String PREFIX_UML_PLATFORM_URL = "platform:/plugin/org.eclipse.uml2.uml.edit/icons/full/obj16/";
    public static final String UNKNOW_ICON = "unknow.jpg";
    public static Map<String, String> diagramKindIdToIconName = new HashMap<String, String>();
    public static Map<String, String> IconNameToPlatformURL = new HashMap<String, String>();

    public static String getIconName(Diagram d) {
        for (Object object : d.getStyles()) {
            if (!(object instanceof PapyrusDiagramStyle)) continue;
            PapyrusDiagramStyle papyrusDiagramStyle = (PapyrusDiagramStyle)object;
            String diagramKindId = papyrusDiagramStyle.getDiagramKindId();
            String cachedValue = diagramKindIdToIconName.get(diagramKindId);
            if (cachedValue != null) {
                return cachedValue;
            }
            RepresentationKind representationKindbyId = IconHelper.getRepresentationKindbyId(diagramKindId);
            if (representationKindbyId == null) continue;
            String platformURL = representationKindbyId.getIcon();
            String iconName = FileUtil.getNameFromPlatformURL(platformURL);
            diagramKindIdToIconName.put(diagramKindId, iconName);
            IconNameToPlatformURL.put(iconName, platformURL);
            return iconName;
        }
        return UNKNOW_ICON;
    }

    public static String getIconName(Element element) {
        String name = element.eClass().getName();
        String key = String.valueOf(name) + ".gif";
        IconNameToPlatformURL.put(key, PREFIX_UML_PLATFORM_URL + key);
        return key;
    }

    public static RepresentationKind getRepresentationKindbyId(String diagramKindId) {
        Collection visibleArchitectureContexts = ArchitectureDomainManager.getInstance().getVisibleArchitectureContexts();
        for (MergedArchitectureContext mergedArchitectureContext : visibleArchitectureContexts) {
            if (!(mergedArchitectureContext instanceof MergedArchitectureDescriptionLanguage)) continue;
            Collection representationKinds = ((MergedArchitectureDescriptionLanguage)mergedArchitectureContext).getRepresentationKinds();
            for (RepresentationKind representationKind : representationKinds) {
                if (!representationKind.getId().equals(diagramKindId)) continue;
                return representationKind;
            }
        }
        return null;
    }

    public static void printIcon(IPath targetContainer) {
        Set<Map.Entry<String, String>> entrySet = IconNameToPlatformURL.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            FileUtil.copyFileFromPlatform(targetContainer, entry.getKey(), entry.getValue());
        }
    }
}

