/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.listeners;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionEventBroker;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.internal.operation.CenterEdgeEndModelChangeOperation;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.RefreshEdgeLayoutNotificationFilter;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class EdgeLayoutUpdaterModelChangeTrigger
implements ModelChangeTrigger {
    public static final int PRIORITY = 6;
    private static final Set<EStructuralFeature> REFRESH_FEATURES = new HashSet<EStructuralFeature>();
    private static final Set<EStructuralFeature> REFRESH_FEATURES_WITH_CONSEQUENCE = new HashSet<EStructuralFeature>();
    private static final Set<EStructuralFeature> CONSEQUENCE_FEATURES = new HashSet<EStructuralFeature>();
    private static final Set<EStructuralFeature> MOVE_OR_RESIZE_FEATURES = new HashSet<EStructuralFeature>();
    private TransactionalEditingDomain domain;
    private SessionEventBroker eventBroker;
    private RefreshEdgeLayoutNotificationFilter refreshEdgeLayoutNotificationFilter;

    static {
        REFRESH_FEATURES_WITH_CONSEQUENCE.add((EStructuralFeature)DiagramPackage.Literals.EDGE_STYLE__CENTERED);
        REFRESH_FEATURES_WITH_CONSEQUENCE.add((EStructuralFeature)NotationPackage.Literals.ROUTING_STYLE__ROUTING);
        REFRESH_FEATURES.addAll(REFRESH_FEATURES_WITH_CONSEQUENCE);
        REFRESH_FEATURES.add((EStructuralFeature)DiagramPackage.Literals.DEDGE__OWNED_STYLE);
        REFRESH_FEATURES.add((EStructuralFeature)NotationPackage.Literals.DIAGRAM__PERSISTED_EDGES);
        CONSEQUENCE_FEATURES.add((EStructuralFeature)ViewpointPackage.Literals.CUSTOMIZABLE__CUSTOM_FEATURES);
        CONSEQUENCE_FEATURES.add((EStructuralFeature)DiagramPackage.Literals.EDGE_STYLE__ROUTING_STYLE);
        MOVE_OR_RESIZE_FEATURES.add((EStructuralFeature)NotationPackage.Literals.LOCATION__X);
        MOVE_OR_RESIZE_FEATURES.add((EStructuralFeature)NotationPackage.Literals.LOCATION__Y);
        MOVE_OR_RESIZE_FEATURES.add((EStructuralFeature)NotationPackage.Literals.SIZE__WIDTH);
        MOVE_OR_RESIZE_FEATURES.add((EStructuralFeature)NotationPackage.Literals.SIZE__HEIGHT);
        MOVE_OR_RESIZE_FEATURES.add((EStructuralFeature)NotationPackage.Literals.NODE__LAYOUT_CONSTRAINT);
        MOVE_OR_RESIZE_FEATURES.add((EStructuralFeature)NotationPackage.Literals.EDGE__BENDPOINTS);
    }

    public EdgeLayoutUpdaterModelChangeTrigger(Session session, DDiagram dDiagram) {
        this.domain = session.getTransactionalEditingDomain();
        this.eventBroker = session.getEventBroker();
        this.refreshEdgeLayoutNotificationFilter = new RefreshEdgeLayoutNotificationFilter(dDiagram);
        this.eventBroker.addLocalTrigger((NotificationFilter)this.refreshEdgeLayoutNotificationFilter, (ModelChangeTrigger)this);
    }

    public Option<Command> localChangesAboutToCommit(Collection<Notification> notifications) {
        EdgeLayoutUpdaterCommand command = null;
        HashSet<Edge> edgesWithCreatedCommand = new HashSet<Edge>();
        ArrayList<AbstractModelChangeOperation<Void>> operations = new ArrayList<AbstractModelChangeOperation<Void>>();
        HashMap<Notification, Edge> notifToEdge = new HashMap<Notification, Edge>();
        HashMap<Notification, Node> notifToNode = new HashMap<Notification, Node>();
        ArrayList<View> movedOrResizedViews = new ArrayList<View>();
        this.prepareData(notifications, notifToEdge, notifToNode, movedOrResizedViews);
        for (Notification notification : notifications) {
            Optional<Edge> optionalGmfEdge;
            if (!this.isRefreshEdgeLayoutNeededForNotification(notification, notifToEdge, movedOrResizedViews) || !(optionalGmfEdge = this.getCorrespondingEdge(notification, notifToEdge)).isPresent() || !edgesWithCreatedCommand.add(optionalGmfEdge.get())) continue;
            boolean useFigure = this.otherNotificationsAreConsequences(notification, optionalGmfEdge.get(), notifications, notifToEdge);
            CenterEdgeEndModelChangeOperation operation = new CenterEdgeEndModelChangeOperation(optionalGmfEdge.get(), useFigure);
            operations.add(operation);
        }
        if (!operations.isEmpty()) {
            command = new EdgeLayoutUpdaterCommand(this.domain, operations);
        }
        return Options.newSome(command);
    }

    private void prepareData(Collection<Notification> notifications, Map<Notification, Edge> notifToEdge, Map<Notification, Node> notifToNode, List<View> moveOrResizeViews) {
        for (Notification notification : notifications) {
            if (!MOVE_OR_RESIZE_FEATURES.contains(notification.getFeature())) continue;
            this.getCorrespondingView(notification, notifToEdge, notifToNode).ifPresent(moveOrResizeViews::add);
        }
    }

    public int priority() {
        return 6;
    }

    public void dispose() {
        this.refreshEdgeLayoutNotificationFilter = null;
        this.eventBroker.removeLocalTrigger((ModelChangeTrigger)this);
        this.eventBroker = null;
        this.domain = null;
    }

    public boolean otherNotificationsAreConsequences(final Notification notification, final Edge gmfEdge, Collection<Notification> notifications, final Map<Notification, Edge> notifToEdge) {
        boolean otherNotificationsAreIndirectlyConcerned = false;
        if (notifications.size() == 1 && REFRESH_FEATURES.contains(notifications.iterator().next().getFeature())) {
            otherNotificationsAreIndirectlyConcerned = true;
        } else if (REFRESH_FEATURES_WITH_CONSEQUENCE.contains(notification.getFeature())) {
            otherNotificationsAreIndirectlyConcerned = Iterables.all(notifications, (Predicate)new Predicate<Notification>(){

                public boolean apply(Notification currentNotification) {
                    boolean considerAsConsequence = false;
                    if (currentNotification == notification) {
                        considerAsConsequence = true;
                    } else {
                        Optional optionalEdge = EdgeLayoutUpdaterModelChangeTrigger.this.getCorrespondingEdge(currentNotification, notifToEdge);
                        if (optionalEdge.isPresent()) {
                            considerAsConsequence = ((Edge)optionalEdge.get()).equals(gmfEdge) && CONSEQUENCE_FEATURES.contains(currentNotification.getFeature());
                        }
                    }
                    return considerAsConsequence;
                }
            });
        }
        return otherNotificationsAreIndirectlyConcerned;
    }

    private boolean isRefreshEdgeLayoutNeededForNotification(Notification notification, Map<Notification, Edge> notifToEdge, List<View> movedOrResizedViews) {
        Edge referenceEdge;
        Optional<Edge> optionalEdge;
        return REFRESH_FEATURES.contains(notification.getFeature()) && (optionalEdge = this.getCorrespondingEdge(notification, notifToEdge)).isPresent() && !movedOrResizedViews.contains((referenceEdge = optionalEdge.get()).getSource()) && !movedOrResizedViews.contains(referenceEdge.getTarget());
    }

    private Optional<? extends View> getCorrespondingView(Notification notification, Map<Notification, Edge> notifToEdge, Map<Notification, Node> notifToNode) {
        Optional<Node> result = this.getCorrespondingNode(notification, notifToNode);
        if (!result.isPresent()) {
            result = this.getCorrespondingEdge(notification, notifToEdge);
        }
        return result;
    }

    private Optional<Edge> getCorrespondingEdge(Notification notification, Map<Notification, Edge> notifToEdge) {
        if (notifToEdge.containsKey(notification)) {
            return Optional.ofNullable(notifToEdge.get(notification));
        }
        Edge gmfEdge = null;
        Object notifier = notification.getNotifier();
        if (notifier instanceof Edge) {
            gmfEdge = (Edge)notifier;
        } else if (notifier instanceof DEdge) {
            gmfEdge = SiriusGMFHelper.getGmfEdge((DDiagramElement)((DEdge)notifier));
        } else if (notifier instanceof EdgeStyle) {
            EObject container = ((EdgeStyle)notifier).eContainer();
            if (container instanceof DEdge) {
                gmfEdge = SiriusGMFHelper.getGmfEdge((DDiagramElement)((DEdge)container));
            }
        } else if (notifier instanceof RoutingStyle) {
            EObject container = ((RoutingStyle)notifier).eContainer();
            if (container instanceof Edge) {
                gmfEdge = (Edge)container;
            }
        } else if (notifier instanceof Diagram && notification.getNewValue() instanceof Edge) {
            gmfEdge = (Edge)notification.getNewValue();
        } else if (notifier instanceof RelativeBendpoints) {
            gmfEdge = (Edge)((RelativeBendpoints)notifier).eContainer();
        }
        notifToEdge.put(notification, gmfEdge);
        return Optional.ofNullable(gmfEdge);
    }

    private Optional<Node> getCorrespondingNode(Notification notification, Map<Notification, Node> notifToNode) {
        EObject container;
        if (notifToNode.containsKey(notification)) {
            return Optional.ofNullable(notifToNode.get(notification));
        }
        Node gmfNode = null;
        Object notifier = notification.getNotifier();
        if (notifier instanceof DNode) {
            gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)((DNode)notifier));
        } else if (notifier instanceof Style) {
            EObject container2 = ((Style)notifier).eContainer();
            if (container2 instanceof DNode) {
                gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)((DNode)container2));
            }
        } else if (notifier instanceof Location && (container = ((Location)notifier).eContainer()) instanceof Node) {
            gmfNode = (Node)container;
        }
        notifToNode.put(notification, gmfNode);
        return Optional.ofNullable(gmfNode);
    }

    private static final class EdgeLayoutUpdaterCommand
    extends RecordingCommand {
        private Collection<AbstractModelChangeOperation<Void>> operations;

        public EdgeLayoutUpdaterCommand(TransactionalEditingDomain domain, Collection<AbstractModelChangeOperation<Void>> operations) {
            super(domain);
            this.operations = operations;
        }

        protected void doExecute() {
            for (AbstractModelChangeOperation<Void> operation : this.operations) {
                operation.execute();
            }
        }
    }
}

