import { TextDocument, Position, CompletionList, Hover, Range, SymbolInformation, Diagnostic, Location, DocumentHighlight, CodeActionContext, Command, WorkspaceEdit, Color, ColorInformation, ColorPresentation, FoldingRange, CodeAction, DocumentLink, SelectionRange } from 'vscode-languageserver-types';
import { LanguageSettings, ICompletionParticipant, DocumentContext, LanguageServiceOptions } from './cssLanguageTypes';
export declare type Stylesheet = {};
export * from './cssLanguageTypes';
export * from 'vscode-languageserver-types';
export interface LanguageService {
    configure(raw?: LanguageSettings): void;
    doValidation(document: TextDocument, stylesheet: Stylesheet, documentSettings?: LanguageSettings): Diagnostic[];
    parseStylesheet(document: TextDocument): Stylesheet;
    doComplete(document: TextDocument, position: Position, stylesheet: Stylesheet): CompletionList;
    setCompletionParticipants(registeredCompletionParticipants: ICompletionParticipant[]): void;
    doHover(document: TextDocument, position: Position, stylesheet: Stylesheet): Hover | null;
    findDefinition(document: TextDocument, position: Position, stylesheet: Stylesheet): Location | null;
    findReferences(document: TextDocument, position: Position, stylesheet: Stylesheet): Location[];
    findDocumentHighlights(document: TextDocument, position: Position, stylesheet: Stylesheet): DocumentHighlight[];
    findDocumentLinks(document: TextDocument, stylesheet: Stylesheet, documentContext: DocumentContext): DocumentLink[];
    /**
     * Return statically resolved links, and dynamically resolved links if `fsProvider` is proved.
     */
    findDocumentLinks2(document: TextDocument, stylesheet: Stylesheet, documentContext: DocumentContext): Promise<DocumentLink[]>;
    findDocumentSymbols(document: TextDocument, stylesheet: Stylesheet): SymbolInformation[];
    doCodeActions(document: TextDocument, range: Range, context: CodeActionContext, stylesheet: Stylesheet): Command[];
    doCodeActions2(document: TextDocument, range: Range, context: CodeActionContext, stylesheet: Stylesheet): CodeAction[];
    /**
     * @deprecated use findDocumentColors instead
     */
    findColorSymbols(document: TextDocument, stylesheet: Stylesheet): Range[];
    findDocumentColors(document: TextDocument, stylesheet: Stylesheet): ColorInformation[];
    getColorPresentations(document: TextDocument, stylesheet: Stylesheet, color: Color, range: Range): ColorPresentation[];
    doRename(document: TextDocument, position: Position, newName: string, stylesheet: Stylesheet): WorkspaceEdit;
    getFoldingRanges(document: TextDocument, context?: {
        rangeLimit?: number;
    }): FoldingRange[];
    getSelectionRanges(document: TextDocument, positions: Position[], stylesheet: Stylesheet): SelectionRange[];
}
export declare function getCSSLanguageService(options?: LanguageServiceOptions): LanguageService;
export declare function getSCSSLanguageService(options?: LanguageServiceOptions): LanguageService;
export declare function getLESSLanguageService(options?: LanguageServiceOptions): LanguageService;
