/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.log;

import org.cloudfoundry.client.lib.domain.ApplicationLog;
import org.eclipse.cft.server.core.internal.log.CloudLog;
import org.eclipse.cft.server.core.internal.log.LogContentType;

public class AppLogUtil {
    public static LogContentType getTypeFromV1(ApplicationLog.MessageType v1Type) {
        if (v1Type == null) {
            return LogContentType.APPLICATION_LOG_UNKNOWN;
        }
        switch (v1Type) {
            case STDOUT: {
                return LogContentType.APPLICATION_LOG_STD_OUT;
            }
            case STDERR: {
                return LogContentType.APPLICATION_LOG_STS_ERROR;
            }
        }
        return LogContentType.APPLICATION_LOG_UNKNOWN;
    }

    public static ApplicationLog.MessageType getV1Type(LogContentType logType) {
        if (logType == LogContentType.APPLICATION_LOG_STS_ERROR) {
            return ApplicationLog.MessageType.STDERR;
        }
        return ApplicationLog.MessageType.STDOUT;
    }

    public static CloudLog getLogFromV1(ApplicationLog v1Log) {
        return new CloudLog(v1Log.getAppId(), AppLogUtil.format(v1Log.getMessage()), v1Log.getTimestamp(), AppLogUtil.getTypeFromV1(v1Log.getMessageType()), v1Log.getSourceName(), v1Log.getSourceId());
    }

    public static ApplicationLog getV1Log(CloudLog log) {
        return new ApplicationLog(log.getAppId(), log.getMessage(), log.getTimestamp(), AppLogUtil.getV1Type(log.getLogType()), log.getSourceName(), log.getSourceId());
    }

    public static String format(String message) {
        if (message.contains("\n") || message.contains("\r")) {
            return message;
        }
        return String.valueOf(message) + '\n';
    }
}

